/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock2.touching;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.multiblock2.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock2.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock2.MultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock2.modular.IModularMultiblockController;
import net.roguelogix.phosphophyllite.multiblock2.modular.MultiblockControllerModule;
import net.roguelogix.phosphophyllite.multiblock2.modular.MultiblockControllerModuleRegistry;
import net.roguelogix.phosphophyllite.multiblock2.rectangular.IRectangularMultiblock;
import net.roguelogix.phosphophyllite.multiblock2.rectangular.IRectangularMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock2.touching.ITouchingMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock2.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.multiblock2.validated.IValidatedMultiblockControllerModule;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.VectorUtil;

@NonnullDefault
public interface ITouchingMultiblock<TileType extends BlockEntity & IRectangularMultiblockTile<TileType, BlockType, ControllerType>, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType> & IRectangularMultiblock<TileType, BlockType, ControllerType>>
extends IModularMultiblockController<TileType, BlockType, ControllerType> {

    public static final class Module<TileType extends BlockEntity & IRectangularMultiblockTile<TileType, BlockType, ControllerType>, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType> & IRectangularMultiblock<TileType, BlockType, ControllerType>>
    extends MultiblockControllerModule<TileType, BlockType, ControllerType>
    implements IValidatedMultiblockControllerModule {
        private boolean assembled = false;
        final Vector3i min = new Vector3i();
        final Vector3i max = new Vector3i();
        private final FastArraySet<ITouchingMultiblockTile.Module<TileType, BlockType, ControllerType>> touchingModules = new FastArraySet();
        private final FastArraySet<MultiblockTileModule<TileType, BlockType, ControllerType>> multiblockModules = new FastArraySet();

        @OnModLoad
        public static void register() {
            MultiblockControllerModuleRegistry.registerModule(ITouchingMultiblock.class, Module::new);
        }

        public Module(IModularMultiblockController<TileType, BlockType, ControllerType> controller) {
            super(controller);
        }

        @Override
        public void onStateTransition(IValidatedMultiblock.AssemblyState oldAssemblyState, IValidatedMultiblock.AssemblyState newAssemblyState) {
            switch (newAssemblyState) {
                case ASSEMBLED: {
                    this.assembled = true;
                    Vector3ic min = this.controller.min();
                    Vector3ic max = this.controller.max();
                    this.min.set(min);
                    this.max.set(max);
                    for (int i = 0; i < this.touchingModules.size(); ++i) {
                        ITouchingMultiblockTile.Module<TileType, BlockType, ControllerType> module = this.touchingModules.get(i);
                        module.assembled = true;
                        module.min.set(min);
                        module.max.set(max);
                    }
                    break;
                }
                case DISASSEMBLED: {
                    int i;
                    if (oldAssemblyState == IValidatedMultiblock.AssemblyState.DISASSEMBLED) break;
                    Vector3ic minE = this.controller.min();
                    Vector3ic maxE = this.controller.max();
                    for (i = 0; i < this.multiblockModules.size(); ++i) {
                        MultiblockTileModule<TileType, BlockType, ControllerType> module = this.multiblockModules.get(i);
                        BlockPos modulePos = ((BlockEntity)module.iface).m_58899_();
                        if (modulePos.m_123341_() != minE.x() && modulePos.m_123341_() != maxE.x() && modulePos.m_123342_() != minE.y() && modulePos.m_123342_() != maxE.y() && modulePos.m_123343_() != minE.z() && modulePos.m_123343_() != maxE.z()) continue;
                        module.attachToNeighborsLater();
                    }
                    this.assembled = false;
                    for (i = 0; i < this.touchingModules.size(); ++i) {
                        this.touchingModules.get((int)i).assembled = false;
                    }
                    this.min.set(0);
                    this.max.set(0);
                }
            }
        }

        @Override
        public boolean canAttachPart(TileType tile) {
            if (this.min.equals(this.max)) {
                return true;
            }
            BlockPos blockpos = tile.m_58899_();
            return !VectorUtil.less(blockpos, (Vector3ic)this.min) && !VectorUtil.greater(blockpos, (Vector3ic)this.max);
        }

        @Override
        public void onPartAdded(@Nonnull TileType tile) {
            ITouchingMultiblockTile.Module module = Objects.requireNonNull(((IModularTile)tile).module(ITouchingMultiblockTile.class, ITouchingMultiblockTile.Module.class));
            if (module.assembled && !this.assembled) {
                this.assembled = true;
                this.min.set(module.min);
                this.max.set(module.max);
            }
            this.touchingModules.add(module);
            this.multiblockModules.add(((IMultiblockTile)tile).multiblockModule());
        }

        @Override
        public void onPartRemoved(@Nonnull TileType tile) {
            this.touchingModules.remove(Objects.requireNonNull(((IModularTile)tile).module(ITouchingMultiblockTile.class, ITouchingMultiblockTile.Module.class)));
            this.multiblockModules.remove(((IMultiblockTile)tile).multiblockModule());
        }
    }
}

