/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.modular.tile.IIsTickingTracker;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyStateBlock;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.registry.OnModLoad;

@Deprecated(forRemoval=true)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockTileModule<TileType extends BlockEntity, ControllerType extends MultiblockController<TileType, ControllerType>>
extends TileModule<TileType>
implements IIsTickingTracker {
    private final boolean ASSEMBLY_STATE;
    protected ControllerType controller;
    protected final MultiblockTileModule<TileType, ControllerType>[] neighbors;
    protected final BlockEntity[] neighborTiles;
    long lastSavedTick;
    private boolean allowAttach;
    boolean isSaveDelegate;
    private static Level lastLevel;
    private static ChunkAccess lastChunk;
    private static long lastChunkPos;
    boolean preExistingBlock;
    CompoundTag cachedNBT;

    public ControllerType controller() {
        return this.controller;
    }

    @Nullable
    public MultiblockTileModule<TileType, ControllerType> getNeighbor(Direction direction) {
        return this.neighbors[direction.m_122411_()];
    }

    void updateNeighbors() {
        if (this.controller == null) {
            return;
        }
        BlockPos pos = ((BlockEntity)this.iface).m_58899_();
        for (Direction value : Direction.values()) {
            this.neighbors[value.m_122411_()] = ((MultiblockController)this.controller).blocks.getModule(pos.m_123341_() + value.m_122429_(), pos.m_123342_() + value.m_122430_(), pos.m_123343_() + value.m_122431_());
        }
        for (int i = 0; i < this.neighbors.length; ++i) {
            MultiblockTileModule<TileType, ControllerType> neighbor = this.neighbors[i];
            if (neighbor == null) continue;
            neighbor.neighbors[Direction.m_122376_((int)i).m_122424_().m_122411_()] = this;
            neighbor.neighborTiles[Direction.m_122376_((int)i).m_122424_().m_122411_()] = (BlockEntity)this.iface;
        }
    }

    void nullNeighbors() {
        for (int i = 0; i < this.neighbors.length; ++i) {
            MultiblockTileModule<TileType, ControllerType> neighbor = this.neighbors[i];
            if (neighbor == null) continue;
            neighbor.neighbors[Direction.m_122376_((int)i).m_122424_().m_122411_()] = null;
            neighbor.neighborTiles[Direction.m_122376_((int)i).m_122424_().m_122411_()] = null;
        }
        for (Direction value : Direction.values()) {
            this.neighbors[value.m_122411_()] = null;
        }
    }

    @OnModLoad
    static void onModLoad() {
        ModuleRegistry.registerTileModule(IMultiblockTile.class, IMultiblockTile::createMultiblockModule);
    }

    public MultiblockTileModule(IModularTile blockEntity) {
        super(blockEntity);
        this.ASSEMBLY_STATE = ((BlockEntity)this.iface).m_58900_().m_61138_((Property)IAssemblyStateBlock.ASSEMBLED);
        this.neighbors = new MultiblockTileModule[6];
        this.neighborTiles = new BlockEntity[6];
        this.lastSavedTick = 0L;
        this.allowAttach = false;
        this.isSaveDelegate = false;
        this.preExistingBlock = false;
        this.cachedNBT = null;
    }

    @Override
    public String saveKey() {
        return "phosphophyllite_multiblock";
    }

    protected BlockState assembledBlockState(BlockState state) {
        if (this.ASSEMBLY_STATE) {
            state = (BlockState)state.m_61124_((Property)IAssemblyStateBlock.ASSEMBLED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected BlockState disassembledBlockState(BlockState state) {
        if (this.ASSEMBLY_STATE) {
            state = (BlockState)state.m_61124_((Property)IAssemblyStateBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public void attachToNeighbors() {
        assert (((BlockEntity)this.iface).m_58904_() != null);
        if (((BlockEntity)this.iface).m_58904_().f_46443_) {
            return;
        }
        if (!this.allowAttach) {
            return;
        }
        BlockPos pos = ((BlockEntity)this.iface).m_58899_();
        if (((BlockEntity)this.iface).m_58904_().m_7702_(pos) != this.iface) {
            return;
        }
        if (this.ASSEMBLY_STATE) {
            Level level = ((BlockEntity)this.iface).m_58904_();
            long chunkPos = ChunkPos.m_45589_((int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4));
            if (lastLevel != level || chunkPos != lastChunkPos) {
                lastLevel = ((BlockEntity)this.iface).m_58904_();
                lastChunkPos = chunkPos;
                lastChunk = level.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            }
            lastChunk.m_6978_(pos, (BlockState)((BlockEntity)this.iface).m_58900_().m_61124_((Property)IAssemblyStateBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false)), false);
        }
        if (this.controller != null) {
            ((MultiblockController)this.controller).detach(this, false, false, true);
            this.controller = null;
        }
        BlockPos.MutableBlockPos possibleTilePos = new BlockPos.MutableBlockPos();
        ChunkAccess lastChunk = null;
        long lastChunkPos = 0L;
        for (Direction value : Direction.values()) {
            BlockEntity possibleTile;
            possibleTilePos.m_122190_((Vec3i)pos);
            possibleTilePos.m_122173_(value);
            long currentChunkPos = ChunkPos.m_45589_((int)(possibleTilePos.m_123341_() >> 4), (int)(possibleTilePos.m_123343_() >> 4));
            if (lastChunk == null || currentChunkPos != lastChunkPos) {
                lastChunkPos = currentChunkPos;
                lastChunk = ((BlockEntity)this.iface).m_58904_().m_6522_(possibleTilePos.m_123341_() >> 4, possibleTilePos.m_123343_() >> 4, ChunkStatus.f_62326_, false);
            }
            if (lastChunk == null || !((possibleTile = lastChunk.m_7702_((BlockPos)possibleTilePos)) instanceof IMultiblockTile) || ((IMultiblockTile)possibleTile).multiblockModule().controller == null) continue;
            ((MultiblockController)((IMultiblockTile)possibleTile).multiblockModule().controller).attemptAttach(this);
        }
        if (this.controller == null) {
            ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).createController()).attemptAttach(this);
        }
    }

    @Override
    public void readNBT(CompoundTag compound) {
        this.cachedNBT = compound;
        this.isSaveDelegate = compound.m_128471_("isSaveDelegate");
        this.preExistingBlock = true;
    }

    @Override
    @Nullable
    public CompoundTag writeNBT() {
        if (this.cachedNBT != null) {
            return this.cachedNBT;
        }
        CompoundTag compound = new CompoundTag();
        if (this.isSaveDelegate && this.controller != null && ((MultiblockController)this.controller).blocks.containsModule(this)) {
            compound.m_128365_("controllerData", (Tag)((MultiblockController)this.controller).getNBT());
            compound.m_128379_("isSaveDelegate", this.isSaveDelegate);
        }
        return compound;
    }

    @Override
    public void onAdded() {
        assert (((BlockEntity)this.iface).m_58904_() != null);
        if (((BlockEntity)this.iface).m_58904_().f_46443_) {
            this.cachedNBT = null;
        }
    }

    @Override
    public void startTicking() {
        this.allowAttach = true;
        if (this.cachedNBT != null) {
            this.preExistingBlock = true;
        }
        this.attachToNeighbors();
    }

    @Override
    public void stopTicking() {
        if (this.controller != null) {
            this.allowAttach = false;
            this.cachedNBT = this.writeNBT();
            ((MultiblockController)this.controller).detach(this, true, false);
        }
    }

    @Override
    public void onRemoved(boolean chunkUnload) {
        if (this.controller != null) {
            ((MultiblockController)this.controller).detach(this, chunkUnload, !chunkUnload);
        }
        this.allowAttach = false;
    }

    @Override
    @Nullable
    public DebugInfo getDebugInfo() {
        DebugInfo debugInfo = new DebugInfo(this.getClass().getSimpleName());
        ControllerType controller = this.controller();
        if (controller == null) {
            debugInfo.add("Null Multiblock controller");
        } else {
            debugInfo.add(((MultiblockController)controller).getDebugInfo());
        }
        return debugInfo;
    }
}

