/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.modular.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.debug.IDebuggable;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@NonnullDefault
public class PhosphophylliteTile
extends BlockEntity
implements IModularTile,
IDebuggable {
    public static final Logger MODULE_LOGGER;
    @Deprecated(forRemoval=true)
    public static final Logger LOGGER;
    boolean removed = false;
    private final Object2ObjectOpenHashMap<Class<?>, TileModule<?>> modules = new Object2ObjectOpenHashMap();
    private final ArrayList<TileModule<?>> moduleList = new ArrayList();
    private final List<TileModule<?>> moduleListRO = Collections.unmodifiableList(this.moduleList);
    private static final Object2ObjectOpenHashMap<Level, ObjectArrayList<PhosphophylliteTile>> clientWorldUnloadEventTiles;
    private static final Object2ObjectOpenHashMap<Level, ObjectArrayList<PhosphophylliteTile>> serverWorldUnloadEventTiles;
    private int index = 0;
    private static final CompoundTag EMPTY_TAG;

    public PhosphophylliteTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        Class<?> thisClazz = this.getClass();
        ModuleRegistry.forEachTileModule((clazz, constructor) -> {
            if (clazz.isAssignableFrom(thisClazz)) {
                TileModule module = (TileModule)constructor.apply(this);
                this.modules.put(clazz, (Object)module);
                this.moduleList.add(module);
            }
        });
        this.moduleList.forEach((Consumer<TileModule<?>>)((Consumer<TileModule>)TileModule::postModuleConstruction));
    }

    @Override
    @Nullable
    public TileModule<?> module(Class<?> interfaceClazz) {
        return (TileModule)this.modules.get(interfaceClazz);
    }

    @Override
    public List<TileModule<?>> modules() {
        return this.moduleListRO;
    }

    public final void m_6339_() {
        super.m_6339_();
    }

    private static void worldUnloadEvent(LevelEvent.Unload unload) {
        ObjectArrayList removed = (ObjectArrayList)(unload.getLevel().m_5776_() ? clientWorldUnloadEventTiles : serverWorldUnloadEventTiles).remove((Object)((Level)unload.getLevel()));
        if (removed != null) {
            for (int i = 0; i < removed.size(); ++i) {
                ((PhosphophylliteTile)removed.get(i)).remove(true);
            }
        }
    }

    private static void serverStopEvent(ServerStoppedEvent stoppedEvent) {
        serverWorldUnloadEventTiles.clear();
    }

    public final void onLoad() {
        assert (this.f_58857_ != null);
        super.onLoad();
        this.moduleList.forEach((Consumer<TileModule<?>>)((Consumer<TileModule>)TileModule::onAdded));
        this.onAdded();
        ObjectArrayList worldUnloadTiles = (ObjectArrayList)(this.f_58857_.m_5776_() ? clientWorldUnloadEventTiles : serverWorldUnloadEventTiles).computeIfAbsent((Object)this.f_58857_, __ -> new ObjectArrayList());
        this.index = worldUnloadTiles.size();
        worldUnloadTiles.add((Object)this);
    }

    public void onAdded() {
    }

    public final void m_7651_() {
        super.m_7651_();
        this.remove(false);
    }

    public final void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.remove(true);
    }

    private void remove(boolean chunkUnload) {
        PhosphophylliteTile arrayTile;
        if (this.removed) {
            return;
        }
        assert (this.f_58857_ != null);
        this.onRemoved(chunkUnload);
        this.moduleList.forEach((Consumer<TileModule<?>>)((Consumer<TileModule>)module -> module.onRemoved(chunkUnload)));
        this.removed = true;
        if (this.index == -1) {
            return;
        }
        ObjectArrayList worldUnloadTiles = (ObjectArrayList)(this.f_58857_.m_5776_() ? clientWorldUnloadEventTiles : serverWorldUnloadEventTiles).get((Object)this.f_58857_);
        if (worldUnloadTiles != null && (arrayTile = (PhosphophylliteTile)worldUnloadTiles.get(this.index)) == this) {
            PhosphophylliteTile removed = (PhosphophylliteTile)worldUnloadTiles.pop();
            if (removed != this) {
                removed.index = this.index;
                worldUnloadTiles.set(this.index, (Object)removed);
            }
            this.index = -1;
        }
    }

    public void onRemoved(boolean chunkUnload) {
    }

    public final void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("local")) {
            CompoundTag local = compound.m_128469_("local");
            this.readNBT(local);
        }
        CompoundTag subNBTs = compound.m_128469_("sub");
        for (TileModule<?> module : this.moduleList) {
            String key = module.saveKey();
            if (key == null || !subNBTs.m_128441_(key)) continue;
            CompoundTag nbt = subNBTs.m_128469_(key);
            module.readNBT(nbt);
        }
    }

    @Nullable
    private CompoundTag subNBTs(Function<TileModule<?>, CompoundTag> nbtSupplier) {
        CompoundTag subNBTs = new CompoundTag();
        for (TileModule<?> module : this.moduleList) {
            String key;
            CompoundTag nbt = nbtSupplier.apply(module);
            if (nbt == null || (key = module.saveKey()) == null) continue;
            if (subNBTs.m_128441_(key)) {
                MODULE_LOGGER.warn("Multiple modules with the same save key \"" + key + "\" for tile type \"" + this.getClass().getSimpleName() + "\" at " + this.m_58899_());
            }
            subNBTs.m_128365_(key, (Tag)nbt);
        }
        if (subNBTs.m_128456_()) {
            return null;
        }
        return subNBTs;
    }

    public final void m_183515_(CompoundTag nbt) {
        CompoundTag localNBT;
        CompoundTag subNBTs = this.subNBTs(TileModule::writeNBT);
        if (subNBTs != null) {
            nbt.m_128365_("sub", (Tag)subNBTs);
        }
        if (!(localNBT = this.writeNBT()).m_128456_()) {
            nbt.m_128365_("local", (Tag)localNBT);
        }
    }

    protected void readNBT(CompoundTag compound) {
    }

    protected CompoundTag writeNBT() {
        return new CompoundTag();
    }

    public final void handleUpdateTag(CompoundTag compound) {
        super.handleUpdateTag(compound);
        if (compound.m_128441_("local")) {
            CompoundTag local = compound.m_128469_("local");
            this.handleDataNBT(local);
        }
        CompoundTag subNBTs = compound.m_128469_("sub");
        for (TileModule<?> module : this.moduleList) {
            String key = module.saveKey();
            if (key == null) continue;
            CompoundTag nbt = EMPTY_TAG;
            if (subNBTs.m_128441_(key)) {
                nbt = subNBTs.m_128469_(key);
            }
            module.handleDataNBT(nbt);
            if (nbt != EMPTY_TAG || nbt.m_128456_()) continue;
            MODULE_LOGGER.warn("Module " + key + " wrote to NBT in read!");
            for (String str : EMPTY_TAG.m_128431_().toArray(new String[0])) {
                EMPTY_TAG.m_128473_(str);
            }
        }
    }

    public final CompoundTag m_5995_() {
        CompoundTag localNBT;
        CompoundTag nbt = super.m_5995_();
        CompoundTag subNBTs = this.subNBTs(TileModule::getDataNBT);
        if (subNBTs != null) {
            nbt.m_128365_("sub", (Tag)subNBTs);
        }
        if (!(localNBT = this.getDataNBT()).m_128456_()) {
            nbt.m_128365_("local", (Tag)localNBT);
        }
        return nbt;
    }

    protected void handleDataNBT(CompoundTag nbt) {
        this.readNBT(nbt);
    }

    protected CompoundTag getDataNBT() {
        return this.writeNBT();
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            return;
        }
        CompoundTag compound = pkt.m_131708_();
        if (compound.m_128441_("local")) {
            CompoundTag local = compound.m_128469_("local");
            this.handleUpdateNBT(local);
        }
        CompoundTag subNBTs = compound.m_128469_("sub");
        for (TileModule<?> module : this.moduleList) {
            String key = module.saveKey();
            if (key == null || !subNBTs.m_128441_(key)) continue;
            CompoundTag nbt = subNBTs.m_128469_(key);
            module.handleUpdateNBT(nbt);
        }
    }

    @Nullable
    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag localNBT;
        boolean sendPacket = false;
        CompoundTag subNBTs = this.subNBTs(TileModule::getUpdateNBT);
        CompoundTag nbt = new CompoundTag();
        if (subNBTs != null) {
            nbt.m_128365_("sub", (Tag)subNBTs);
        }
        if ((localNBT = this.getUpdateNBT()) != null) {
            sendPacket = true;
            nbt.m_128365_("local", (Tag)localNBT);
        }
        if (!sendPacket) {
            return null;
        }
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, e -> nbt);
    }

    protected void handleUpdateNBT(CompoundTag nbt) {
    }

    @Nullable
    protected CompoundTag getUpdateNBT() {
        return null;
    }

    @Nonnull
    public final <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> optional = this.capability(cap, side);
        for (TileModule<?> module : this.moduleList) {
            LazyOptional<T> moduleOptional = module.capability(cap, side);
            if (!moduleOptional.isPresent()) continue;
            if (optional.isPresent()) {
                MODULE_LOGGER.warn("Multiple implementations of same capability \"" + cap.getName() + "\" on " + side + " side for tile type \"" + this.getClass().getSimpleName() + "\" at " + this.m_58899_());
                continue;
            }
            optional = moduleOptional;
        }
        return optional;
    }

    @Nonnull
    public final <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return this.getCapability(cap, null);
    }

    protected <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }

    @Override
    @Nonnull
    public DebugInfo getDebugInfo() {
        DebugInfo moduleInfo = new DebugInfo("Module Debug Info");
        for (Map.Entry moduleEntry : this.modules.entrySet()) {
            DebugInfo moduleDebugInfo = ((TileModule)moduleEntry.getValue()).getDebugInfo();
            if (moduleDebugInfo == null) {
                Class interfaceClass = (Class)moduleEntry.getKey();
                moduleInfo.add(new DebugInfo(interfaceClass.getCanonicalName().substring(interfaceClass.getPackageName().length() + 1)));
                continue;
            }
            moduleInfo.add(moduleDebugInfo);
        }
        DebugInfo debugInfo = new DebugInfo(this.getClass().getSimpleName());
        debugInfo.add(moduleInfo);
        return debugInfo;
    }

    static {
        LOGGER = MODULE_LOGGER = LogManager.getLogger((String)"Phosphophyllite/ModularTile");
        clientWorldUnloadEventTiles = new Object2ObjectOpenHashMap();
        serverWorldUnloadEventTiles = new Object2ObjectOpenHashMap();
        MinecraftForge.EVENT_BUS.addListener(PhosphophylliteTile::serverStopEvent);
        MinecraftForge.EVENT_BUS.addListener(PhosphophylliteTile::worldUnloadEvent);
        EMPTY_TAG = new CompoundTag();
    }
}

