/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.data;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.config.ConfigType;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.parsers.JSON5;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class DatapackLoader<T> {
    private final SpecObjectNode baseSpecNode;
    private final Supplier<T> objectSupplier;

    public DatapackLoader(Supplier<T> objectSupplier) {
        T templateObject = objectSupplier.get();
        this.baseSpecNode = new SpecObjectNode(templateObject, "", ConfigType.NULL, new ConfigOptionsDefaults(ConfigType.NULL, false, false, false));
        this.objectSupplier = objectSupplier;
    }

    public List<T> loadAll(ResourceLocation baseResourceLocation) {
        if (Phosphophyllite.serverResourceManager == null) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList();
        Map resourceLocations = Phosphophyllite.serverResourceManager.m_214159_(baseResourceLocation.m_135815_(), s -> s.m_135815_().contains(".json"));
        for (Map.Entry entry : resourceLocations.entrySet()) {
            T t;
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            if (!resourceLocation.m_135827_().equals(baseResourceLocation.m_135827_()) || (t = this.load(resourceLocation, (Resource)entry.getValue())) == null) continue;
            list.add(t);
        }
        return list;
    }

    @Nullable
    public T load(ResourceLocation location) {
        if (Phosphophyllite.serverResourceManager == null) {
            return null;
        }
        return this.load(location, (Resource)Phosphophyllite.serverResourceManager.m_213713_(location).orElseThrow());
    }

    @Nullable
    private T load(ResourceLocation location, Resource resource) {
        String json;
        try (BufferedReader reader = resource.m_215508_();){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            json = builder.toString();
        }
        catch (IOException e) {
            Phosphophyllite.LOGGER.error("Error reading json at " + location.toString());
            e.printStackTrace();
            return null;
        }
        T object = this.objectSupplier.get();
        Element elements = JSON5.parseString(json);
        if (!this.baseSpecNode.setActiveObject(object)) {
            return null;
        }
        if (elements == null) {
            return object;
        }
        Element correctedElements = this.baseSpecNode.correctToValidState(elements);
        if (correctedElements == null) {
            return object;
        }
        this.baseSpecNode.writeElement(correctedElements);
        return object;
    }
}

