/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.whiteholes;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.phosphophyllite.modular.tile.PhosphophylliteTile;
import net.roguelogix.phosphophyllite.registry.RegisterTile;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemWhiteHoleTile
extends PhosphophylliteTile
implements IItemHandler {
    @RegisterTile(value="item_white_hole")
    public static final BlockEntityType.BlockEntitySupplier<ItemWhiteHoleTile> SUPPLIER = new RegisterTile.Producer<ItemWhiteHoleTile>(ItemWhiteHoleTile::new);
    Item item = null;

    public ItemWhiteHoleTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> capability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.capability(cap, side);
    }

    public void setItem(Item item) {
        this.item = item;
    }

    @Override
    @Nonnull
    public CompoundTag writeNBT() {
        CompoundTag compound = super.writeNBT();
        if (this.item != null) {
            compound.m_128359_("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.item)).toString());
        }
        return compound;
    }

    @Override
    public void readNBT(@Nonnull CompoundTag compound) {
        super.readNBT(compound);
        if (compound.m_128441_("item")) {
            this.item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("item")));
        }
    }

    public void tick() {
        if (this.item != null) {
            assert (this.f_58857_ != null);
            for (Direction direction : Direction.values()) {
                BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                if (te == null) continue;
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).ifPresent(c -> {
                    for (int i = 0; i < c.getSlots(); ++i) {
                        c.insertItem(i, new ItemStack((ItemLike)this.item, this.item.m_41459_()), false);
                    }
                });
            }
        }
    }

    public int getSlots() {
        return 128;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return new ItemStack((ItemLike)this.item, this.item.m_41459_());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return new ItemStack((ItemLike)this.item, amount);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

