/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.roguelogix.phosphophyllite.PhosphophylliteConfig;
import net.roguelogix.phosphophyllite.config.ConfigType;
import net.roguelogix.phosphophyllite.event.ReloadDataEvent;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.registry.RegisterConfig;
import net.roguelogix.phosphophyllite.registry.Registry;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.Queues;
import net.roguelogix.phosphophyllite.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod(value="phosphophyllite")
public class Phosphophyllite {
    public static final String modid = "phosphophyllite";
    public static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/Main");
    public static long lastTime = 0L;
    private static long tick = 0L;
    @RegisterConfig(folder="phosphophyllite", name="general", type={ConfigType.CLIENT, ConfigType.COMMON, ConfigType.SERVER}, rootLevelType=ConfigType.SERVER)
    public static final PhosphophylliteConfig CONFIG = new PhosphophylliteConfig();
    private static MinecraftServer server;
    public static ResourceManager serverResourceManager;
    @Deprecated(forRemoval=true)
    private static final HashMap<ServerLevel, ArrayList<MultiblockController<?, ?>>> controllersToTick;
    @Deprecated(forRemoval=true)
    private static final ArrayList<MultiblockController<?, ?>> newControllers;
    @Deprecated(forRemoval=true)
    private static final ArrayList<MultiblockController<?, ?>> oldControllers;

    public Phosphophyllite() {
        new Registry();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (Phosphophyllite.CONFIG.bypassPerformantCheck) {
            LOGGER.warn("Performant check bypassed");
            LOGGER.warn("Performant " + (FMLLoader.getLoadingModList().getModFileById("performant") != null ? "is" : "is not") + " present");
        } else if (FMLLoader.getLoadingModList().getModFileById("performant") != null) {
            throw new IllegalStateException("Performant is incompatible with Phosphophyllite\nThis is a known issue with performant and it breaking other mods, the author does not care\nGitHub issue on the matter: https://github.com/someaddons/performant_issues/issues/70\nTo bypass this check add \"bypassPerformantCheck = true\" to the top of your phosphophyllite config\nIf you bypass this check I (RogueLogix) will not provide any support for any issues related to Phosphophyllite or the mods that use it\nIf you believe your issue is unrelated, disable performant and reproduce it\nBy choosing to bypass this check you understand that here there be dragons");
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent serverStartedEvent) {
        server = serverStartedEvent.getServer();
        this.updateRegistries();
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent serverStoppedEvent) {
        serverResourceManager = null;
        server = null;
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent tagsUpdatedEvent) {
        this.updateRegistries();
    }

    void updateRegistries() {
        if (server == null) {
            return;
        }
        if (FMLLoader.getDist().isClient() && RenderSystem.m_69586_()) {
            return;
        }
        serverResourceManager = server.m_177941_();
        MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new ReloadDataEvent());
        controllersToTick.forEach((serverLevel, multiblockControllers) -> multiblockControllers.forEach(MultiblockController::revalidate));
    }

    public static long tickNumber() {
        return tick;
    }

    @Deprecated(forRemoval=true)
    public static void addController(MultiblockController<?, ?> controller) {
        newControllers.add(controller);
    }

    @Deprecated(forRemoval=true)
    public static void removeController(MultiblockController<?, ?> controller) {
        oldControllers.add(controller);
    }

    @Deprecated(forRemoval=true)
    @SubscribeEvent
    void onWorldUnload(LevelEvent.Unload worldUnloadEvent) {
        if (!worldUnloadEvent.getLevel().m_5776_()) {
            ArrayList<MultiblockController<?, ?>> controllersToTick = Phosphophyllite.controllersToTick.remove(worldUnloadEvent.getLevel());
            if (controllersToTick != null) {
                for (MultiblockController<?, ?> multiblockController2 : controllersToTick) {
                    multiblockController2.suicide();
                }
            }
            newControllers.removeIf(multiblockController -> multiblockController.getWorld() == worldUnloadEvent.getLevel());
            oldControllers.removeIf(multiblockController -> multiblockController.getWorld() == worldUnloadEvent.getLevel());
        }
    }

    @Deprecated(forRemoval=true)
    @SubscribeEvent
    void onServerStop(ServerStoppedEvent serverStoppedEvent) {
        controllersToTick.clear();
        newControllers.clear();
        oldControllers.clear();
    }

    @SubscribeEvent
    public void advanceTick(TickEvent.ServerTickEvent e) {
        if (!e.side.isServer()) {
            return;
        }
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ++tick;
        boolean[] run = new boolean[]{true};
        Queues.serverThread.enqueue(() -> {
            run[0] = false;
        }, new Event[0]);
        while (run[0]) {
            Queues.serverThread.runOne();
        }
        for (MultiblockController<?, ?> newController : newControllers) {
            controllersToTick.computeIfAbsent((ServerLevel)newController.getWorld(), k -> new ArrayList()).add(newController);
        }
        newControllers.clear();
        for (MultiblockController<?, ?> oldController : oldControllers) {
            ArrayList<MultiblockController<?, ?>> controllers = controllersToTick.get(oldController.getWorld());
            controllers.remove(oldController);
        }
        oldControllers.clear();
        Util.serverTick();
    }

    @SubscribeEvent
    public void advanceTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        boolean[] run = new boolean[]{true};
        Queues.clientThread.enqueue(() -> {
            run[0] = false;
        }, new Event[0]);
        while (run[0]) {
            Queues.clientThread.runOne();
        }
        Util.clientTick();
    }

    @SubscribeEvent
    public void tickWorld(TickEvent.LevelTickEvent e) {
        if (!(e.level instanceof ServerLevel)) {
            return;
        }
        Util.updateBlockStates(e.level);
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<MultiblockController<?, ?>> controllersToTick = Phosphophyllite.controllersToTick.get(e.level);
        if (controllersToTick != null) {
            for (MultiblockController<?, ?> controller : controllersToTick) {
                if (controller == null) continue;
                controller.update();
            }
        }
        Util.worldTickEndEvent(e.level);
    }

    static {
        controllersToTick = new HashMap();
        newControllers = new ArrayList();
        oldControllers = new ArrayList();
    }
}

