/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ChalkGlyphBlock
extends Block {
    public static final IntegerProperty SIGN = IntegerProperty.m_61631_((String)"sign", (int)0, (int)12);
    public static final int MAX_SIGN = 12;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)0.04, (double)15.0);
    protected Supplier<Item> chalk;
    protected int color;

    public ChalkGlyphBlock(BlockBehaviour.Properties properties, int color, Supplier<Item> chalk) {
        super(properties);
        this.color = color;
        this.chalk = chalk;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public Item getChalk() {
        return this.chalk.get();
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.m_7898_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_7471_(pos, false);
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return true;
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos down = pos.m_7495_();
        BlockState downState = worldIn.m_8055_(down);
        return downState.m_60783_((BlockGetter)worldIn, down, Direction.UP) && state.m_60767_().m_76336_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        int sign = context.m_43725_().m_213780_().m_188503_(13);
        BlockState current = context.m_43725_().m_8055_(pos);
        if (current.m_60734_() == this) {
            sign = ((Integer)current.m_61143_((Property)SIGN) + 1) % 13;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)SIGN, (Comparable)Integer.valueOf(sign))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SIGN, BlockStateProperties.f_61374_});
        super.m_7926_(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (ForgeRegistries.ITEMS.containsValue((Object)this.getChalk())) {
            return new ItemStack((ItemLike)this.getChalk());
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.OPEN;
    }
}

