/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AlertOthersPanicGoal
extends Goal {
    protected final PathfinderMob mob;
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected boolean isRunning;

    public AlertOthersPanicGoal(PathfinderMob mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        BlockPos blockpos;
        if (this.mob.m_21188_() == null || !this.mob.m_21188_().m_6084_()) {
            return false;
        }
        if (this.mob.m_6060_() && (blockpos = this.lookForWater((BlockGetter)this.mob.f_19853_, (Entity)this.mob, 5)) != null) {
            this.posX = blockpos.m_123341_();
            this.posY = blockpos.m_123342_();
            this.posZ = blockpos.m_123343_();
            return true;
        }
        if (this.mob.m_21188_() != null) {
            List mobs = this.mob.f_19853_.m_45976_(this.mob.getClass(), AABB.m_82333_((Vec3)this.mob.m_20182_()).m_82377_(8.0, 8.0, 8.0));
            for (PathfinderMob mob : mobs) {
                mob.m_6703_(this.mob.m_21188_());
            }
            return this.findRandomPosAway(this.mob.m_21188_());
        }
        return this.findRandomPosition();
    }

    protected boolean findRandomPosAway(LivingEntity entity) {
        Vec3 vec3 = LandRandomPos.m_148521_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)entity.m_20182_());
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.f_82479_;
        this.posY = vec3.f_82480_;
        this.posZ = vec3.f_82481_;
        return true;
    }

    protected boolean findRandomPosition() {
        Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this.mob, (int)5, (int)4);
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.f_82479_;
        this.posY = vec3.f_82480_;
        this.posZ = vec3.f_82481_;
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
        this.isRunning = true;
    }

    public void m_8041_() {
        this.isRunning = false;
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_();
    }

    @Nullable
    protected BlockPos lookForWater(BlockGetter pLevel, Entity pEntity, int pRange) {
        BlockPos blockpos = pEntity.m_20183_();
        return !pLevel.m_8055_(blockpos).m_60812_(pLevel, blockpos).m_83281_() ? null : (BlockPos)BlockPos.m_121930_((BlockPos)pEntity.m_20183_(), (int)pRange, (int)1, fluidState -> pLevel.m_6425_(fluidState).m_205070_(FluidTags.f_13131_)).orElse(null);
    }
}

