/*
 * Decompiled with CFR 0.152.
 */
package io.alwa.mods.myrtrees.common.blockentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import io.alwa.mods.myrtrees.common.MyrtreesConfig;
import io.alwa.mods.myrtrees.common.blockentity.WoodenBucketBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class WoodenBucketRenderer
implements BlockEntityRenderer<WoodenBucketBlockEntity> {
    public static ResourceLocation LATEX_TEXTURE = new ResourceLocation("myrtrees:block/latex");

    public WoodenBucketRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WoodenBucketBlockEntity bucket, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        int amount = bucket.latex;
        if (amount <= 0) {
            return;
        }
        float o0 = 0.25f;
        float o1 = 0.75f;
        float y0 = 0.375f;
        float y11 = 0.675f;
        float fluidLevel = y0 + (y11 - y0) * (float)amount / (float)MyrtreesConfig.BUCKET_CAPACITY;
        VertexConsumer buffer = multiBufferSource.m_6299_(RenderType.m_110466_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(LATEX_TEXTURE);
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float uo = (u1 - u0) / 16.0f;
        float vo = (v1 - v0) / 16.0f;
        int color = -1;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Direction facing = (Direction)bucket.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        float translation = 0.1875f;
        poseStack.m_85836_();
        if (facing.m_122434_() == Direction.Axis.X) {
            poseStack.m_85837_(facing.m_122421_() == Direction.AxisDirection.NEGATIVE ? (double)translation : (double)(-translation), 0.0, 0.0);
        } else {
            poseStack.m_85837_(0.0, 0.0, facing.m_122421_() == Direction.AxisDirection.NEGATIVE ? (double)translation : (double)(-translation));
        }
        Matrix4f m = poseStack.m_85850_().m_85861_();
        Matrix3f n = poseStack.m_85850_().m_85864_();
        buffer.m_85982_(m, o0, fluidLevel, o0).m_6122_(r, g, b, a).m_7421_(u0 + uo, v0 + vo).m_86008_(j).m_85969_(i).m_85977_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(m, o0, fluidLevel, o1).m_6122_(r, g, b, a).m_7421_(u1 - uo, v0 + vo).m_86008_(j).m_85969_(i).m_85977_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(m, o1, fluidLevel, o1).m_6122_(r, g, b, a).m_7421_(u1 - uo, v1 - vo).m_86008_(j).m_85969_(i).m_85977_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(m, o1, fluidLevel, o0).m_6122_(r, g, b, a).m_7421_(u0 + uo, v1 - vo).m_86008_(j).m_85969_(i).m_85977_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }
}

