/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.util.BlockStateUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;

public class PlateBlockStateProperties {
    public static final DirectionProperty ATTACHMENT_DIRECTION = BlockStateProperties.f_61372_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty INPUT_A = BooleanProperty.m_61465_((String)"input_a");
    public static final BooleanProperty INPUT_B = BooleanProperty.m_61465_((String)"input_b");
    public static final BooleanProperty INPUT_C = BooleanProperty.m_61465_((String)"input_c");
    public static final Material PLATE_MATERIAL = new Material(MaterialColor.f_76409_, false, true, true, true, false, false, PushReaction.NORMAL);

    public static Direction getOutputDirection(BlockState state) {
        if (!state.m_61138_((Property)ATTACHMENT_DIRECTION) || !state.m_61138_((Property)ROTATION)) {
            return Direction.DOWN;
        }
        Direction attachmentDirection = (Direction)state.m_61143_((Property)ATTACHMENT_DIRECTION);
        int rotationIndex = (Integer)state.m_61143_((Property)ROTATION);
        return BlockStateUtil.getOutputDirection(attachmentDirection, rotationIndex);
    }

    public static BlockState getStateForPlacedGatePlate(BlockState state, BlockPlaceContext context) {
        BlockPos placePos = context.m_8083_();
        Direction faceOfAdjacentBlock = context.m_43719_();
        Direction directionTowardAdjacentBlock = faceOfAdjacentBlock.m_122424_();
        Vec3 relativeHitVec = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)placePos));
        return PlateBlockStateProperties.getStateForPlacedGatePlate(state, placePos, directionTowardAdjacentBlock, relativeHitVec);
    }

    public static BlockState getStateForPlacedGatePlate(BlockState state, BlockPos placePos, Direction directionTowardAdjacentBlock, Vec3 relativeHitVec) {
        Direction outputDirection = BlockStateUtil.getOutputDirectionFromRelativeHitVec(relativeHitVec, directionTowardAdjacentBlock);
        int rotationIndex = BlockStateUtil.getRotationIndexForDirection(directionTowardAdjacentBlock, outputDirection);
        if (state.m_61138_((Property)ATTACHMENT_DIRECTION) && state.m_61138_((Property)ROTATION)) {
            return (BlockState)((BlockState)state.m_61124_((Property)ATTACHMENT_DIRECTION, (Comparable)directionTowardAdjacentBlock)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotationIndex));
        }
        return state;
    }
}

