/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.gatecrafting_plinth;

import commoble.morered.MoreRed;
import commoble.morered.gatecrafting_plinth.GatecraftingRecipe;
import commoble.morered.gatecrafting_plinth.GatecraftingResultSlot;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class GatecraftingMenu
extends AbstractContainerMenu {
    public static final int OUTPUT_SLOT_ID = 0;
    public static final int FIRST_PLAYER_INVENTORY_SLOT_ID = 1;
    public static final int PLAYER_INVENTORY_SLOT_ROWS = 4;
    public static final int PLAYER_INVENTORY_SLOT_COLUMNS = 9;
    public static final int PLAYER_INVENTORY_SLOT_COUNT = 36;
    public static final int FIRST_PLAYER_INVENTORY_HOTBAR_SLOT_ID = 28;
    private final Player player;
    private final ContainerLevelAccess positionInWorld;
    public final ResultContainer craftResult = new ResultContainer();
    public Optional<Recipe<CraftingContainer>> currentRecipe = Optional.empty();

    public static GatecraftingMenu getClientContainer(int id, Inventory playerInventory) {
        return new GatecraftingMenu(id, playerInventory, BlockPos.f_121853_);
    }

    public static MenuConstructor getServerContainerProvider(BlockPos pos) {
        return (id, playerInventory, theServerPlayer) -> new GatecraftingMenu(id, playerInventory, pos);
    }

    protected GatecraftingMenu(int id, Inventory playerInventory, BlockPos pos) {
        super((MenuType)MoreRed.instance().gatecraftingMenuType.get(), id);
        this.player = playerInventory.f_35978_;
        this.positionInWorld = ContainerLevelAccess.m_39289_((Level)this.player.f_19853_, (BlockPos)pos);
        this.m_38897_(new GatecraftingResultSlot(this, (Container)this.craftResult, 0, 220, 38));
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.m_38897_(new Slot((Container)playerInventory, row + column * 9 + 9, 108 + row * 18, 84 + column * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 108 + i * 18, 142));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return GatecraftingMenu.m_38889_((ContainerLevelAccess)this.positionInWorld, (Player)playerIn, (Block)((Block)MoreRed.instance().gatecraftingPlinthBlock.get()));
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return false;
    }

    public ItemStack m_7648_(Player playerIn, int slotIndex) {
        ItemStack copiedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            copiedStack = stackInSlot.m_41777_();
            if (slotIndex == 0) {
                if (!this.m_38903_(stackInSlot, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stackInSlot, copiedStack);
            } else if (slotIndex >= 1 && (slotIndex < 28 ? !this.m_38903_(stackInSlot, 28, 37, false) : slotIndex >= 28 && slotIndex < 37 && !this.m_38903_(stackInSlot, 1, 28, false))) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == copiedStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stackInSlot);
        }
        return copiedStack;
    }

    public void onPlayerChoseRecipe(ResourceLocation recipeID) {
        this.attemptRecipeAssembly(MoreRed.getGatecraftingRecipe(this.player.f_19853_.m_7465_(), recipeID));
    }

    public void attemptRecipeAssembly(Optional<Recipe<CraftingContainer>> recipeHolder) {
        Optional<Recipe<CraftingContainer>> filteredRecipe = recipeHolder.filter(recipe -> GatecraftingRecipe.doesPlayerHaveIngredients(this.player.m_150109_(), (Recipe<CraftingContainer>)recipe));
        this.updateRecipeAndResult(filteredRecipe);
    }

    public void updateRecipeAndResult(Optional<Recipe<CraftingContainer>> recipeHolder) {
        this.currentRecipe = recipeHolder;
        this.craftResult.m_6836_(0, recipeHolder.map(recipe -> recipe.m_8043_().m_41777_()).orElse(ItemStack.f_41583_));
    }
}

