/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import commoble.morered.MoreRed;
import commoble.morered.gatecrafting_plinth.GatecraftingMenu;
import commoble.morered.gatecrafting_plinth.GatecraftingRecipeButtonPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.client.gui.widget.ScrollPanel;

public class GatecraftingScreen
extends AbstractContainerScreen<GatecraftingMenu> {
    public static final ResourceLocation TRADING_SCREEN = new ResourceLocation("minecraft:textures/gui/container/villager2.png");
    public static final ResourceLocation CRAFTING_SCREEN = new ResourceLocation("minecraft:textures/gui/container/crafting_table.png");
    public static final int SCROLLPANEL_X = 4;
    public static final int SCROLLPANEL_Y = 17;
    public static final int SCROLLPANEL_WIDTH = 97;
    public static final int SCROLLPANEL_HEIGHT = 142;
    private GatecraftingScrollPanel scrollPanel;

    public GatecraftingScreen(GatecraftingMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        int vanillaImageWidth = this.f_97726_;
        this.f_97726_ = 276;
        this.f_97727_ = 166;
        this.f_97730_ += this.f_97726_ - vanillaImageWidth;
    }

    public void m_7856_() {
        super.m_7856_();
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        ClientLevel world = this.f_96541_.f_91073_;
        ImmutableList recipes = world != null ? MoreRed.getAllGatecraftingRecipes(world.m_7465_()) : ImmutableList.of();
        this.scrollPanel = new GatecraftingScrollPanel(this.f_96541_, this, (List<Recipe<CraftingContainer>>)recipes, xStart + 4, yStart + 17, 97, 142);
        this.m_7787_(this.scrollPanel);
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        if (this.scrollPanel != null) {
            this.scrollPanel.m_6305_(matrix, mouseX, mouseY, 0.0f);
        }
        this.m_7025_(matrix, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    public void renderItemStack(ItemStack stack, int x, int y) {
        this.f_96542_.m_115203_(stack, x, y);
        this.f_96542_.m_115169_(this.f_96547_, stack, x, y);
    }

    protected void m_7025_(PoseStack matrix, int mouseX, int mouseY) {
        if (((GatecraftingMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.m_6057_(matrix, this.f_97734_.m_7993_(), mouseX, mouseY);
        } else if (this.scrollPanel != null && !this.scrollPanel.tooltipItem.m_41619_()) {
            this.m_6057_(matrix, this.scrollPanel.tooltipItem, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TRADING_SCREEN);
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        GuiComponent.m_93133_((PoseStack)matrix, (int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)512, (int)256);
        int arrowU = 186;
        int arrowV = 36;
        int arrowWidth = 14;
        int arrowHeight = 18;
        int tiles = 4;
        int arrowScreenX = xStart + arrowU - tiles * arrowWidth;
        int arrowScreenY = yStart + arrowV;
        int blitWidth = arrowWidth * tiles;
        GuiComponent.m_93160_((PoseStack)matrix, (int)arrowScreenX, (int)arrowScreenY, (int)blitWidth, (int)arrowHeight, (float)arrowU, (float)arrowV, (int)arrowWidth, (int)arrowHeight, (int)512, (int)256);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.scrollPanel.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static class GatecraftingScrollPanel
    extends ScrollPanel
    implements GuiEventListener {
        private List<RecipeButton> buttons = new ArrayList<RecipeButton>();
        public ItemStack tooltipItem = ItemStack.f_41583_;
        public final int totalButtonHeight;

        public GatecraftingScrollPanel(Minecraft client, GatecraftingScreen screen, List<Recipe<CraftingContainer>> recipes, int left, int top, int width, int height) {
            super(client, width, height, top, left);
            int buttonWidth = 90;
            int totalButtonHeight = 0;
            ClientLevel world = client.f_91073_;
            if (world != null) {
                for (Recipe<CraftingContainer> recipe : MoreRed.getAllGatecraftingRecipes(world.m_7465_())) {
                    RecipeButton recipeButton = new RecipeButton(screen, recipe, left, top + totalButtonHeight, buttonWidth);
                    this.buttons.add(recipeButton);
                    totalButtonHeight += recipeButton.m_93694_();
                }
            }
            this.totalButtonHeight = totalButtonHeight;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.buttons;
        }

        protected int getContentHeight() {
            return this.totalButtonHeight;
        }

        protected void drawPanel(PoseStack matrix, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            this.tooltipItem = ItemStack.f_41583_;
            for (RecipeButton button : this.buttons) {
                button.scrollButton((int)this.scrollDistance);
                button.m_6305_(matrix, mouseX, mouseY, 0.0f);
                if (button.tooltipItem.m_41619_()) continue;
                this.tooltipItem = button.tooltipItem;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return super.m_6375_(mouseX, mouseY, button);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput output) {
        }
    }

    public static class RecipeButton
    extends ExtendedButton {
        private final int baseY;
        private final GatecraftingScreen screen;
        private final Recipe<CraftingContainer> recipe;
        public ItemStack tooltipItem = ItemStack.f_41583_;

        public RecipeButton(GatecraftingScreen screen, Recipe<CraftingContainer> recipe, int x, int y, int width) {
            super(x, y, width, RecipeButton.getHeightForRecipe(recipe), (Component)Component.m_237113_((String)""), button -> RecipeButton.onButtonClicked((GatecraftingMenu)screen.f_97732_, recipe));
            this.baseY = y;
            this.screen = screen;
            this.recipe = recipe;
        }

        public static void onButtonClicked(GatecraftingMenu container, Recipe<CraftingContainer> recipe) {
            MoreRed.CHANNEL.sendToServer((Object)new GatecraftingRecipeButtonPacket(recipe.m_6423_()));
            container.attemptRecipeAssembly(Optional.of(recipe));
        }

        public static int getHeightForRecipe(Recipe<?> recipe) {
            int rows = 1 + (recipe.m_7527_().size() - 1) / 3;
            return rows * 18 + 5;
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return false;
        }

        public void m_6303_(PoseStack matrix, int mouseX, int mouseY, float partial) {
            this.tooltipItem = ItemStack.f_41583_;
            if (this.f_93624_) {
                super.m_6303_(matrix, mouseX, mouseY, partial);
                NonNullList ingredients = this.recipe.m_7527_();
                int ingredientCount = ingredients.size();
                for (int ingredientIndex = 0; ingredientIndex < ingredientCount; ++ingredientIndex) {
                    ItemStack stack = RecipeButton.getIngredientVariant(((Ingredient)ingredients.get(ingredientIndex)).m_43908_());
                    int itemRow = ingredientIndex / 3;
                    int itemColumn = ingredientIndex % 3;
                    int itemOffsetX = 2 + itemColumn * 18;
                    int itemOffsetY = 2 + itemRow * 18;
                    int itemX = this.f_93620_ + itemOffsetX;
                    int itemY = this.f_93621_ + itemOffsetY;
                    int itemEndX = itemX + 18;
                    int itemEndY = itemY + 18;
                    this.screen.renderItemStack(stack, itemX, itemY);
                    if (mouseX < itemX || mouseX >= itemEndX || mouseY < itemY || mouseY >= itemEndY) continue;
                    this.tooltipItem = stack;
                }
                if (ingredientCount > 0) {
                    int extraIngredientRows = (ingredientCount - 1) / 3;
                    int arrowX = this.f_93620_ + 2 + 54 + 4;
                    int arrowY = this.f_93621_ + 2 + 4 + 9 * extraIngredientRows;
                    int arrowWidth = 10;
                    int arrowHeight = 9;
                    int arrowU = 15;
                    int arrowV = 171;
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TRADING_SCREEN);
                    Screen.m_93133_((PoseStack)matrix, (int)arrowX, (int)arrowY, (float)arrowU, (float)arrowV, (int)arrowWidth, (int)arrowHeight, (int)512, (int)256);
                    ItemStack outputStack = this.recipe.m_8043_();
                    if (!outputStack.m_41619_()) {
                        int itemX = this.f_93620_ + 2 + 72;
                        int itemY = this.f_93621_ + 2 + 9 * extraIngredientRows;
                        int itemEndX = itemX + 18;
                        int itemEndY = itemY + 18;
                        this.screen.renderItemStack(outputStack, itemX, itemY);
                        if (mouseX >= itemX && mouseX < itemEndX && mouseY >= itemY && mouseY < itemEndY) {
                            this.tooltipItem = outputStack;
                        }
                    }
                }
            }
        }

        public static ItemStack getIngredientVariant(ItemStack[] variants) {
            int variantCount = variants.length;
            if (variantCount > 0) {
                int variantIndex = (int)(Util.m_137550_() / 1000L / (long)variantCount);
                return variants[Mth.m_14045_((int)variantIndex, (int)0, (int)(variantCount - 1))];
            }
            return ItemStack.f_41583_;
        }

        public void scrollButton(int currentScrollAmount) {
            this.f_93621_ = this.baseY - currentScrollAmount;
        }

        public void onClickButton() {
        }
    }
}

