/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.commons.lang3.Validate;

public class MFLocator {
    public final InteractionHand hand;
    public final BlockPos routerPos;
    public final int routerSlot;
    public final int filterSlot;
    private final ItemType itemType;

    private MFLocator(ItemType itemType, InteractionHand hand, BlockPos routerPos, int routerSlot, int filterSlot) {
        this.itemType = itemType;
        this.hand = hand;
        this.routerPos = routerPos;
        this.routerSlot = routerSlot;
        this.filterSlot = filterSlot;
        Validate.isTrue((hand != null || routerPos != null && routerSlot >= 0 ? 1 : 0) != 0);
    }

    public static MFLocator heldModule(InteractionHand hand) {
        return new MFLocator(ItemType.MODULE, hand, null, -1, -1);
    }

    public static MFLocator heldFilter(InteractionHand hand) {
        return new MFLocator(ItemType.FILTER, hand, null, -1, -1);
    }

    public static MFLocator moduleInRouter(BlockPos routerPos, int routerSlot) {
        return new MFLocator(ItemType.MODULE, null, routerPos, routerSlot, -1);
    }

    public static MFLocator filterInHeldModule(InteractionHand hand, int filterSlot) {
        return new MFLocator(ItemType.FILTER, hand, null, -1, filterSlot);
    }

    public static MFLocator filterInInstalledModule(BlockPos routerPos, int routerSlot, int filterSlot) {
        return new MFLocator(ItemType.FILTER, null, routerPos, routerSlot, filterSlot);
    }

    public static MFLocator fromBuffer(FriendlyByteBuf buf) {
        ItemType type = (ItemType)buf.m_130066_(ItemType.class);
        InteractionHand hand = null;
        BlockPos routerPos = null;
        int routerSlot = -1;
        if (buf.readBoolean()) {
            routerPos = buf.m_130135_();
            routerSlot = buf.readByte();
        } else {
            hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        }
        byte filterSlot = buf.readByte();
        return new MFLocator(type, hand, routerPos, routerSlot, filterSlot);
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.itemType);
        buf.writeBoolean(this.routerPos != null);
        if (this.routerPos != null) {
            buf.m_130064_(this.routerPos);
            buf.writeByte(this.routerSlot);
        } else {
            buf.m_130068_((Enum)this.hand);
        }
        buf.writeByte(this.filterSlot);
    }

    @Nonnull
    public ItemStack getTargetItem(Player player) {
        if (this.itemType == ItemType.MODULE) {
            if (this.hand != null) {
                return player.m_21120_(this.hand).m_41720_() instanceof ModuleItem ? player.m_21120_(this.hand) : ItemStack.f_41583_;
            }
            if (this.routerPos != null && this.routerSlot >= 0) {
                return this.getInstalledModule(player.f_19853_);
            }
        } else if (this.itemType == ItemType.FILTER) {
            if (this.hand != null) {
                return this.getFilterForStack(player.m_21120_(this.hand));
            }
            if (this.routerPos != null && this.routerSlot >= 0) {
                return this.getFilterForStack(this.getInstalledModule(player.f_19853_));
            }
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack getModuleStack(Player player) {
        if (this.hand != null) {
            return player.m_21120_(this.hand).m_41720_() instanceof ModuleItem ? player.m_21120_(this.hand) : ItemStack.f_41583_;
        }
        if (this.routerPos != null) {
            return this.getInstalledModule(player.f_19853_);
        }
        return ItemStack.f_41583_;
    }

    public Optional<ModularRouterBlockEntity> getRouter(Level world) {
        return this.routerPos == null ? Optional.empty() : world.m_141902_(this.routerPos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get());
    }

    @Nonnull
    private ItemStack getInstalledModule(Level world) {
        return this.getRouter(world).map(router -> router.getModules().getStackInSlot(this.routerSlot)).orElse(ItemStack.f_41583_);
    }

    @Nonnull
    private ItemStack getFilterForStack(@Nonnull ItemStack stack) {
        if (stack.m_41720_() instanceof SmartFilterItem) {
            return stack;
        }
        if (stack.m_41720_() instanceof ModuleItem && this.filterSlot >= 0) {
            return new BaseModuleHandler.ModuleFilterHandler(stack, null).getStackInSlot(this.filterSlot);
        }
        return ItemStack.f_41583_;
    }

    public static enum ItemType {
        MODULE,
        FILTER;

    }
}

