/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.modularrouters.client.gui.filter.AbstractFilterScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.item.smartfilter.InspectionFilter;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Range;

public class InspectionFilterScreen
extends AbstractFilterScreen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("modularrouters", "textures/gui/inspectionfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 191;
    private int xPos;
    private int yPos;
    private InspectionMatcher.ComparisonList comparisonList;
    private IntegerTextField valueTextField;
    private InspectionMatcher.InspectionSubject currentSubject = InspectionMatcher.InspectionSubject.NONE;
    private InspectionMatcher.InspectionOp currentOp = InspectionMatcher.InspectionOp.NONE;
    private final List<Buttons.DeleteButton> deleteButtons = new ArrayList<Buttons.DeleteButton>();
    private Button matchButton;

    public InspectionFilterScreen(ItemStack filterStack, MFLocator locator) {
        super(filterStack, locator);
        this.comparisonList = InspectionFilter.getComparisonList(filterStack);
    }

    public void m_7856_() {
        super.m_7856_();
        this.xPos = (this.f_96543_ - 176) / 2;
        this.yPos = (this.f_96544_ - 191) / 2;
        if (this.locator.filterSlot >= 0) {
            this.m_142416_((GuiEventListener)new BackButton(this.xPos - 12, this.yPos, button -> this.closeGUI()));
        }
        this.m_142416_((GuiEventListener)new Button(this.xPos + 8, this.yPos + 22, 90, 20, (Component)ClientUtil.xlate(this.currentSubject.getTranslationKey(), new Object[0]), button -> {
            this.currentSubject = this.currentSubject.cycle(Screen.m_96638_() ? -1 : 1);
            button.m_93666_((Component)ClientUtil.xlate(this.currentSubject.getTranslationKey(), new Object[0]));
        }));
        this.m_142416_((GuiEventListener)new Button(this.xPos + 95, this.yPos + 22, 20, 20, (Component)ClientUtil.xlate(this.currentOp.getTranslationKey(), new Object[0]), button -> {
            this.currentOp = this.currentOp.cycle(Screen.m_96638_() ? -1 : 1);
            button.m_93666_((Component)ClientUtil.xlate(this.currentOp.getTranslationKey(), new Object[0]));
        }));
        this.m_142416_((GuiEventListener)new Buttons.AddButton(this.xPos + 152, this.yPos + 23, button -> this.addEntry()));
        this.matchButton = new Button(this.xPos + 8, this.yPos + 167, 60, 20, (Component)ClientUtil.xlate("modularrouters.guiText.label.matchAll." + this.comparisonList.isMatchAll(), new Object[0]), button -> {
            CompoundTag ext = new CompoundTag();
            ext.m_128379_("MatchAll", !this.comparisonList.isMatchAll());
            PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.ANY_ALL_FLAG, this.locator, ext));
        });
        this.m_142416_((GuiEventListener)this.matchButton);
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.xPos + 8, this.yPos + 52 + i * 19, i, button -> this.sendRemovePosMessage(((Buttons.DeleteButton)button).getId()));
            this.m_142416_((GuiEventListener)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
        TextFieldManager manager = this.getOrCreateTextFieldManager().clear();
        this.valueTextField = new IntegerTextField(manager, this.f_96547_, this.xPos + 120, this.yPos + 28, 20, 14, Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100))){

            @Override
            public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                if (keyCode == 257 || keyCode == 335) {
                    InspectionFilterScreen.this.addEntry();
                    return true;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
        };
        this.valueTextField.useGuiTextBackground();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).f_93624_ = i < this.comparisonList.items.size();
        }
    }

    private void addEntry() {
        if (this.currentOp != InspectionMatcher.InspectionOp.NONE && this.currentSubject != InspectionMatcher.InspectionSubject.NONE) {
            int val = this.valueTextField.getIntValue();
            this.sendAddStringMessage("Comparison", Joiner.on((String)" ").join((Object)this.currentSubject, (Object)this.currentOp, new Object[]{val}));
            this.valueTextField.m_94144_("");
        }
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        GuiUtil.bindTexture(TEXTURE_LOCATION);
        this.m_93228_(matrixStack, this.xPos, this.yPos, 0, 0, 176, 191);
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)this.xPos + 88.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f, (float)(this.yPos + 6), 0x404040);
        for (int i = 0; i < this.comparisonList.items.size(); ++i) {
            InspectionMatcher.Comparison comparison = this.comparisonList.items.get(i);
            this.f_96547_.m_92889_(matrixStack, comparison.asLocalizedText(), (float)(this.xPos + 28), (float)(this.yPos + 55 + i * 19), 0x404080);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void resync(ItemStack stack) {
        this.comparisonList = InspectionFilter.getComparisonList(stack);
        this.matchButton.m_93666_((Component)ClientUtil.xlate("modularrouters.guiText.label.matchAll." + this.comparisonList.isMatchAll(), new Object[0]));
        this.updateDeleteButtonVisibility();
    }
}

