/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_item_rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import org.embeddedt.modernfix.render.FastItemRenderType;
import org.embeddedt.modernfix.render.RenderState;
import org.embeddedt.modernfix.render.SimpleItemModelView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class}, priority=600)
public abstract class ItemRendererMixin {
    private ItemTransforms.TransformType transformType;
    private final SimpleItemModelView modelView = new SimpleItemModelView();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void markRenderingType(ItemStack itemStack, ItemTransforms.TransformType transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model, CallbackInfo ci) {
        this.transformType = transformType;
    }

    @ModifyVariable(method={"renderModelLists"}, at=@At(value="HEAD"), index=1, argsOnly=true)
    private BakedModel useSimpleWrappedItemModel(BakedModel model, BakedModel arg, ItemStack stack, int combinedLight, int combinedOverlay, PoseStack matrixStack, VertexConsumer buffer) {
        if (!RenderState.IS_RENDERING_LEVEL && !stack.m_41619_() && model.getClass() == SimpleBakedModel.class && this.transformType == ItemTransforms.TransformType.GUI) {
            FastItemRenderType type;
            ItemTransform transform = model.m_7442_().f_111792_;
            if (transform == ItemTransform.f_111754_) {
                type = FastItemRenderType.SIMPLE_ITEM;
            } else if (stack.m_41720_() instanceof BlockItem && this.isBlockTransforms(transform)) {
                type = FastItemRenderType.SIMPLE_BLOCK;
            } else {
                return model;
            }
            this.modelView.setItem(model);
            this.modelView.setType(type);
            return this.modelView;
        }
        return model;
    }

    private boolean isBlockTransforms(ItemTransform transform) {
        return transform.f_111755_.m_122239_() == 30.0f && transform.f_111755_.m_122260_() == 225.0f && transform.f_111755_.m_122269_() == 0.0f;
    }
}

