/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.compatibility.IFurnaceRecipes;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;

public class FurnaceRecipes
implements IFurnaceRecipes {
    private Map<ItemStorage, RecipeStorage> recipes = new HashMap<ItemStorage, RecipeStorage>();
    private Map<ItemStorage, RecipeStorage> reverseRecipes = new HashMap<ItemStorage, RecipeStorage>();
    public static FurnaceRecipes instance;

    public void loadRecipes(RecipeManager recipeManager) {
        this.recipes.clear();
        this.reverseRecipes.clear();
        FurnaceRecipes.loadUtilityPredicates();
        recipeManager.m_44054_(RecipeType.f_44108_).values().forEach(recipe -> {
            NonNullList list = recipe.m_7527_();
            if (list.size() == 1) {
                for (ItemStack smeltable : ((Ingredient)list.get(0)).m_43908_()) {
                    if (smeltable.m_41619_()) continue;
                    RecipeStorage storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)new ItemStorage(smeltable)), 1, recipe.m_8043_(), Blocks.f_50094_, recipe.m_6423_()});
                    this.recipes.put(storage.getCleanedInput().get(0), storage);
                    ItemStack output = recipe.m_8043_().m_41777_();
                    output.m_41764_(1);
                    this.reverseRecipes.put(new ItemStorage(output), storage);
                }
            }
        });
    }

    private static void loadUtilityPredicates() {
        ItemStackUtils.IS_SMELTABLE = itemStack -> ItemStackUtils.isEmpty(instance.getSmeltingResult((ItemStack)itemStack)) == false;
        ItemStackUtils.ISCOOKABLE = itemStack -> ItemStackUtils.ISFOOD.test(instance.getSmeltingResult((ItemStack)itemStack));
        ItemStackUtils.CAN_EAT = itemStack -> ItemStackUtils.ISFOOD.test((ItemStack)itemStack) && !ItemStackUtils.ISCOOKABLE.test((ItemStack)itemStack);
    }

    @Override
    public ItemStack getSmeltingResult(ItemStack itemStack) {
        RecipeStorage storage = this.recipes.getOrDefault(new ItemStorage(itemStack), null);
        if (storage != null) {
            return storage.getPrimaryOutput();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public RecipeStorage getFirstSmeltingRecipeByResult(Predicate<ItemStack> stackPredicate) {
        Optional<ItemStorage> index = this.reverseRecipes.keySet().stream().filter(item -> stackPredicate.test(item.getItemStack())).findFirst();
        if (index.isPresent()) {
            return this.reverseRecipes.getOrDefault(index.get(), null);
        }
        return null;
    }

    public static FurnaceRecipes getInstance() {
        if (instance == null) {
            instance = new FurnaceRecipes();
        }
        return instance;
    }
}

