/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignFilterableItemMessage
extends AbstractBuildingServerMessage<AbstractBuilding> {
    private boolean assign;
    private ItemStorage item;
    private String id;

    public AssignFilterableItemMessage() {
    }

    public AssignFilterableItemMessage(IBuildingView building, String id, ItemStorage item, boolean assign) {
        super(building);
        this.assign = assign;
        this.item = item;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.assign = buf.readBoolean();
        this.item = new ItemStorage(buf.m_130267_());
        this.id = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.assign);
        buf.m_130055_(this.item.getItemStack());
        buf.m_130070_(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuilding building) {
        if (building.hasModule((Class<? extends IBuildingModule>)ItemListModule.class)) {
            if (this.assign) {
                ((ItemListModule)building.getModuleMatching(ItemListModule.class, m -> m.getId().equals(this.id))).addItem(this.item);
            } else {
                ((ItemListModule)building.getModuleMatching(ItemListModule.class, m -> m.getId().equals(this.id))).removeItem(this.item);
            }
        }
    }
}

