/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamParticleEffectMessage
implements IMessage {
    private static final Random RAND = new Random();
    private SimpleParticleType type;
    private double sPosX;
    private double sPosY;
    private double sPosZ;
    private double ePosX;
    private double ePosY;
    private double ePosZ;
    private int stage;
    private int maxStage;

    public StreamParticleEffectMessage() {
    }

    public StreamParticleEffectMessage(Vec3 start, Vec3 end, SimpleParticleType type, int stage, int maxStage) {
        this.sPosX = start.f_82479_;
        this.sPosY = start.f_82480_ - 0.5;
        this.sPosZ = start.f_82481_;
        this.ePosX = end.f_82479_;
        this.ePosY = end.f_82480_ - 0.5;
        this.ePosZ = end.f_82481_;
        this.stage = stage;
        this.maxStage = maxStage;
        this.type = type;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.sPosX = buf.readDouble();
        this.sPosY = buf.readDouble();
        this.sPosZ = buf.readDouble();
        this.ePosX = buf.readDouble();
        this.ePosY = buf.readDouble();
        this.ePosZ = buf.readDouble();
        this.stage = buf.readInt();
        this.maxStage = buf.readInt();
        this.type = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buf.m_130281_());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeDouble(this.sPosX);
        buf.writeDouble(this.sPosY);
        buf.writeDouble(this.sPosZ);
        buf.writeDouble(this.ePosX);
        buf.writeDouble(this.ePosY);
        buf.writeDouble(this.ePosZ);
        buf.writeInt(this.stage);
        buf.writeInt(this.maxStage);
        buf.m_130085_(ForgeRegistries.PARTICLE_TYPES.getKey((Object)this.type));
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        Vec3 end = new Vec3(this.ePosX, this.ePosY, this.ePosZ);
        double xDif = (this.sPosX - this.ePosX) / (double)this.maxStage;
        double yDif = (this.sPosY - this.ePosY) / (double)this.maxStage;
        double zDif = (this.sPosZ - this.ePosZ) / (double)this.maxStage;
        double curve = (double)this.maxStage / 3.0;
        for (int step = Math.max(0, this.stage - 1); step <= Math.min(this.maxStage, this.stage + 1); ++step) {
            double minDif = (double)Math.min(step, Math.abs(step - this.maxStage)) / curve;
            for (int i = 0; i < 10; ++i) {
                Vec3 randomPos = new Vec3(RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1);
                Vec3 randomOffset = new Vec3((RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1);
                world.m_7106_((ParticleOptions)this.type, end.f_82479_ + randomOffset.f_82479_ + xDif * (double)step, end.f_82480_ + randomOffset.f_82480_ + yDif * (double)step + minDif, end.f_82481_ + randomOffset.f_82481_ + zDif * (double)step, randomPos.f_82479_, randomPos.f_82480_ + 0.05, randomPos.f_82481_);
            }
        }
    }
}

