/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults.workers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.minecolonies.api.loot.EntityInBiomeTag;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.api.loot.ResearchUnlocked;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class DefaultFishermanLootProvider
extends SimpleLootTableProvider {
    private static final Gson GSON = Deserializers.m_78800_().create();

    public DefaultFishermanLootProvider(@NotNull DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @NotNull
    public String m_6055_() {
        return "DefaultFishermanLootProvider";
    }

    @Override
    protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        this.registerStandardLoot(registrar);
        this.registerBonusLoot(registrar);
    }

    @Override
    protected void validate(@NotNull Map<ResourceLocation, LootTable> map, @NotNull ValidationContext validationtracker) {
        ValidationContext newTracker = new ValidationContext(LootContextParamSets.f_81420_, conditionId -> null, lootId -> {
            if (lootId.equals((Object)BuiltInLootTables.f_78723_) || lootId.equals((Object)BuiltInLootTables.f_78721_) || lootId.equals((Object)BuiltInLootTables.f_78722_)) {
                return LootTable.m_79147_().m_79167_();
            }
            return validationtracker.m_79375_(lootId);
        });
        super.validate(map, newTracker);
    }

    private void registerStandardLoot(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        registrar.register(ModLootTables.FISHING, LootContextParamSets.f_81414_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ModLootTables.FISHING_JUNK).m_79707_(10).m_79711_(-2)).m_79076_(LootTableReference.m_79776_((ResourceLocation)ModLootTables.FISHING_TREASURE).m_79707_(5).m_79711_(2).m_79080_((LootItemCondition.Builder)new AlternativeLootItemCondition.Builder(new LootItemCondition.Builder[]{EntityInBiomeTag.of((TagKey<Biome>)BiomeTags.f_207603_), ResearchUnlocked.effect(ResearchConstants.FISH_TREASURE)}))).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ModLootTables.FISHING_FISH).m_79707_(85).m_79711_(-1))));
        registrar.register(ModLootTables.FISHING_JUNK, LootContextParamSets.f_81414_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78721_).m_79707_(1))));
        registrar.register(ModLootTables.FISHING_TREASURE, LootContextParamSets.f_81414_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78722_).m_79707_(1))));
        registrar.register(ModLootTables.FISHING_FISH, LootContextParamSets.f_81414_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78723_).m_79707_(1))));
    }

    private void registerBonusLoot(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        boolean skillBonus = true;
        boolean spongeWeight = true;
        int shardWeight = 25;
        int crystalWeight = 25;
        LootTable.Builder noBonus = LootTable.m_79147_();
        LootTable.Builder level3 = DefaultFishermanLootProvider.makeLoot(1000, LootItem.m_79579_((ItemLike)Items.f_42695_).m_79707_(25).m_79711_(1), LootItem.m_79579_((ItemLike)Items.f_42696_).m_79707_(25).m_79711_(1));
        LootTable.Builder level45 = DefaultFishermanLootProvider.makeLoot(1000, LootItem.m_79579_((ItemLike)Items.f_41902_).m_79707_(1).m_79711_(1), LootItem.m_79579_((ItemLike)Items.f_42695_).m_79707_(25).m_79711_(1), LootItem.m_79579_((ItemLike)Items.f_42696_).m_79707_(25).m_79711_(1));
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(1), LootContextParamSets.f_81410_, noBonus);
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(2), LootContextParamSets.f_81410_, noBonus);
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(3), LootContextParamSets.f_81420_, level3);
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(4), LootContextParamSets.f_81420_, level45);
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(5), LootContextParamSets.f_81420_, level45);
    }

    private static LootTable.Builder makeLoot(int emptyWeight, LootPoolSingletonContainer.Builder<?> ... entries) {
        LootPool.Builder pool = LootPool.m_79043_();
        for (LootPoolSingletonContainer.Builder<?> entry : entries) {
            pool.m_79076_(entry);
            emptyWeight -= DefaultFishermanLootProvider.getWeightForEntry(entry);
        }
        pool.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(emptyWeight));
        return LootTable.m_79147_().m_79161_(pool);
    }

    private static int getWeightForEntry(@NotNull LootPoolSingletonContainer.Builder<?> entry) {
        JsonObject json = GSON.toJsonTree((Object)entry.m_7512_()).getAsJsonObject();
        return GsonHelper.m_13824_((JsonObject)json, (String)"weight", (int)1);
    }
}

