/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.event.ColonyViewUpdatedEvent;
import com.minecolonies.api.colony.managers.events.ColonyManagerLoadedEvent;
import com.minecolonies.api.colony.managers.events.ColonyManagerUnloadedEvent;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.compatibility.CompatibilityManager;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyManagerConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowReactivateBuilding;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRecipeManager;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveMessage;
import com.minecolonies.coremod.util.BackUpHelper;
import com.minecolonies.coremod.util.ChunkDataHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager
implements IColonyManager {
    @NotNull
    private final Map<ResourceKey<Level>, ColonyList<IColonyView>> colonyViews = new HashMap<ResourceKey<Level>, ColonyList<IColonyView>>();
    private final IRecipeManager recipeManager = new StandardRecipeManager();
    private final ICompatibilityManager compatibilityManager = new CompatibilityManager();
    private UUID serverUUID = UUID.randomUUID();
    private boolean schematicDownloaded = false;
    private boolean capLoaded = false;

    @Override
    public IColony createColony(@NotNull Level w, BlockPos pos, @NotNull Player player, @NotNull String colonyName, @NotNull String pack) {
        IColonyManagerCapability cap = w.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        IColony colony = cap.createColony(w, pos);
        colony.setStructurePack(pack);
        colony.setName(colonyName);
        colony.getPermissions().setOwner(player);
        colony.getPackageManager().addImportantColonyPlayer((ServerPlayer)player);
        colony.getPackageManager().addCloseSubscriber((ServerPlayer)player);
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.m_7755_().getString()));
        if (colony.getWorld() == null) {
            Log.getLogger().error("Unable to claim chunks because of the missing world in the colony, please report this to the mod authors!", (Throwable)new Exception());
            return null;
        }
        ChunkDataHelper.claimColonyChunks(colony.getWorld(), true, colony.getID(), colony.getCenter());
        return colony;
    }

    @Override
    public void deleteColonyByWorld(int id, boolean canDestroy, Level world) {
        this.deleteColony(this.getColonyByWorld(id, world), canDestroy);
    }

    @Override
    public void deleteColonyByDimension(int id, boolean canDestroy, ResourceKey<Level> dimension) {
        this.deleteColony(this.getColonyByDimension(id, dimension), canDestroy);
    }

    private void deleteColony(@Nullable IColony iColony, boolean canDestroy) {
        if (!(iColony instanceof Colony)) {
            return;
        }
        Colony colony = (Colony)iColony;
        int id = colony.getID();
        Level world = colony.getWorld();
        if (world == null) {
            Log.getLogger().warn("Deleting Colony " + id + " errored: World is Null");
            return;
        }
        try {
            ChunkDataHelper.claimColonyChunks(world, false, id, colony.getCenter());
            Log.getLogger().info("Removing citizens for " + id);
            for (ICitizenData citizenData : new ArrayList<ICitizenData>(colony.getCitizenManager().getCitizens())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                citizenData.getEntity().ifPresent(entityCitizen -> entityCitizen.m_6667_(ColonyManagerConstants.CONSOLE_DAMAGE_SOURCE));
            }
            Log.getLogger().info("Removing buildings for " + id);
            for (IBuilding building : new ArrayList<IBuilding>(colony.getBuildingManager().getBuildings().values())) {
                try {
                    BlockPos location = building.getPosition();
                    Log.getLogger().info("Delete Building at " + location);
                    if (canDestroy) {
                        building.deconstruct();
                    }
                    building.destroy();
                    if (!(world.m_8055_(location).m_60734_() instanceof AbstractBlockHut)) continue;
                    Log.getLogger().info("Found Block, deleting " + world.m_8055_(location).m_60734_());
                    world.m_7471_(location, false);
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Something went wrong deleting a building while deleting the colony!", (Throwable)ex);
                }
            }
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)colony.getEventHandler());
            }
            catch (NullPointerException e) {
                Log.getLogger().warn("Can't unregister the event handler twice");
            }
            Log.getLogger().info("Deleting colony: " + colony.getID());
            IColonyManagerCapability cap = world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
            if (cap == null) {
                Log.getLogger().warn("Missing world capability with colony manager!");
                return;
            }
            cap.deleteColony(id);
            BackUpHelper.markColonyDeleted(colony.getID(), colony.getDimension());
            colony.getImportantMessageEntityPlayers().forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewRemoveMessage(colony.getID(), colony.getDimension()), (ServerPlayer)player));
            Log.getLogger().info("Successfully deleted colony: " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
    }

    @Override
    public void removeColonyView(int id, ResourceKey<Level> dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            this.colonyViews.get(dimension).remove(id);
        }
    }

    @Override
    @Nullable
    public IColony getColonyByWorld(int id, Level world) {
        IColonyManagerCapability cap = world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Override
    @Nullable
    public IColony getColonyByDimension(int id, ResourceKey<Level> registryKey) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(registryKey);
        if (world == null) {
            return null;
        }
        IColonyManagerCapability cap = world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Override
    public IBuilding getBuilding(@NotNull Level w, @NotNull BlockPos pos) {
        IBuilding building;
        @Nullable IColony colony = this.getColonyByPosFromWorld(w, pos);
        if (colony != null && (building = colony.getBuildingManager().getBuilding(pos)) != null) {
            return building;
        }
        for (IColony otherColony : this.getColonies(w)) {
            IBuilding building2 = otherColony.getBuildingManager().getBuilding(pos);
            if (building2 == null) continue;
            return building2;
        }
        return null;
    }

    @Override
    public IColony getColonyByPosFromWorld(@Nullable Level w, @NotNull BlockPos pos) {
        if (w == null) {
            return null;
        }
        LevelChunk centralChunk = w.m_46745_(pos);
        int id = centralChunk.getCapability(IColony.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0);
        if (id == 0) {
            return null;
        }
        return this.getColonyByWorld(id, w);
    }

    @Override
    public IColony getColonyByPosFromDim(ResourceKey<Level> registryKey, @NotNull BlockPos pos) {
        return this.getColonyByPosFromWorld((Level)ServerLifecycleHooks.getCurrentServer().m_129880_(registryKey), pos);
    }

    @Override
    public boolean isFarEnoughFromColonies(@NotNull Level w, @NotNull BlockPos pos) {
        int blockRange = Math.max((Integer)MineColonies.getConfig().getServer().minColonyDistance.get(), (Integer)MineColonies.getConfig().getServer().initialColonySize.get()) << 4;
        IColony closest = this.getClosestColony(w, pos);
        if (closest != null && BlockPosUtil.getDistance(pos, closest.getCenter()) < (double)blockRange) {
            return false;
        }
        return ChunkDataHelper.canClaimChunksInRange(w, pos, (Integer)MineColonies.getConfig().getServer().initialColonySize.get());
    }

    @Override
    @NotNull
    public List<IColony> getColonies(@NotNull Level w) {
        IColonyManagerCapability cap = w.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return Collections.emptyList();
        }
        return cap.getColonies();
    }

    @Override
    @NotNull
    public List<IColony> getAllColonies() {
        ArrayList<IColony> allColonies = new ArrayList<IColony>();
        for (Level world : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).ifPresent(c -> allColonies.addAll(c.getColonies()));
        }
        return allColonies;
    }

    @Override
    @NotNull
    public List<IColony> getColoniesAbandonedSince(int abandonedSince) {
        ArrayList<IColony> sortedList = new ArrayList<IColony>();
        for (IColony colony : this.getAllColonies()) {
            if (colony.getLastContactInHours() < abandonedSince) continue;
            sortedList.add(colony);
        }
        return sortedList;
    }

    @Override
    public IBuildingView getBuildingView(ResourceKey<Level> dimension, BlockPos pos) {
        if (this.colonyViews.containsKey(dimension)) {
            for (IColonyView colony : this.colonyViews.get(dimension)) {
                IBuildingView building = colony.getBuilding(pos);
                if (building == null) continue;
                return building;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IColony getIColony(@NotNull Level w, @NotNull BlockPos pos) {
        return w.f_46443_ ? this.getColonyView(w, pos) : this.getColonyByPosFromWorld(w, pos);
    }

    @Override
    public void openReactivationWindow(BlockPos pos) {
        new WindowReactivateBuilding(pos).open();
    }

    private IColonyView getColonyView(@NotNull Level w, @NotNull BlockPos pos) {
        LevelChunk centralChunk = w.m_46745_(pos);
        int id = centralChunk.getCapability(IColony.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0);
        if (id == 0) {
            return null;
        }
        return this.getColonyView(id, (ResourceKey<Level>)w.m_46472_());
    }

    @Override
    @Nullable
    public IColony getClosestIColony(@NotNull Level w, @NotNull BlockPos pos) {
        return w.f_46443_ ? this.getClosestColonyView(w, pos) : this.getClosestColony(w, pos);
    }

    @Override
    @Nullable
    public IColonyView getClosestColonyView(@Nullable Level w, @Nullable BlockPos pos) {
        if (w == null || pos == null) {
            return null;
        }
        LevelChunk chunk = w.m_46745_(pos);
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return null;
        }
        if (cap.getOwningColony() != 0) {
            return this.getColonyView(cap.getOwningColony(), (ResourceKey<Level>)w.m_46472_());
        }
        if (!cap.getStaticClaimColonies().isEmpty()) {
            IColonyView closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getStaticClaimColonies()) {
                long dist;
                IColonyView c = this.getColonyView(cId, (ResourceKey<Level>)w.m_46472_());
                if (c == null || c.getDimension() != w.m_46472_() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        IColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        if (this.colonyViews.containsKey(w.m_46472_())) {
            for (IColonyView c : this.colonyViews.get(w.m_46472_())) {
                long dist;
                if (c.getDimension() != w.m_46472_() || c.getCenter() == null || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
        }
        return closestColony;
    }

    @Override
    public IColony getClosestColony(@NotNull Level w, @NotNull BlockPos pos) {
        LevelChunk chunk = w.m_46745_(pos);
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return null;
        }
        if (cap.getOwningColony() != 0) {
            return this.getColonyByWorld(cap.getOwningColony(), w);
        }
        if (!cap.getStaticClaimColonies().isEmpty()) {
            IColony closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getStaticClaimColonies()) {
                long dist;
                IColony c = this.getColonyByWorld(cId, w);
                if (c == null || c.getDimension() != w.m_46472_() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        IColony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (IColony c : this.getColonies(w)) {
            long dist;
            if (c.getDimension() != w.m_46472_() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Override
    @Nullable
    public IColony getIColonyByOwner(@NotNull Level w, @NotNull Player owner) {
        return this.getIColonyByOwner(w, w.f_46443_ ? owner.m_20148_() : owner.m_36316_().getId());
    }

    @Override
    @Nullable
    public IColony getIColonyByOwner(@NotNull Level w, UUID owner) {
        return w.f_46443_ ? this.getColonyViewByOwner(owner, (ResourceKey<Level>)w.m_46472_()) : this.getColonyByOwner(owner);
    }

    private IColony getColonyViewByOwner(UUID owner, ResourceKey<Level> dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            for (IColonyView c : this.colonyViews.get(dimension)) {
                ColonyPlayer p = c.getPlayers().get(owner);
                if (p == null || !p.getRank().equals(c.getPermissions().getRankOwner())) continue;
                return c;
            }
        }
        return null;
    }

    @Nullable
    private IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        for (IColony colony : this.getAllColonies()) {
            if (!colony.getPermissions().getOwner().equals(owner)) continue;
            return colony;
        }
        return null;
    }

    @Override
    public int getMinimumDistanceBetweenTownHalls() {
        return (Integer)MineColonies.getConfig().getServer().minColonyDistance.get() * 16;
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (IColony c : this.getAllColonies()) {
                c.onServerTick(event);
            }
        }
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        if (this.serverUUID != null) {
            compound.m_128362_("uuid", this.serverUUID);
        }
        CompoundTag compCompound = new CompoundTag();
        this.compatibilityManager.write(compCompound);
        compound.m_128365_("compatabilityManager", (Tag)compCompound);
        compound.m_128379_("dist", true);
        CompoundTag recipeCompound = new CompoundTag();
        this.recipeManager.write(recipeCompound);
        compound.m_128365_("recipeManager", (Tag)recipeCompound);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        if (compound.m_128403_("uuid")) {
            this.serverUUID = compound.m_128342_("uuid");
        }
        if (compound.m_128441_("compatabilityManager")) {
            this.compatibilityManager.read(compound.m_128469_("compatabilityManager"));
        }
        this.recipeManager.read(compound.m_128469_("recipeManager"));
    }

    @Override
    public void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ == null && !this.colonyViews.isEmpty()) {
            this.colonyViews.clear();
        }
    }

    @Override
    public void onWorldTick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.getColonies(event.level).forEach(c -> c.onWorldTick(event));
        }
    }

    @Override
    public void onWorldLoad(@NotNull Level world) {
        if (!world.f_46443_) {
            if (!this.capLoaded) {
                BackUpHelper.loadMissingColonies();
                BackUpHelper.loadManagerBackup();
            }
            this.capLoaded = false;
            for (IColony c : this.getColonies(world)) {
                c.onWorldLoad(world);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ColonyManagerLoadedEvent(this));
        }
    }

    @Override
    public void setCapLoaded() {
        this.capLoaded = true;
    }

    @Override
    public UUID getServerUUID() {
        return this.serverUUID;
    }

    @Override
    public void setServerUUID(UUID uuid) {
        this.serverUUID = uuid;
    }

    @Override
    public void onWorldUnload(@NotNull Level world) {
        if (!world.f_46443_) {
            boolean hasColonies = false;
            for (IColony c : this.getColonies(world)) {
                hasColonies = true;
                c.onWorldUnload(world);
            }
            if (hasColonies) {
                BackUpHelper.backupColonyData();
            }
            MinecraftForge.EVENT_BUS.post((Event)new ColonyManagerUnloadedEvent(this));
        }
    }

    @Override
    public void handleColonyViewMessage(int colonyId, @NotNull FriendlyByteBuf colonyData, @NotNull Level world, boolean isNewSubscription, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            if (this.colonyViews.containsKey(dim)) {
                this.colonyViews.get(dim).add(view);
            } else {
                ColonyList<IColonyView> list = new ColonyList<IColonyView>();
                list.add(view);
                this.colonyViews.put(dim, list);
            }
        }
        view.handleColonyViewMessage(colonyData, world, isNewSubscription);
        MinecraftForge.EVENT_BUS.post((Event)new ColonyViewUpdatedEvent(view));
    }

    @Override
    public IColonyView getColonyView(int id, ResourceKey<Level> dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            return this.colonyViews.get(dimension).get(id);
        }
        return null;
    }

    @Override
    public void handlePermissionsViewMessage(int colonyID, @NotNull FriendlyByteBuf data, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyID, dim);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID), (Throwable)new Exception());
        } else {
            view.handlePermissionsViewMessage(data);
        }
    }

    @Override
    public void handleColonyViewCitizensMessage(int colonyId, int citizenId, FriendlyByteBuf buf, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    @Override
    public void handleColonyViewWorkOrderMessage(int colonyId, FriendlyByteBuf buf, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewWorkOrderMessage(buf);
    }

    @Override
    public void handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
    }

    @Override
    public void handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull FriendlyByteBuf buf, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyBuildingViewMessage(buildingId, buf);
        } else {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId), (Throwable)new Exception());
        }
    }

    @Override
    public void handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
    }

    @Override
    public void handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
    }

    @Override
    public boolean isSchematicDownloaded() {
        return this.schematicDownloaded;
    }

    @Override
    public void setSchematicDownloaded(boolean downloaded) {
        this.schematicDownloaded = downloaded;
    }

    @Override
    public boolean isCoordinateInAnyColony(@NotNull Level world, BlockPos pos) {
        LevelChunk centralChunk = world.m_46745_(pos);
        return centralChunk.getCapability(IColony.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0) != 0;
    }

    @Override
    public ICompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    @Override
    public IRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public int getTopColonyId() {
        int top = 0;
        for (Level world : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            int tempTop = world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).map(IColonyManagerCapability::getTopID).orElse(0);
            if (tempTop <= top) continue;
            top = tempTop;
        }
        return top;
    }

    @Override
    public void resetColonyViews() {
        this.colonyViews.clear();
    }
}

