/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildPickUpMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildingSetStyleMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildBuilding
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowbuildbuilding.xml";
    protected TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> DONT_TOUCH_PREDICATE = (info, worldPos, handler) -> {
        BlockState worldState = handler.getWorld().m_8055_(worldPos);
        return worldState.m_60734_() instanceof IBuilderUndestroyable || worldState.m_60734_() == Blocks.f_50752_ || info.getBlockInfo().getState().m_60734_() instanceof AbstractBlockHut && handler.getWorldPos().equals(worldPos);
    };
    private final IBuildingView building;
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private DropDownList stylesDropDownList;
    private DropDownList buildersDropDownList;
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    @NotNull
    private List<String> styles = new ArrayList<String>();
    @NotNull
    private List<Tuple<String, BlockPos>> builders = new ArrayList<Tuple<String, BlockPos>>();
    private int tick;

    public WindowBuildBuilding(IColonyView c, IBuildingView building) {
        super("minecolonies:gui/windowbuildbuilding.xml");
        this.building = building;
        this.initStyleNavigation();
        this.registerButton("build", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("deconstruct", this::deconstructBuildingClicked);
        this.registerButton("pickup", this::pickUpBuilding);
        Button buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        IBuildingView parentBuilding = c.getBuilding(building.getParent());
        if (building.getBuildingLevel() == 0) {
            buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.build"));
            ((Button)this.findPaneOfTypeByID("repair", Button.class)).hide();
            ((Button)this.findPaneOfTypeByID("deconstruct", Button.class)).hide();
            ((Button)this.findPaneOfTypeByID("pickup", Button.class)).show();
        } else if (!this.canBeUpgraded()) {
            buttonBuild.hide();
        } else {
            buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.upgrade"));
        }
        if (building.isDeconstructed()) {
            ((Button)this.findPaneOfTypeByID("repair", Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.build"));
            ((Button)this.findPaneOfTypeByID("pickup", Button.class)).show();
        }
    }

    public boolean canBeUpgraded() {
        IBuildingView parentBuilding = this.building.getColony().getBuilding(this.building.getParent());
        return this.building.getBuildingLevel() < this.building.getBuildingMaxLevel() && (parentBuilding == null || this.building.getBuildingLevel() < parentBuilding.getBuildingLevel() || parentBuilding.getBuildingLevel() >= parentBuilding.getBuildingMaxLevel());
    }

    private void pickUpBuilding() {
        Network.getNetwork().sendToServer(new BuildPickUpMessage(this.building));
        this.close();
    }

    private void deconstructBuildingClicked() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.f_121853_ : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).m_14419_();
        Network.getNetwork().sendToServer(new BuildRequestMessage(this.building, BuildRequestMessage.Mode.REMOVE, builder));
        this.cancelClicked();
    }

    private void cancelClicked() {
        this.building.openGui(false);
    }

    private void confirmClicked() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.f_121853_ : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).m_14419_();
        Network.getNetwork().sendToServer(new BuildingSetStyleMessage(this.building, this.styles.get(this.stylesDropDownList.getSelectedIndex())));
        if (this.building.getBuildingLevel() == this.building.getBuildingMaxLevel()) {
            Network.getNetwork().sendToServer(new BuildRequestMessage(this.building, BuildRequestMessage.Mode.REPAIR, builder));
        } else {
            Network.getNetwork().sendToServer(new BuildRequestMessage(this.building, BuildRequestMessage.Mode.BUILD, builder));
        }
        this.cancelClicked();
    }

    private void repairClicked() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.f_121853_ : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).m_14419_();
        Network.getNetwork().sendToServer(new BuildRequestMessage(this.building, BuildRequestMessage.Mode.REPAIR, builder));
        this.cancelClicked();
    }

    private void updateBuilders() {
        this.builders.clear();
        this.builders.add((Tuple<String, BlockPos>)new Tuple((Object)(Component.m_237115_((String)((JobEntry)ModJobs.builder.get()).getTranslationKey()).getString() + ":"), (Object)BlockPos.f_121853_));
        this.builders.addAll(this.building.getColony().getBuildings().stream().filter(build -> build instanceof AbstractBuildingBuilderView && !((AbstractBuildingBuilderView)build).getWorkerName().isEmpty() && build.getBuildingType() != ModBuildings.miner.get()).map(build -> new Tuple((Object)((AbstractBuildingBuilderView)build).getWorkerName(), (Object)build.getPosition())).sorted(Comparator.comparing(item -> ((BlockPos)item.m_14419_()).m_123331_((Vec3i)this.building.getPosition()))).collect(Collectors.toList()));
        this.initBuilderNavigation();
    }

    private void updateStyles() {
        if (!this.building.getParent().equals((Object)BlockPos.f_121853_) && this.building.getColony().getBuilding(this.building.getParent()) != null) {
            this.styles = new ArrayList<String>();
            this.styles.add(this.building.getColony().getBuilding(this.building.getParent()).getStructurePack());
            if (!this.styles.isEmpty()) {
                this.stylesDropDownList.setSelectedIndex(0);
            }
        } else {
            this.styles = new ArrayList<String>();
            this.styles.add(this.building.getStructurePack());
            if (!this.styles.isEmpty()) {
                int newIndex = this.styles.indexOf(this.building.getStructurePack());
                if (newIndex == -1) {
                    newIndex = 0;
                }
                this.stylesDropDownList.setSelectedIndex(newIndex);
            }
        }
        ((Button)this.findPaneOfTypeByID("previousStyle", Button.class)).setEnabled(this.enabled);
        ((DropDownList)this.findPaneOfTypeByID("style", DropDownList.class)).setEnabled(this.enabled);
        ((Button)this.findPaneOfTypeByID("nextStyle", Button.class)).setEnabled(this.enabled);
    }

    private void updateResources() {
        this.tick = 20;
        if (this.stylesDropDownList.getSelectedIndex() == -1) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        int nextLevel = this.building.getBuildingLevel();
        if (this.canBeUpgraded()) {
            nextLevel = this.building.getBuildingLevel() + 1;
        }
        Object name = this.building.getStructurePath().replace(".blueprint", "");
        name = ((String)name).substring(0, ((String)name).length() - 1) + nextLevel + ".blueprint";
        ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)this.styles.get(this.stylesDropDownList.getSelectedIndex()), (String)name), arg_0 -> this.lambda$updateResources$6((Level)world, arg_0)));
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        int hashCode = res.m_41782_() ? res.m_41783_().hashCode() : 0;
        String key = res.m_41778_() + "-" + hashCode;
        ItemStorage resource = this.resources.get(key);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.resources.put(key, resource);
    }

    private void initStyleNavigation() {
        this.registerButton("previousStyle", this::previousStyle);
        this.registerButton("nextStyle", this::nextStyle);
        this.stylesDropDownList = (DropDownList)this.findPaneOfTypeByID("style", DropDownList.class);
        this.stylesDropDownList.setHandler(this::onStyleDropDownChanged);
        this.stylesDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowBuildBuilding.this.styles.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildBuilding.this.styles.size()) {
                    return WindowBuildBuilding.this.styles.get(index);
                }
                return "";
            }
        });
    }

    private void initBuilderNavigation() {
        this.buildersDropDownList = (DropDownList)this.findPaneOfTypeByID("worker", DropDownList.class);
        this.buildersDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowBuildBuilding.this.builders.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildBuilding.this.builders.size()) {
                    return (String)WindowBuildBuilding.this.builders.get(index).m_14418_();
                }
                return "";
            }
        });
        this.buildersDropDownList.setSelectedIndex(0);
    }

    private void onStyleDropDownChanged(DropDownList list) {
        this.updateResources();
    }

    private void nextStyle() {
        this.stylesDropDownList.selectNext();
    }

    private void previousStyle() {
        this.stylesDropDownList.selectPrevious();
    }

    public void onOpened() {
        this.updateStyles();
        this.updateBuilders();
        this.updateResources();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.resources.isEmpty() && this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    public void updateResourceList() {
        ScrollingList recourseList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        recourseList.enable();
        recourseList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        recourseList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(resource.getItemStack().m_41786_());
                quantityLabel.setText(Component.m_237113_((String)Integer.toString(resource.getAmount())));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack itemIcon = new ItemStack((ItemLike)resource.getItem(), 1);
                itemIcon.m_41751_(resource.getItemStack().m_41783_());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(itemIcon);
            }
        });
    }

    private /* synthetic */ void lambda$updateResources$6(Level world, Blueprint blueprint) {
        StructurePhasePlacementResult result;
        this.resources.clear();
        if (blueprint == null) {
            ((Button)this.findPaneOfTypeByID("build", Button.class)).hide();
            ((Button)this.findPaneOfTypeByID("repair", Button.class)).hide();
            ((Button)this.findPaneOfTypeByID("pickup", Button.class)).show();
            return;
        }
        blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.building.getRotation()), this.building.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, world);
        StructurePlacer placer = new StructurePlacer((IStructureHandler)new LoadOnlyStructureHandler((Level)Minecraft.m_91087_().f_91073_, this.building.getPosition(), blueprint, new PlacementSettings(), true));
        BlockPos progressPos = AbstractBlueprintIterator.NULL_POS;
        do {
            result = placer.executeStructureStep(world, null, progressPos, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.and((info, pos, handler) -> false)), true);
            progressPos = result.getIteratorPos();
            for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                this.addNeededResource(stack, stack.m_41613_());
            }
        } while (result != null && result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED);
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
        this.updateResourceList();
    }
}

