/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.registry;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class BuildingEntry {
    private final AbstractBlockHut<?> buildingBlock;
    private final BiFunction<IColony, BlockPos, IBuilding> buildingProducer;
    private final ResourceLocation registryName;
    private List<Supplier<IBuildingModule>> buildingModuleProducers;
    private List<Supplier<Supplier<IBuildingModuleView>>> buildingModuleViewProducers;
    private final Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer;

    public String getTranslationKey() {
        return "com." + this.registryName.m_135827_() + ".building." + this.registryName.m_135815_();
    }

    public AbstractBlockHut<?> getBuildingBlock() {
        return this.buildingBlock;
    }

    public IBuilding produceBuilding(BlockPos position, IColony colony) {
        IBuilding building = this.buildingProducer.apply(colony, position);
        for (Supplier<IBuildingModule> module : this.buildingModuleProducers) {
            building.registerModule(module.get().setBuilding(building));
        }
        building.setBuildingType(this);
        return building;
    }

    public IBuildingView produceBuildingView(BlockPos position, IColonyView colony) {
        IBuildingView buildingView = this.buildingViewProducer.get().apply(colony, position);
        buildingView.setBuildingType(this);
        for (Supplier<Supplier<IBuildingModuleView>> module : this.buildingModuleViewProducers) {
            buildingView.registerModule(module.get().get());
        }
        return buildingView;
    }

    public List<Supplier<IBuildingModule>> getModuleProducers() {
        return this.buildingModuleProducers;
    }

    public List<Supplier<Supplier<IBuildingModuleView>>> getModuleViewProducers() {
        return this.buildingModuleViewProducers;
    }

    private BuildingEntry(ResourceLocation registryName, AbstractBlockHut<?> buildingBlock, BiFunction<IColony, BlockPos, IBuilding> buildingProducer, Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer, List<Supplier<IBuildingModule>> buildingModuleProducers, List<Supplier<Supplier<IBuildingModuleView>>> buildingModuleViewProducers) {
        this.registryName = registryName;
        this.buildingBlock = buildingBlock;
        this.buildingProducer = buildingProducer;
        this.buildingViewProducer = buildingViewProducer;
        this.buildingModuleProducers = buildingModuleProducers;
        this.buildingModuleViewProducers = buildingModuleViewProducers;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public static final class Builder {
        private AbstractBlockHut<?> buildingBlock;
        private BiFunction<IColony, BlockPos, IBuilding> buildingProducer;
        private Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer;
        private List<Supplier<IBuildingModule>> buildingModuleProducers = new ArrayList<Supplier<IBuildingModule>>();
        private List<Supplier<Supplier<IBuildingModuleView>>> buildingModuleViewProducers = new ArrayList<Supplier<Supplier<IBuildingModuleView>>>();
        private ResourceLocation registryName;

        public Builder setBuildingBlock(AbstractBlockHut<?> buildingBlock) {
            this.buildingBlock = buildingBlock;
            return this;
        }

        public Builder setBuildingProducer(BiFunction<IColony, BlockPos, IBuilding> buildingProducer) {
            this.buildingProducer = buildingProducer;
            return this;
        }

        public Builder setBuildingViewProducer(Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer) {
            this.buildingViewProducer = buildingViewProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public BuildingEntry createBuildingEntry() {
            Validate.notNull(this.buildingBlock);
            Validate.notNull(this.buildingProducer);
            Validate.notNull(this.buildingViewProducer);
            Validate.notNull((Object)this.registryName);
            return new BuildingEntry(this.registryName, this.buildingBlock, this.buildingProducer, this.buildingViewProducer, this.buildingModuleProducers, this.buildingModuleViewProducers);
        }

        public Builder addBuildingModuleProducer(Supplier<IBuildingModule> moduleProducer) {
            this.buildingModuleProducers.add(moduleProducer);
            return this;
        }

        public Builder addBuildingModuleViewProducer(Supplier<Supplier<IBuildingModuleView>> moduleViewProducer) {
            this.buildingModuleViewProducers.add(moduleViewProducer);
            return this;
        }

        public Builder addBuildingModuleProducer(Supplier<IBuildingModule> moduleProducer, Supplier<Supplier<IBuildingModuleView>> moduleViewProducer) {
            this.buildingModuleProducers.add(moduleProducer);
            this.buildingModuleViewProducers.add(moduleViewProducer);
            return this;
        }
    }
}

