/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.service;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.cells.StorageCell;
import appeng.blockentity.storage.ChestBlockEntity;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.me.storage.DelegatingMEInventory;
import appeng.me.storage.DriveWatcher;
import gripe._90.megacells.crafting.DecompressionPatternEncoding;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.item.cell.BulkCellInventory;
import gripe._90.megacells.service.CompressionService;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.ItemStack;

public class DecompressionService
implements IGridService,
IGridServiceProvider {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Class<?> CHEST_MONITOR_CLASS;
    private static final VarHandle CHEST_MONITOR_HANDLE;
    private static final VarHandle CHEST_CELL_HANDLE;
    private static final MethodHandle DRIVE_DELEGATE_HANDLE;
    private static final VarHandle DRIVE_WATCHERS_HANDLE;
    private final Set<Object2IntMap<AEItemKey>> decompressionChains = new ObjectLinkedOpenHashSet();
    private final List<ChestBlockEntity> chests = new ObjectArrayList();
    private final List<DriveBlockEntity> drives = new ObjectArrayList();

    public void addNode(IGridNode node) {
        Object object = node.getOwner();
        if (object instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)object;
            this.chests.add(chest);
        }
        if ((object = node.getOwner()) instanceof DriveBlockEntity) {
            DriveBlockEntity drive = (DriveBlockEntity)object;
            this.drives.add(drive);
        }
    }

    public void removeNode(IGridNode node) {
        Object object = node.getOwner();
        if (object instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)object;
            this.chests.remove(chest);
        }
        if ((object = node.getOwner()) instanceof DriveBlockEntity) {
            DriveBlockEntity drive = (DriveBlockEntity)object;
            this.drives.remove(drive);
        }
    }

    public void onServerStartTick() {
        this.decompressionChains.clear();
        try {
            for (ChestBlockEntity chest : this.chests) {
                this.addChain(this.getCellByChest(chest));
            }
            for (DriveBlockEntity drive : this.drives) {
                for (int i = 0; i < drive.getCellCount(); ++i) {
                    this.addChain(this.getCellByDriveSlot(drive, i));
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to invoke DecompressionService method handles", e);
        }
    }

    private StorageCell getCellByChest(ChestBlockEntity chest) {
        Object monitor = CHEST_MONITOR_HANDLE.get(chest);
        return monitor != null ? CHEST_CELL_HANDLE.get(monitor) : null;
    }

    private StorageCell getCellByDriveSlot(DriveBlockEntity drive, int slot) throws Throwable {
        DriveWatcher[] watchers = DRIVE_WATCHERS_HANDLE.get(drive);
        return watchers[slot] != null ? DRIVE_DELEGATE_HANDLE.invoke(watchers[slot]) : null;
    }

    private Object2IntMap<AEItemKey> getChain(BulkCellInventory cell) {
        if (cell.compressionEnabled) {
            return (Object2IntMap)CompressionService.INSTANCE.getChain(cell.getStoredItem()).map(c -> {
                ObjectArrayList keys = new ObjectArrayList((ObjectCollection)c.keySet());
                Collections.reverse(keys);
                Object2IntLinkedOpenHashMap decompressed = new Object2IntLinkedOpenHashMap();
                int highest = keys.indexOf((Object)cell.getHighestCompressed());
                if (highest > -1) {
                    for (AEItemKey key : keys.subList(highest, keys.size())) {
                        decompressed.put((Object)key, c.getInt((Object)key));
                    }
                }
                return decompressed;
            }).orElseGet(Object2IntLinkedOpenHashMap::new);
        }
        return new Object2IntLinkedOpenHashMap();
    }

    private void addChain(StorageCell cell) {
        if (!(cell instanceof BulkCellInventory)) {
            return;
        }
        BulkCellInventory bulkCell = (BulkCellInventory)cell;
        Object2IntMap<AEItemKey> chain = this.getChain(bulkCell);
        if (!chain.isEmpty()) {
            this.decompressionChains.add(chain);
        }
    }

    public Set<Object2IntMap<AEItemKey>> getDecompressionChains() {
        return this.decompressionChains;
    }

    public Set<AEItemKey> getDecompressionPatterns(Object2IntMap<AEItemKey> compressionChain) {
        ObjectArrayList variants = new ObjectArrayList((ObjectCollection)compressionChain.keySet());
        ObjectLinkedOpenHashSet patterns = new ObjectLinkedOpenHashSet();
        for (AEItemKey variant : variants) {
            if (variant == variants.get(variants.size() - 1)) continue;
            ItemStack pattern = new ItemStack(MEGAItems.DECOMPRESSION_PATTERN);
            AEItemKey decompressed = (AEItemKey)variants.get(variants.indexOf((Object)variant) + 1);
            int factor = compressionChain.getInt((Object)decompressed);
            DecompressionPatternEncoding.encode(pattern.m_41784_(), variant, decompressed, factor);
            patterns.add((Object)AEItemKey.of((ItemStack)pattern));
        }
        return patterns;
    }

    static {
        try {
            CHEST_MONITOR_CLASS = Class.forName("appeng.blockentity.storage.ChestBlockEntity$ChestMonitorHandler");
            CHEST_MONITOR_HANDLE = MethodHandles.privateLookupIn(ChestBlockEntity.class, LOOKUP).findVarHandle(ChestBlockEntity.class, "cellHandler", CHEST_MONITOR_CLASS);
            CHEST_CELL_HANDLE = MethodHandles.privateLookupIn(CHEST_MONITOR_CLASS, LOOKUP).findVarHandle(CHEST_MONITOR_CLASS, "cellInventory", StorageCell.class);
            DRIVE_WATCHERS_HANDLE = MethodHandles.privateLookupIn(DriveBlockEntity.class, LOOKUP).findVarHandle(DriveBlockEntity.class, "invBySlot", DriveWatcher[].class);
            DRIVE_DELEGATE_HANDLE = MethodHandles.privateLookupIn(DelegatingMEInventory.class, LOOKUP).findVirtual(DelegatingMEInventory.class, "getDelegate", MethodType.methodType(MEStorage.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to create DecompressionService method handles", e);
        }
    }
}

