/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.projection;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;

public class PowerConsolidationMahoujinTileEntity
extends MahoujinTileEntity
implements BlockEntityTicker<PowerConsolidationMahoujinTileEntity> {
    public static final String LAKED = "MAHOUTSUKAI_NUM_TIMES_LAKED";
    private int numTimesLaked = 0;
    private int tickCounter = 0;

    public PowerConsolidationMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.powerConsolidation.get(), p, bs);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128405_(LAKED, this.numTimesLaked);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.numTimesLaked = compound.m_128451_(LAKED);
        super.m_142466_(compound);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, PowerConsolidationMahoujinTileEntity blockEntity) {
        int radius = MTConfig.POWER_CONSOLIDATION_LAKE_RADIUS;
        int cycle = MTConfig.POWER_CONSOLIDATION_LAKE_CYCLE;
        if (!level.f_46443_) {
            if (this.tickCounter == cycle) {
                if (this.numTimesLaked >= radius - 1) {
                    level.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
                } else {
                    boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.f_58858_, level, this.getCasterUUID(), MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST);
                    if (nearbyBatteriesGaveMana || this.getCaster() != null && PlayerManaManager.drainMana(this.getCaster(), MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST, false, false) == MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST) {
                        this.createLake();
                        ++this.numTimesLaked;
                    }
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void createLake() {
        int r = this.numTimesLaked + 1;
        Stream lst = BlockPos.m_121990_((BlockPos)this.f_58858_.m_7918_(-r - 1, -r - 1, -r - 1), (BlockPos)this.f_58858_.m_7918_(r + 1, r + 1, r + 1));
        lst.forEach(p -> {
            if (p.m_123331_((Vec3i)this.f_58858_) < (double)(r * r + 1) && p.m_123342_() < this.f_58858_.m_123342_() && this.f_58857_.m_7702_(p) == null) {
                if ((double)(this.numTimesLaked * this.numTimesLaked) - p.m_123331_((Vec3i)this.f_58858_) <= 1.0) {
                    EffectUtil.tryChangeBlockState(false, p, Blocks.f_50493_.m_49966_(), this.f_58857_, this.getCaster());
                } else {
                    EffectUtil.tryChangeBlockState(false, p, ((Block)ModBlocks.murkyFluid.get()).m_49966_(), this.f_58857_, this.getCaster());
                }
            }
        });
    }
}

