/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;

public class MentalDisplacementUpdatePacket {
    public int entityId;
    public double x;
    public double y;
    public double z;
    public double vx;
    public double vy;
    public double vz;
    public double yaw;
    public double pitch;

    public MentalDisplacementUpdatePacket() {
    }

    public MentalDisplacementUpdatePacket(Entity e, double x, double y, double z, double vx, double vy, double vz, double yaw, double pitch) {
        this.entityId = e.m_19879_();
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.vx = buf.readDouble();
        this.vy = buf.readDouble();
        this.vz = buf.readDouble();
        this.yaw = buf.readDouble();
        this.pitch = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.vx);
        buf.writeDouble(this.vy);
        buf.writeDouble(this.vz);
        buf.writeDouble(this.yaw);
        buf.writeDouble(this.pitch);
    }

    public static void encode(MentalDisplacementUpdatePacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static MentalDisplacementUpdatePacket decode(FriendlyByteBuf buf) {
        MentalDisplacementUpdatePacket msg = new MentalDisplacementUpdatePacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final MentalDisplacementUpdatePacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                Level world = player.f_19853_;
                Entity e = world.m_6815_(message.entityId);
                if (e instanceof MentalDisplacementEntity) {
                    MentalDisplacementUpdatePacket.updatePosition((MentalDisplacementEntity)e, message);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void updatePosition(MentalDisplacementEntity entity, MentalDisplacementUpdatePacket packet) {
        entity.updatePacket(packet);
    }
}

