/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.util.Utils;

public class DonePossessingPacket {
    int chunkx = 0;
    int chunkz = 0;

    public DonePossessingPacket() {
    }

    public DonePossessingPacket(int x, int z) {
        this.chunkx = x;
        this.chunkz = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.chunkx = buf.readInt();
        this.chunkz = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.chunkx);
        buf.writeInt(this.chunkz);
    }

    public static void encode(DonePossessingPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static DonePossessingPacket decode(FriendlyByteBuf buf) {
        DonePossessingPacket msg = new DonePossessingPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(DonePossessingPacket message, Supplier<NetworkEvent.Context> context) {
        DonePossessingPacket.handleDonePossess(message, (Player)context.get().getSender());
        context.get().setPacketHandled(true);
    }

    public static void handleDonePossess(DonePossessingPacket message, Player player) {
        IMahou mahou;
        if (player != null && (mahou = Utils.getPlayerMahou(player)) != null) {
            mahou.setPossessing(false);
        }
    }
}

