/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.handlers;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.FogProjector;
import stepsword.mahoutsukai.block.MahoujinProjector;
import stepsword.mahoutsukai.capability.chunks.ChunkMahouProvider;
import stepsword.mahoutsukai.capability.livingmahou.LivingMahouProvider;
import stepsword.mahoutsukai.capability.mahou.MahouProvider;
import stepsword.mahoutsukai.capability.mahou.ManaEvents;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.capability.settingsmahou.SettingsMahouProvider;
import stepsword.mahoutsukai.capability.worldsave.WorldMahouProvider;
import stepsword.mahoutsukai.commands.ModCommands;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.Kodoku;
import stepsword.mahoutsukai.effects.displacement.EquivalentDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.MentalDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.ProjectileDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.ProtectiveDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.exchange.DamageExchangeSpellEffect;
import stepsword.mahoutsukai.effects.familiar.FamiliarsGardenEffect;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.effects.mystic.DamageReplicationSpellEffect;
import stepsword.mahoutsukai.effects.mystic.RhoAiasSpellEffect;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.effects.projection.MorganEffect;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.effects.projection.RealityMarbleSpellEffect;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.mahoujin.RhongomyniadEntity;
import stepsword.mahoutsukai.fluids.MurkyWaterBlock;
import stepsword.mahoutsukai.item.emrys.StaffEmrys;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.item.rulebreaker.RuleBreaker;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;
import stepsword.mahoutsukai.potion.AuthorityJumpPotion;
import stepsword.mahoutsukai.potion.BindingEyesPotion;
import stepsword.mahoutsukai.potion.BlackFlameEyesPotion;
import stepsword.mahoutsukai.potion.BorrowedAuthorityPotion;
import stepsword.mahoutsukai.potion.BoundPotion;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.ConfusionPotion;
import stepsword.mahoutsukai.potion.DeathCollectionEyesPotion;
import stepsword.mahoutsukai.potion.FaySightEyesPotion;
import stepsword.mahoutsukai.potion.FearPotion;
import stepsword.mahoutsukai.potion.FlungPotion;
import stepsword.mahoutsukai.potion.ForesightPotion;
import stepsword.mahoutsukai.potion.ImmunityExchangePotion;
import stepsword.mahoutsukai.potion.InsightEyesPotion;
import stepsword.mahoutsukai.potion.MisfortunePotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ProbabilityAlterPotion;
import stepsword.mahoutsukai.potion.ReversionEyesPotion;
import stepsword.mahoutsukai.potion.RipperInvisPotion;
import stepsword.mahoutsukai.potion.WallStickPotion;
import stepsword.mahoutsukai.potion.WoundedPotion;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.MahouJobs;

public class ServerHandler {
    public static final ResourceLocation MAHOU = new ResourceLocation("mahoutsukai", "mahou");
    public static final ResourceLocation LIVING_MAHOU = new ResourceLocation("mahoutsukai", "living_mahou");
    public static final ResourceLocation SETTINGS_MAHOU = new ResourceLocation("mahoutsukai", "mahou_settings");
    public static long tickCounter = 0L;

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(MAHOU, (ICapabilityProvider)new MahouProvider());
            event.addCapability(SETTINGS_MAHOU, (ICapabilityProvider)new SettingsMahouProvider());
        }
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(LIVING_MAHOU, (ICapabilityProvider)new LivingMahouProvider());
        }
    }

    @SubscribeEvent
    public void attachCapabilityWorld(AttachCapabilitiesEvent<Level> event) {
        if (event.getObject() instanceof Level) {
            event.addCapability(MAHOU, (ICapabilityProvider)new WorldMahouProvider());
        }
    }

    @SubscribeEvent
    public void attachCapabilityChunk(AttachCapabilitiesEvent<LevelChunk> event) {
        if (event.getObject() instanceof LevelChunk) {
            event.addCapability(MAHOU, (ICapabilityProvider)new ChunkMahouProvider());
        }
    }

    @SubscribeEvent
    public void serverLoad(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void tickCheck(TickEvent.PlayerTickEvent event) {
        if (tickCounter % 10L == 0L && !event.player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.END) {
            InsightEyesPotion.insightEyesPlayerTick(event.player);
            BorrowedAuthorityPotion.authorityPlayerTick(event.player);
            BindingEyesPotion.bindingEyesPlayerTick(event.player);
            ReversionEyesPotion.reversionEyesPlayerTick(event.player);
            ClairvoyanceEyesPotion.clairvoyanceEyesPlayerTick(event.player);
            FearPotion.fearPlayerTick(event.player);
            MorganEffect.secretCalibur(event.player);
        }
        if (tickCounter % 100L == 0L && !event.player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.END) {
            PlayerManaManager.regenMana(event.player, false);
            MahouSettings.updateClientMahou((ServerPlayer)event.player);
        }
        if (tickCounter % 4L == 0L && !event.player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.END) {
            FaySightEyesPotion.faySightEyesPlayerTick(event.player);
        }
        if (tickCounter % (long)MTConfig.BLACK_FLAME_IGNITION_TICKS == 0L && !event.player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.END) {
            BlackFlameEyesPotion.blackFlameEyesPlayerTick(event.player);
        }
        if (tickCounter % 100L == 0L && !(event.player.m_21211_().m_41720_() instanceof MysticStaff)) {
            MahouTsukaiMod.proxy.speedUp();
        }
    }

    @SubscribeEvent
    public void playerJump(LivingEvent.LivingJumpEvent event) {
        BorrowedAuthorityPotion.authorityJump(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.level.f_46443_) {
            tickCounter = event.level.m_46467_() % 50000L;
        }
        PowerConsolidationSpellEffect.powerConsolidationWorldTick(event);
        MurkyWaterBlock.murkyUpdateTick(event);
        FogProjector.fogUpdateTick(event);
    }

    @SubscribeEvent
    public void livingEvent(LivingEvent.LivingTickEvent event) {
        ServerHandler.cancelEvent((Event)event, BindingEyesPotion.bindingEyesLivingUpdate(event.getEntity()));
        BorrowedAuthorityPotion.authorityLivingUpdate(event.getEntity());
        ReversionEyesPotion.reversionEyesLivingUpdate(event.getEntity());
        BlackFlameEyesPotion.blackFlameEyesLivingUpdate(event.getEntity());
        FearPotion.fearLivingUpdate(event.getEntity());
        MentalDisplacementSpellEffect.mentalDisplacementLivingUpdate((Entity)event.getEntity());
        FamiliarsGardenEffect.familiarsGardenLivingUpdate(event.getEntity());
        MisfortunePotion.misfortuneLivingUpdate(event.getEntity());
        ConfusionPotion.confusionLivingUpdate(event.getEntity());
        WoundedPotion.woundedLivingTick(event.getEntity());
        TheRipper.ripperLivingTick(event.getEntity());
        RipperInvisPotion.presenceConcealmentLivingTick(event.getEntity());
        AuthorityJumpPotion.authorityJumpLivingTick(event.getEntity());
        FlungPotion.flungLivingTick(event.getEntity());
        ProbabilityAlterPotion.applyProbabilityAlter(event.getEntity());
        WallStickPotion.wallStickLivingTick(event.getEntity());
    }

    @SubscribeEvent
    public void attackFromPlayer(AttackEntityEvent event) {
        boolean canceled = BoundPotion.boundAttackFromPlayer(event.getEntity()) || FamiliarsGardenEffect.familiarsGardenAttackEntity(event.getTarget(), event.getEntity()) || GeasEffect.geasAttackEntity(event);
        ServerHandler.cancelEvent((Event)event, canceled);
        ServerHandler.cancelEvent((Event)event, canceled);
        if (!canceled) {
            BorrowedAuthorityPotion.authorityAttackFromPlayer(event.getEntity(), event.getTarget());
            StaffEmrys.emrysHit(event);
        }
    }

    @SubscribeEvent
    public void struckByLightning(EntityStruckByLightningEvent event) {
        StaffEmrys.emrysStruckByLightning(event);
    }

    @SubscribeEvent
    public void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundLeftClickBlock(event.getEntity()));
        PowerConsolidationSpellEffect.caliburnLeftClickBlock(event);
        BorrowedAuthorityPotion.borrowedAuthorityLeftClickBlock(event.getEntity());
    }

    @SubscribeEvent
    public void placeEvent(BlockEvent.EntityPlaceEvent event) {
        ForesightPotion.butterflyPlaceBlock(event);
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundRightClickBlock(event.getEntity()));
        ManaEvents.rightClickCircle(event.getEntity(), event.getPos());
        EquivalentDisplacementSpellEffect.equivalentDisplacementShiftRightClick(event);
        MahoujinProjector.projectorRightClick(event);
        FogProjector.fogProjectorRightClick(event);
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundRightClickItem(event.getEntity()));
        ClarentEffect.clarentOnRightClick(event.getEntity());
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent event) {
        boolean z = ReversionEyesPotion.reversionEyesProjectileImpact(event.getEntity(), event.getRayTraceResult());
        ServerHandler.cancelEvent((Event)event, z);
        if (!z) {
            ServerHandler.cancelEvent((Event)event, ProtectiveDisplacementSpellEffect.protectiveDisplacementProjectileImpact(event));
        }
    }

    @SubscribeEvent
    public void potionFinish(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() == ModEffects.BLACK_FLAME_EYES.get()) {
            BlackFlameEyesPotion.blackFlameEyesPotionFinish(event.getEntity());
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() == ModEffects.MISFORTUNE.get()) {
            Kodoku.kodokuPotionRemove((MobEffectEvent)event);
        }
    }

    @SubscribeEvent
    public void potionFinish(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() == ModEffects.BLACK_FLAME_EYES.get()) {
            BlackFlameEyesPotion.blackFlameEyesPotionFinish(event.getEntity());
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        Entity e = event.getTarget();
        if (e instanceof LivingEntity) {
            ReversionEyesPotion.notifyIfReverted((LivingEntity)e);
            BlackFlameEyesPotion.notifyIfBurning((LivingEntity)e);
            RipperInvisPotion.notifyIfInvisible((LivingEntity)e);
        }
    }

    @SubscribeEvent
    public void livingUse(LivingEntityUseItemEvent.Stop event) {
        StrengtheningSpellEffect.strengtheningUseEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void highPriorityLivingDeath(LivingDeathEvent event) {
        boolean cancels = DeathCollectionEyesPotion.deathCollectionEyesLivingDeath(event.getEntity(), event.getSource());
        ServerHandler.cancelEvent((Event)event, cancels);
        DamageReplicationSpellEffect.damageReplicationLivingDeath((Entity)event.getEntity());
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        MorganEffect.morganLivingDeath(event);
        Kodoku.kodokuEntityDeath(event);
        PlayerManaManager.playerDeath(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void highPriorityLivingHurt(LivingHurtEvent event) {
        boolean cancels = ImmunityExchangePotion.immunityExchangeLivingHurt(event) || GeasEffect.geasLivingHurt(event) || Replica.replicaLivingHurt(event);
        ServerHandler.cancelEvent((Event)event, cancels);
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        if (!event.isCanceled()) {
            StrengtheningSpellEffect.strengtheningLivingHurt(event);
            RealityMarbleSpellEffect.realityMarbleLivingHurt((Entity)event.getEntity());
            ManaEvents.manaPlayerHurt(event.getEntity(), event.getAmount());
            StaffEmrys.emrysLivingHurt(event);
            ClarentEffect.clarentLivingHurt(event);
            RhongomyniadEntity.rhongomyniadLivingHurt(event);
            TheRipper.ripperOnHit(event);
            DamageExchangeSpellEffect.damageExchangeLivingHurt(event);
            RuleBreaker.ruleBreakerLivingHurt(event);
        }
    }

    @SubscribeEvent
    public void anvilRepair(AnvilRepairEvent event) {
        ProjectionSpellEffect.projectionRepairAnvil(event);
    }

    @SubscribeEvent
    public void anvilUpdate(AnvilUpdateEvent event) {
        ProjectionSpellEffect.projectionUpdateAnvil(event);
        Morgan.anvilNoRepair(event);
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        ClarentEffect.clarentLivingAttack(event);
        Replica.replicaLivingAttack(event);
        StrengtheningSpellEffect.strengtheningArmorEvent(event);
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        StrengtheningSpellEffect.strengtheningHarvestCheck(event);
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        StrengtheningSpellEffect.strengtheningBreakEvent(event);
        MisfortunePotion.misfortuneBreakEvent(event);
        ForesightPotion.butterflyBreakBlock(event);
        Replica.replicaBreakBlock(event);
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        StrengtheningSpellEffect.strengtheningBreakSpeed(event);
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        RealityMarbleSpellEffect.realityMarbleChunkUnload(event);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        RealityMarbleSpellEffect.realityMarbleChunkLoad(event);
        PowerConsolidationSpellEffect.powerConsolidationChunkLoad(event);
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        ServerHandler.cancelEvent((Event)event, RealityMarbleSpellEffect.realityMarbleLivingFall(event));
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinLevelEvent event) {
        ProjectileDisplacementSpellEffect.projectileDisplacementJoinWorld(event.getEntity());
    }

    @SubscribeEvent
    public void explosionEvent(ExplosionEvent.Start event) {
        FamiliarsGardenEffect.familiarsGardenExplosion(event.getExplosion().m_46079_());
    }

    @SubscribeEvent
    public void explosionEvent(ExplosionEvent.Detonate event) {
        RhoAiasSpellEffect.rhoAiasExplosionProtection(event);
        Replica.replicaExplosionProtection(event);
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingDamageEvent event) {
        ServerHandler.cancelEvent((Event)event, FamiliarsGardenEffect.familiarsGardenLivingDamage(event));
        DamageReplicationSpellEffect.damageReplicationLivingDamage(event);
        ContractMahoujinTileEntity.breakContract(event);
    }

    @SubscribeEvent
    public void rightClickEntity(PlayerInteractEvent.EntityInteract event) {
        SummonFamiliarSpellEffect.familiarRightClick(event);
        RhongomyniadEntity.rhongomyniadRightClick(event);
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent.Finish event) {
        ManaEvents.drinkMilk(event);
    }

    @SubscribeEvent
    public void useItem(EntityItemPickupEvent event) {
        ServerHandler.cancelEvent((Event)event, GeasEffect.geasItem(event));
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        ManaEvents.mahouClone(event);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ManaEvents.mahouLogin(event.getEntity());
    }

    @SubscribeEvent
    public void playerSlept(PlayerWakeUpEvent event) {
        if (!event.wakeImmediately() && !event.updateLevel()) {
            ManaEvents.mahouSleep(event.getEntity());
        }
    }

    @SubscribeEvent
    public void potionAdded(MobEffectEvent.Added event) {
        DamageReplicationSpellEffect.damageReplicationPotionAdded(event);
    }

    @SubscribeEvent
    public void setTargetEvent(LivingChangeTargetEvent event) {
        ServerHandler.cancelEvent((Event)event, FearPotion.fearLivingSetAttack(event.getEntity(), event.getNewTarget()));
    }

    @SubscribeEvent
    public void livingDrops(LivingDropsEvent event) {
        MisfortunePotion.misfortuneLootEvent(event);
    }

    @SubscribeEvent
    public void vanillaGameEvent(VanillaGameEvent event) {
        ServerHandler.cancelEvent((Event)event, RipperInvisPotion.presenceConcealmentNoSound(event));
    }

    @SubscribeEvent(receiveCanceled=true)
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            MahouJobs.runJobs();
        }
    }

    public static void cancelEvent(Event e, boolean c) {
        if (e.isCancelable() && !e.isCanceled()) {
            e.setCanceled(c);
        }
    }
}

