/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.fae;

import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FaeAIFollow
extends Goal {
    private final PathfinderMob entity;
    private final Predicate<LivingEntity> followPredicate;
    private LivingEntity followingEntity;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float fard;
    private final float neard;
    private float oldWaterCost;
    private final float areaSize;
    private int timeFollowing;

    public FaeAIFollow(final PathfinderMob e, double speed, float far, float area, float near) {
        this.entity = e;
        this.followPredicate = new Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity r) {
                return r != null && e != r;
            }
        };
        this.speedModifier = speed;
        this.navigation = e.m_21573_();
        this.fard = far;
        this.neard = near;
        this.areaSize = area;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        List list;
        if ((this.followingEntity == null || Math.random() > 0.05) && !(list = this.entity.f_19853_.m_6443_(LivingEntity.class, this.entity.m_20191_().m_82400_((double)this.areaSize), this.followPredicate)).isEmpty()) {
            for (LivingEntity creature : list) {
                if (creature.m_20145_()) continue;
                if (!(creature instanceof Player) || EffectUtil.hasBuff(creature, ModEffects.FAY_SIGHT_EYES)) {
                    this.followingEntity = creature;
                }
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return this.followingEntity != null && !this.navigation.m_26571_() && this.entity.m_20280_((Entity)this.followingEntity) < (double)(this.fard * this.fard);
    }

    public void m_8056_() {
        this.timeFollowing = 0;
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.timeFollowing = 0;
        this.followingEntity = null;
        this.navigation.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (this.followingEntity != null && !this.entity.m_21523_()) {
            ++this.timeFollowing;
            Vec3 motion = this.entity.m_20184_();
            double motionX = motion.f_82479_;
            double motionY = motion.f_82480_;
            double motionZ = motion.f_82481_;
            this.entity.m_21563_().m_24960_((Entity)this.followingEntity, 10.0f, (float)this.entity.m_8132_());
            float f = 0.01f;
            if (!Utils.isBlockAir(this.entity.f_19853_, this.entity.m_20183_().m_7495_()) || Math.random() > 0.6) {
                // empty if block
            }
            if (--this.timeToRecalcPath <= 0) {
                double d2;
                double d1;
                this.timeToRecalcPath = 1;
                double d0 = this.entity.m_20185_() - this.followingEntity.m_20185_();
                double d3 = d0 * d0 + (d1 = 0.0) * d1 + (d2 = this.entity.m_20189_() - this.followingEntity.m_20189_()) * d2;
                if (d3 < (double)(this.fard * this.fard)) {
                    Vec3 toFollowing = new Vec3(-d0, -d1, -d2).m_82541_().m_82490_(10.0);
                    float reachfactor = 0.01f;
                    if (d3 < (double)(this.neard * this.neard)) {
                        toFollowing = toFollowing.m_82524_(90.0f);
                        motionX = toFollowing.f_82479_ * 0.03;
                        motionZ = toFollowing.f_82481_ * 0.03;
                        toFollowing = toFollowing.m_82524_(-90.0f);
                        motionX += (motionX - toFollowing.f_82479_) * (double)reachfactor;
                        motionZ += (motionZ - toFollowing.f_82481_) * (double)reachfactor;
                    } else {
                        motionX -= (motionX - toFollowing.f_82479_) * (double)reachfactor;
                        motionZ -= (motionZ - toFollowing.f_82481_) * (double)reachfactor;
                    }
                } else {
                    this.navigation.m_26573_();
                }
            }
            this.entity.m_20334_(motionX, motionY, motionZ);
        }
        if (this.timeFollowing > 200) {
            this.followingEntity = null;
        }
    }
}

