/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderUtil {
    private static void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Vector3f pos, Vec2 texUV, Vector3f normalVector, int color, int lightmapValue) {
        float a = 1.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        renderBuffer.m_85982_(matrixPos, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(r, g, b, a).m_7421_(texUV.f_82470_, texUV.f_82471_).m_86008_(OverlayTexture.f_118083_).m_7120_(0, 240).m_85977_(matrixNormal, normalVector.m_122239_(), normalVector.m_122260_(), normalVector.m_122269_()).m_5752_();
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Vector3f blpos, Vector3f brpos, Vector3f trpos, Vector3f tlpos, Vec2 blUVpos, Vec2 brUVpos, Vec2 trUVpos, Vec2 tlUVpos, Vector3f normalVector, int color, int lightmapValue) {
        FluidRenderUtil.addQuadVertex(matrixPos, matrixNormal, renderBuffer, blpos, blUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(matrixPos, matrixNormal, renderBuffer, brpos, brUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(matrixPos, matrixNormal, renderBuffer, trpos, trUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(matrixPos, matrixNormal, renderBuffer, tlpos, tlUVpos, normalVector, color, lightmapValue);
    }

    private static void addFace(Direction whichFace, Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, int color, Vec3 centrePos, float width, float height, Vec2 bottomLeftUV, float texUwidth, float texVheight, int lightmapValue) {
        Vector3f leftToRightDirection;
        Vector3f bottomToTopDirection = switch (whichFace) {
            case Direction.NORTH -> {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.SOUTH -> {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.EAST -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.WEST -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.UP -> {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case Direction.DOWN -> {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 0.0f, 1.0f);
            }
            default -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
        };
        leftToRightDirection.m_122261_(0.5f * width);
        bottomToTopDirection.m_122261_(0.5f * height);
        Vector3f bottomLeftPos = new Vector3f(centrePos);
        bottomLeftPos.m_122267_(leftToRightDirection);
        bottomLeftPos.m_122267_(bottomToTopDirection);
        Vector3f bottomRightPos = new Vector3f(centrePos);
        bottomRightPos.m_122253_(leftToRightDirection);
        bottomRightPos.m_122267_(bottomToTopDirection);
        Vector3f topRightPos = new Vector3f(centrePos);
        topRightPos.m_122253_(leftToRightDirection);
        topRightPos.m_122253_(bottomToTopDirection);
        Vector3f topLeftPos = new Vector3f(centrePos);
        topLeftPos.m_122267_(leftToRightDirection);
        topLeftPos.m_122253_(bottomToTopDirection);
        Vec2 bottomLeftUVpos = new Vec2(bottomLeftUV.f_82470_, bottomLeftUV.f_82471_);
        Vec2 bottomRightUVpos = new Vec2(bottomLeftUV.f_82470_ + texUwidth, bottomLeftUV.f_82471_);
        Vec2 topLeftUVpos = new Vec2(bottomLeftUV.f_82470_ + texUwidth, bottomLeftUV.f_82471_ + texVheight);
        Vec2 topRightUVpos = new Vec2(bottomLeftUV.f_82470_, bottomLeftUV.f_82471_ + texVheight);
        Vector3f normalVector = whichFace.m_122432_();
        FluidRenderUtil.addQuad(matrixPos, matrixNormal, renderBuffer, bottomLeftPos, bottomRightPos, topRightPos, topLeftPos, bottomLeftUVpos, bottomRightUVpos, topLeftUVpos, topRightUVpos, normalVector, color, lightmapValue);
    }

    public static void renderCubeUsingQuads(int capacity, FluidStack fluid, float partialTicks, PoseStack PoseStack2, MultiBufferSource renderBuffers, int combinedLight, int combinedOverlay) {
        PoseStack2.m_85836_();
        FluidRenderUtil.drawCubeQuads(PoseStack2, renderBuffers, combinedLight, fluid, capacity);
        PoseStack2.m_85849_();
    }

    private static void drawCubeQuads(PoseStack PoseStack2, MultiBufferSource renderBuffer, int combinedLight, FluidStack fluid, int capacity) {
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        if (attributes == null) {
            return;
        }
        ResourceLocation fluidStill = attributes.getStillTexture(fluid);
        if (fluidStill == null) {
            return;
        }
        VertexConsumer vertexBuilderBlockQuads = renderBuffer.m_6299_(RenderType.m_110466_());
        int color = attributes.getTintColor();
        Matrix4f matrixPos = PoseStack2.m_85850_().m_85861_();
        Matrix3f matrixNormal = PoseStack2.m_85850_().m_85864_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidStill);
        Vec2 bottomLeftUV = new Vec2(sprite.m_118409_(), sprite.m_118411_());
        float UVwidth = sprite.m_118410_() - sprite.m_118409_();
        float UVheight = sprite.m_118412_() - sprite.m_118411_();
        float WIDTH = 1.0f;
        float HEIGHT = 1.0f;
        float scale = -0.5f * (float)fluid.getAmount() / (float)capacity;
        if (scale <= 0.0f) {
            PoseStack2.m_85841_(0.5f, Math.abs(scale) + 0.21f, 0.5f);
        }
        Vec3 EAST_FACE_MIDPOINT = new Vec3(1.0, 0.5, 0.5);
        Vec3 WEST_FACE_MIDPOINT = new Vec3(0.0, 0.5, 0.5);
        Vec3 NORTH_FACE_MIDPOINT = new Vec3(0.5, 0.5, 0.0);
        Vec3 SOUTH_FACE_MIDPOINT = new Vec3(0.5, 0.5, 1.0);
        Vec3 UP_FACE_MIDPOINT = new Vec3(0.5, 1.0, 0.5);
        Vec3 DOWN_FACE_MIDPOINT = new Vec3(0.5, 0.0, 0.5);
        FluidRenderUtil.addFace(Direction.EAST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, EAST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.WEST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, WEST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.NORTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, NORTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.SOUTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, SOUTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.UP, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, UP_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.DOWN, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, DOWN_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
    }
}

