/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.train.locomotive;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.accessor.SteamHeadVehicleDataAccessor;
import dev.murad.shipping.entity.container.SteamHeadVehicleContainer;
import dev.murad.shipping.entity.custom.train.locomotive.AbstractLocomotiveEntity;
import dev.murad.shipping.entity.custom.vessel.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import dev.murad.shipping.util.ItemHandlerVanillaContainerWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SteamLocomotiveEntity
extends AbstractLocomotiveEntity
implements ItemHandlerVanillaContainerWrapper,
WorldlyContainer {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private static final int FURNACE_FUEL_MULTIPLIER = (Integer)ShippingConfig.Server.STEAM_LOCO_FUEL_MULTIPLIER.get();
    protected int burnTime = 0;
    protected int burnCapacity = 0;

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return FurnaceBlockEntity.m_58399_((ItemStack)stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public boolean isLit() {
        return this.burnTime > 0;
    }

    public int getBurnProgress() {
        int i = this.burnCapacity;
        if (i == 0) {
            i = 200;
        }
        return this.burnTime * 13 / i;
    }

    @Override
    public SteamHeadVehicleDataAccessor getDataAccessor() {
        return (SteamHeadVehicleDataAccessor)new SteamHeadVehicleDataAccessor.Builder().withBurnProgress(this::getBurnProgress).withId(this.m_19879_()).withOn(() -> this.engineOn).withRouteSize(() -> this.navigator.getRouteSize()).withVisitedSize(() -> this.navigator.getVisitedSize()).withLit(this::isLit).withCanMove(this.enrollmentHandler::mayMove).build();
    }

    @Override
    protected boolean tickFuel() {
        if (this.burnTime > 0) {
            --this.burnTime;
            return true;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.m_41619_()) {
            this.burnCapacity = ForgeHooks.getBurnTime((ItemStack)stack, null) * FURNACE_FUEL_MULTIPLIER - 1;
            this.burnTime = this.burnCapacity - 1;
            stack.m_41774_(1);
            return true;
        }
        this.burnCapacity = 0;
        this.burnTime = 0;
        return false;
    }

    @Override
    protected void onUndock() {
        super.onUndock();
        this.m_5496_((SoundEvent)ModSounds.STEAM_TUG_WHISTLE.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    @Override
    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"entity.littlelogistics.steam_locomotive");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player player) {
                return new SteamHeadVehicleContainer(i, SteamLocomotiveEntity.this.f_19853_, SteamLocomotiveEntity.this.getDataAccessor(), playerInventory, player);
            }
        };
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (!this.f_19853_.f_46443_) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
        super.m_142687_(r);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public SteamLocomotiveEntity(EntityType<?> type, Level p_38088_) {
        super(type, p_38088_);
    }

    public SteamLocomotiveEntity(Level level, Double aDouble, Double aDouble1, Double aDouble2) {
        super((EntityType)ModEntityTypes.STEAM_LOCOMOTIVE.get(), level, aDouble, aDouble1, aDouble2);
    }

    @Override
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.STEAM_LOCOMOTIVE.get());
    }

    @Override
    protected void doMovementEffect() {
        Level world = this.f_19853_;
        if (world != null) {
            BlockPos blockpos = this.m_20097_().m_7494_().m_7494_();
            RandomSource random = world.f_46441_;
            if ((double)random.m_188501_() < (Double)ShippingConfig.Client.LOCO_SMOKE_MODIFIER.get()) {
                for (int i = 0; i < random.m_188503_(2) + 2; ++i) {
                    AbstractTugEntity.makeParticles(world, blockpos, true, false);
                }
            }
        }
    }

    public boolean m_7157_(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return false;
    }

    public int[] m_7071_(Direction p_180463_1_) {
        return new int[]{0};
    }

    public boolean m_7155_(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return this.stalling.isDocked();
    }

    @Override
    public ItemStackHandler getRawHandler() {
        return this.itemHandler;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        this.itemHandler.deserializeNBT(compound.m_128469_("inv"));
        this.burnTime = compound.m_128441_("burn") ? compound.m_128451_("burn") : 0;
        this.burnCapacity = compound.m_128441_("burn_capacity") ? compound.m_128451_("burn_capacity") : 0;
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128405_("burn", this.burnTime);
        compound.m_128405_("burn_capacity", this.burnCapacity);
        super.m_7380_(compound);
    }
}

