/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.rail;

import dev.murad.shipping.block.rail.BranchingRailConfiguration;
import dev.murad.shipping.block.rail.MultiShapeRail;
import dev.murad.shipping.util.InteractionUtil;
import dev.murad.shipping.util.RailShapeUtil;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SwitchRail
extends BaseRailBlock
implements MultiShapeRail {
    public static final EnumProperty<RailShape> RAIL_SHAPE = RailShapeUtil.RAIL_SHAPE_STRAIGHT_FLAT;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<OutDirection> OUT_DIRECTION = EnumProperty.m_61587_((String)"out_direction", OutDirection.class);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final boolean automaticSwitching;

    public SwitchRail(BlockBehaviour.Properties pProperties, boolean automaticSwitching) {
        super(false, pProperties);
        this.automaticSwitching = automaticSwitching;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState blockstate = super.m_49966_();
        return (BlockState)((BlockState)((BlockState)this.setFacing(blockstate, pContext.m_8125_()).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(!this.automaticSwitching && pContext.m_43725_().m_46753_(pContext.m_8083_())))).m_61124_(OUT_DIRECTION, (Comparable)((Object)OutDirection.RIGHT));
    }

    protected BlockState m_49389_(BlockState pState, Level pLevel, BlockPos pPos, boolean pIsMoving) {
        return pState;
    }

    private RailShape getRailShapeFromFacing(Direction facing) {
        return facing.m_122434_() == Direction.Axis.X ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH;
    }

    public BlockState setFacing(BlockState state, Direction facing) {
        return (BlockState)((BlockState)state.m_61124_(RAIL_SHAPE, (Comparable)this.getRailShapeFromFacing(facing))).m_61124_(FACING, (Comparable)facing);
    }

    @Deprecated
    public Property<RailShape> m_7978_() {
        return RAIL_SHAPE;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return f_49355_;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    private BranchingRailConfiguration getRailConfiguration(BlockState state) {
        OutDirection out = (OutDirection)((Object)state.m_61143_(OUT_DIRECTION));
        Direction unpoweredDirection = (Direction)state.m_61143_(FACING);
        Direction rootDirection = unpoweredDirection.m_122424_();
        Direction poweredDirection = out.getOutDirection(rootDirection);
        return new BranchingRailConfiguration(rootDirection, unpoweredDirection, poweredDirection);
    }

    public RailShape getRailDirection(BlockState state, BlockGetter world, BlockPos pos, @Nullable AbstractMinecart cart) {
        BranchingRailConfiguration c = this.getRailConfiguration(state);
        return RailShapeUtil.getRailShape(c.getRootDirection(), (Boolean)state.m_61143_((Property)POWERED) != false ? c.getPoweredDirection() : c.getUnpoweredDirection());
    }

    @Override
    public boolean setRailState(BlockState state, Level world, BlockPos pos, Direction in, Direction out) {
        BranchingRailConfiguration c = this.getRailConfiguration(state);
        Set<Direction> possibilities = this.getPossibleOutputDirections(state, in);
        if (!this.automaticSwitching) {
            return possibilities.contains(out);
        }
        if (!possibilities.contains(out)) {
            return false;
        }
        if (in == c.getRootDirection()) {
            if (out == c.getPoweredDirection()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                return true;
            }
            if (out == c.getUnpoweredDirection()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
                return true;
            }
            return false;
        }
        if (in == c.getUnpoweredDirection() && out == c.getRootDirection()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            return true;
        }
        if (in == c.getPoweredDirection() && out == c.getRootDirection()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            return true;
        }
        return false;
    }

    @Override
    public Set<Direction> getPossibleOutputDirections(BlockState state, Direction inputSide) {
        BranchingRailConfiguration c = this.getRailConfiguration(state);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        return c.getPossibleDirections(inputSide, this.automaticSwitching, powered);
    }

    @Override
    public Set<Direction> getPriorityDirectionsToCheck(BlockState state, Direction entrance) {
        BranchingRailConfiguration c = this.getRailConfiguration(state);
        return entrance.equals((Object)c.getPoweredDirection()) ? Set.of(c.getUnpoweredDirection()) : Set.of();
    }

    @Override
    public RailShape getVanillaRailShapeFromDirection(BlockState state, BlockPos pos, Level level, Direction direction) {
        return this.getRailDirection(state, (BlockGetter)level, pos, null);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return this.setFacing(pState, pRot.m_55954_((Direction)pState.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        if (pMirror == Mirror.LEFT_RIGHT) {
            return (BlockState)pState.m_61124_(OUT_DIRECTION, (Comparable)((Object)((OutDirection)((Object)pState.m_61143_(OUT_DIRECTION))).opposite()));
        }
        if (pMirror == Mirror.FRONT_BACK) {
            return this.m_6843_(pState, pMirror.m_54846_((Direction)pState.m_61143_(FACING)));
        }
        return pState;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (InteractionUtil.doConfigure(pPlayer, pHand)) {
            pLevel.m_46597_(pPos, this.m_6943_(pState, Mirror.LEFT_RIGHT));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{f_152149_, FACING, RAIL_SHAPE, OUT_DIRECTION, POWERED});
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        boolean flag;
        super.m_6861_(state, world, pos, p_220069_4_, p_220069_5_, p_220069_6_);
        if (this.automaticSwitching) {
            return;
        }
        if (!world.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != world.m_46753_(pos)) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @javax.annotation.Nullable Direction side) {
        return true;
    }

    @Override
    public boolean isAutomaticSwitching() {
        return this.automaticSwitching;
    }

    public static enum OutDirection implements StringRepresentable
    {
        LEFT("left"),
        RIGHT("right");

        final String serializedName;

        private OutDirection(String name) {
            this.serializedName = name;
        }

        public String m_7912_() {
            return this.serializedName;
        }

        public Direction getOutDirection(Direction inDirection) {
            return this == RIGHT ? inDirection.m_122428_() : inDirection.m_122427_();
        }

        public OutDirection opposite() {
            return this == LEFT ? RIGHT : LEFT;
        }
    }
}

