/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.embedded.ca.solostudios.stringsimilarity;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.Levenshtein;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.NormalizedStringDistance;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.NormalizedStringSimilarity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/NormalizedLevenshtein;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/NormalizedStringDistance;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/NormalizedStringSimilarity;", "()V", "levenshtein", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/Levenshtein;", "distance", "", "s1", "", "s2", "similarity", "kt-string-similarity"})
public final class NormalizedLevenshtein
implements NormalizedStringDistance,
NormalizedStringSimilarity {
    @NotNull
    private final Levenshtein levenshtein = new Levenshtein();

    @Override
    public double distance(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (Intrinsics.areEqual((Object)s1, (Object)s2)) {
            return 0.0;
        }
        int n = s1.length();
        int n2 = s2.length();
        boolean bl = false;
        int maxLen = Math.max(n, n2);
        return maxLen == 0 ? 0.0 : this.levenshtein.distance(s1, s2) / (double)maxLen;
    }

    @Override
    public double similarity(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        return 1.0 - this.distance(s1, s2);
    }
}

