/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.function.BiFunction;
import java.util.function.Function;

public record EnumComponent<T extends Enum<T>>(Class<T> enumType, Function<T, String> toStringFunc, BiFunction<Class<T>, String, T> toEnumFunc) implements RecipeComponent<T>
{
    private static final Function<Enum<?>, String> DEFAULT_TO_STRING = e -> e.name().toLowerCase();
    private static final BiFunction<Class<? extends Enum<?>>, String, Enum<?>> DEFAULT_TO_ENUM = (c, s) -> {
        for (Enum e : (Enum[])c.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase((String)s)) continue;
            return e;
        }
        return null;
    };

    public EnumComponent(Class<T> enumType) {
        this(enumType, (Function)UtilsJS.cast(DEFAULT_TO_STRING), (BiFunction)UtilsJS.cast(DEFAULT_TO_ENUM));
    }

    @Override
    public String componentType() {
        return "enum";
    }

    @Override
    public Class<?> componentClass() {
        return this.enumType;
    }

    public JsonPrimitive write(RecipeJS recipe, T value) {
        return new JsonPrimitive(this.toStringFunc.apply(value));
    }

    @Override
    public T read(RecipeJS recipe, Object from) {
        Enum e;
        if (this.enumType.isInstance(from)) {
            return (T)((Enum)from);
        }
        Enum enum_ = e = from == null ? null : (Enum)this.toEnumFunc.apply(this.enumType, String.valueOf(from));
        if (e == null) {
            throw new RecipeExceptionJS("Enum value '" + from + "' of " + this.enumType.getName() + " not found");
        }
        return (T)e;
    }

    @Override
    public String toString() {
        return this.componentType();
    }
}

