/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.itemcollectors.CollectorBlock;
import com.supermartijn642.itemcollectors.CollectorBlockEntity;
import com.supermartijn642.itemcollectors.ItemCollectorsClient;
import com.supermartijn642.itemcollectors.ItemCollectorsConfig;
import com.supermartijn642.itemcollectors.generators.CollectorBlockStateGenerator;
import com.supermartijn642.itemcollectors.generators.CollectorLanguageGenerator;
import com.supermartijn642.itemcollectors.generators.CollectorLootTableGenerator;
import com.supermartijn642.itemcollectors.generators.CollectorModelGenerator;
import com.supermartijn642.itemcollectors.generators.CollectorRecipeGenerator;
import com.supermartijn642.itemcollectors.generators.CollectorTagGenerator;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketToggleDurability;
import com.supermartijn642.itemcollectors.packet.PacketToggleShowArea;
import com.supermartijn642.itemcollectors.packet.PacketToggleWhitelist;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod(value="itemcollectors")
public class ItemCollectors {
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"itemcollectors");
    @RegistryEntryAcceptor(namespace="itemcollectors", identifier="basic_collector", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock basic_collector;
    @RegistryEntryAcceptor(namespace="itemcollectors", identifier="advanced_collector", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock advanced_collector;
    @RegistryEntryAcceptor(namespace="itemcollectors", identifier="basic_collector_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<CollectorBlockEntity> basic_collector_tile;
    @RegistryEntryAcceptor(namespace="itemcollectors", identifier="advanced_collector_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<CollectorBlockEntity> advanced_collector_tile;
    @RegistryEntryAcceptor(namespace="itemcollectors", identifier="filter_collector_container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<AdvancedCollectorContainer> filter_collector_container;

    public ItemCollectors() {
        CHANNEL.registerMessage(PacketIncreaseXRange.class, PacketIncreaseXRange::new, true);
        CHANNEL.registerMessage(PacketDecreaseXRange.class, PacketDecreaseXRange::new, true);
        CHANNEL.registerMessage(PacketIncreaseYRange.class, PacketIncreaseYRange::new, true);
        CHANNEL.registerMessage(PacketDecreaseYRange.class, PacketDecreaseYRange::new, true);
        CHANNEL.registerMessage(PacketIncreaseZRange.class, PacketIncreaseZRange::new, true);
        CHANNEL.registerMessage(PacketDecreaseZRange.class, PacketDecreaseZRange::new, true);
        CHANNEL.registerMessage(PacketToggleWhitelist.class, PacketToggleWhitelist::new, true);
        CHANNEL.registerMessage(PacketToggleDurability.class, PacketToggleDurability::new, true);
        CHANNEL.registerMessage(PacketToggleShowArea.class, PacketToggleShowArea::new, true);
        ItemCollectors.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ItemCollectorsClient::register);
        ItemCollectors.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"itemcollectors");
        handler.registerBlock("basic_collector", () -> new CollectorBlock(() -> basic_collector_tile, ItemCollectorsConfig.basicCollectorMaxRange, ItemCollectorsConfig.basicCollectorFilter));
        handler.registerBlock("advanced_collector", () -> new CollectorBlock(() -> advanced_collector_tile, ItemCollectorsConfig.advancedCollectorMaxRange, ItemCollectorsConfig.advancedCollectorFilter));
        handler.registerBlockEntityType("basic_collector_tile", () -> BaseBlockEntityType.create(CollectorBlockEntity::basicCollectorEntity, (Block[])new Block[]{basic_collector}));
        handler.registerBlockEntityType("advanced_collector_tile", () -> BaseBlockEntityType.create(CollectorBlockEntity::advancedCollectorEntity, (Block[])new Block[]{advanced_collector}));
        handler.registerItem("basic_collector", () -> new BaseBlockItem((Block)basic_collector, ItemProperties.create().group(CreativeItemGroup.getDecoration())));
        handler.registerItem("advanced_collector", () -> new BaseBlockItem((Block)advanced_collector, ItemProperties.create().group(CreativeItemGroup.getDecoration())));
        handler.registerMenuType("filter_collector_container", () -> BaseContainerType.create((container, data) -> data.m_130064_(container.getCollectorPosition()), (player, data) -> new AdvancedCollectorContainer(filter_collector_container, (Player)player, ClientUtils.getWorld(), data.m_130135_())));
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"itemcollectors");
        handler.addGenerator(CollectorModelGenerator::new);
        handler.addGenerator(CollectorBlockStateGenerator::new);
        handler.addGenerator(CollectorLanguageGenerator::new);
        handler.addGenerator(CollectorLootTableGenerator::new);
        handler.addGenerator(CollectorRecipeGenerator::new);
        handler.addGenerator(CollectorTagGenerator::new);
    }
}

