/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static Slot lastDragHoverSlot;

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenMouseEvent.Drag.Pre.class, InventoryEssentialsClient::onMouseDrag);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, InventoryEssentialsClient::onMouseClick);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Pre.class, InventoryEssentialsClient::onKeyPress);
    }

    private static InventoryControls getInventoryControls() {
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    public static void onMouseDrag(ScreenMouseEvent.Drag.Pre event) {
        if (Screen.m_96638_() && InventoryEssentialsConfig.getActive().enableShiftDrag) {
            InventoryControls controls = InventoryEssentialsClient.getInventoryControls();
            Screen screen = event.getScreen();
            if (screen instanceof AbstractContainerScreen) {
                CreativeModeInventoryScreenAccessor accessor;
                AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                Slot hoverSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
                if (hoverSlot == null) {
                    return;
                }
                if (hoverSlot instanceof ResultSlot) {
                    return;
                }
                Screen screen3 = event.getScreen();
                if (screen3 instanceof CreativeModeInventoryScreenAccessor && hoverSlot.f_40218_ == (accessor = (CreativeModeInventoryScreenAccessor)screen3).getCONTAINER()) {
                    return;
                }
                if (hoverSlot.m_6657_() && hoverSlot != lastDragHoverSlot) {
                    controls.dragTransfer(screen2, hoverSlot);
                    lastDragHoverSlot = hoverSlot;
                }
            }
        } else {
            lastDragHoverSlot = null;
        }
    }

    public static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        InventoryControls controls = InventoryEssentialsClient.getInventoryControls();
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot hoverSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
            if (hoverSlot instanceof ResultSlot) {
                return;
            }
            if (Screen.m_96638_() && Screen.m_96637_() && InventoryEssentialsConfig.getActive().enableBulkTransfer) {
                if (hoverSlot != null && controls.bulkTransferByType(screen2, hoverSlot)) {
                    event.setCanceled(true);
                }
            } else if (Screen.m_96637_() && InventoryEssentialsConfig.getActive().enableSingleTransfer) {
                if (hoverSlot != null && controls.singleTransfer(screen2, hoverSlot)) {
                    event.setCanceled(true);
                }
            } else if (InventoryEssentialsClient.hasSpaceDown() && InventoryEssentialsConfig.getActive().enableBulkTransferAll && hoverSlot != null && controls.bulkTransferAll(screen2, hoverSlot)) {
                event.setCanceled(true);
            }
        }
    }

    public static void onKeyPress(ScreenKeyEvent.Press.Pre event) {
        InventoryControls controls = InventoryEssentialsClient.getInventoryControls();
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot hoverSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
            KeyMapping keyDrop = Minecraft.m_91087_().f_91066_.f_92094_;
            if (Screen.m_96638_() && Screen.m_96637_() && BalmClient.getKeyMappings().isActiveAndMatches(keyDrop, event.getKey(), event.getScanCode()) && InventoryEssentialsConfig.getActive().enableBulkDrop && hoverSlot != null && controls.dropByType(screen2, hoverSlot)) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean hasSpaceDown() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)32);
    }
}

