/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tepis.integratednbt.Additions;
import me.tepis.integratednbt.Capabilities;
import me.tepis.integratednbt.Integration;
import me.tepis.integratednbt.NBTExtractorContainer;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTExtractorRemote;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.Wrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;

public class NBTExtractorBE
extends BlockEntity
implements ICapabilityProvider,
INetworkEventListener<NetworkElement>,
MenuProvider,
Container {
    public static final int SRC_NBT_SLOT = 0;
    public static final int VAR_OUT_SLOT = 1;
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private CableCapability cableCapability = new CableCapability();
    private NetworkCarrierDefault networkCarrierCapability = new NetworkCarrierDefault();
    private PathElementTile<NBTExtractorBE> pathElementCapability = new PathElementTile((BlockEntity)this, (ICable)this.cableCapability);
    private VariableContainerDefault variableContainerCapability = new VariableContainerDefault();
    private NetworkElementProviderSingleton networkElementProviderCapability = new NetworkElementProviderSingleton(){

        public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
            return new NetworkElement();
        }
    };
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private InventoryVariableEvaluator<IValue> evaluator = new InventoryVariableEvaluator((Container)this, 0, (IValueType)ValueTypes.CATEGORY_ANY);
    private HashSet<NBTPath> expandedPaths;
    private Wrapper<Integer> scrollTop = new Wrapper<Integer>(0);
    private boolean shouldRefreshVariable = false;
    private boolean shouldUpdateOutVariable = false;
    private NBTPath extractionPath = new NBTPath();
    private byte defaultNBTId = 1;
    private NBTExtractorOutputMode outputMode = NBTExtractorOutputMode.REFERENCE;
    private Tag lastEvaluatedNBT = null;
    private Wrapper<Tag> frozenNBT = null;
    private boolean autoRefresh = true;
    private ItemStack frozenNBTItemStack = ItemStack.f_41583_;

    public NBTExtractorBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Additions.NBT_EXTRACTOR_BE.get(), pos, state);
        this.expandedPaths = new HashSet();
        this.expandedPaths.add(new NBTPath());
    }

    public NBTExtractorOutputMode getOutputMode() {
        return this.outputMode;
    }

    public void setOutputMode(NBTExtractorOutputMode outputMode) {
        this.outputMode = outputMode;
        this.m_6596_();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.refreshVariables(true);
            this.shouldUpdateOutVariable = true;
            if (!this.autoRefresh && !ItemStack.m_41728_((ItemStack)this.m_8020_(0), (ItemStack)this.frozenNBTItemStack)) {
                this.frozenNBTItemStack = this.m_8020_(0);
                this.frozenNBT = null;
            }
        }
    }

    public void refreshVariables(boolean sendVariablesUpdateEvent) {
        this.evaluator.refreshVariable(this.networkCarrierCapability.getNetwork(), sendVariablesUpdateEvent);
        this.variableContainerCapability.refreshVariables(this.networkCarrierCapability.getNetwork(), (Container)this, sendVariablesUpdateEvent);
    }

    @Nonnull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    public void setDefaultNBTId(byte defaultNBTId) {
        this.defaultNBTId = defaultNBTId < 1 || defaultNBTId > 12 ? (byte)1 : defaultNBTId;
        this.m_6596_();
    }

    public NBTPath getExtractionPath() {
        return this.extractionPath;
    }

    public void setExtractionPath(NBTPath extractionPath) {
        this.extractionPath = extractionPath;
        this.m_6596_();
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void updateAutoRefresh(boolean autoRefresh) {
        if (this.autoRefresh == autoRefresh) {
            return;
        }
        this.autoRefresh = autoRefresh;
        if (!autoRefresh) {
            this.frozenNBT = null;
            this.frozenNBTItemStack = ItemStack.f_41583_;
        }
        this.m_6596_();
    }

    public void updateLastEvaluatedNBT(Tag lastEvaluatedNBT) {
        this.lastEvaluatedNBT = lastEvaluatedNBT;
        if (!this.autoRefresh && this.frozenNBT == null) {
            this.frozenNBT = Wrapper.of(this.lastEvaluatedNBT);
            this.frozenNBTItemStack = this.m_8020_(0).m_41777_();
        }
    }

    public HashSet<NBTPath> getExpandedPaths() {
        return this.expandedPaths;
    }

    public Wrapper<Integer> getScrollTop() {
        return this.scrollTop;
    }

    public IVariable<?> getSrcNBTVariable() {
        IPartNetwork partNetwork = (IPartNetwork)NetworkHelpers.getPartNetwork((INetwork)this.networkCarrierCapability.getNetwork()).orElse(null);
        if (partNetwork == null) {
            return null;
        }
        return this.evaluator.getVariable(partNetwork);
    }

    public Component getFirstErrorMessage() {
        List errors = this.evaluator.getErrors();
        if (errors.isEmpty()) {
            return null;
        }
        return (Component)errors.get(0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == Capabilities.CABLE_CAPABILITY) {
            return LazyOptional.of(() -> this.cableCapability);
        }
        if (capability == Capabilities.NETWORK_CARRIER_CAPABILITY) {
            return LazyOptional.of(() -> this.networkCarrierCapability);
        }
        if (capability == Capabilities.PATH_ELEMENT_CAPABILITY) {
            return LazyOptional.of(() -> this.pathElementCapability);
        }
        if (capability == Capabilities.VARIABLE_CONTAINER_CAPABILITY) {
            return LazyOptional.of(() -> this.variableContainerCapability);
        }
        if (capability == Capabilities.NETWORK_ELEMENT_PROVIDER) {
            return LazyOptional.of(() -> this.networkElementProviderCapability);
        }
        return super.getCapability(capability, facing);
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public boolean m_7983_() {
        return false;
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.itemStacks, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.itemStacks, (int)index);
    }

    public void m_6836_(int index, @Nonnull ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(@Nonnull Player player) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        if (player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0) {
            return true;
        }
        return this.isRemote(player.m_21205_()) || this.isRemote(player.m_21206_());
    }

    private boolean isRemote(ItemStack itemStack) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (itemStack.m_41720_() != Additions.NBT_EXTRACTOR_REMOTE.get()) {
            return false;
        }
        CompoundTag tag = ((NBTExtractorRemote)((Object)Additions.NBT_EXTRACTOR_REMOTE.get())).getModNBT(itemStack);
        return tag.m_128441_("world") && tag.m_128461_("world").equals(this.f_58857_.m_46472_().m_135782_().toString()) && tag.m_128451_("x") == this.f_58858_.m_123341_() && tag.m_128451_("y") == this.f_58858_.m_123342_() && tag.m_128451_("z") == this.f_58858_.m_123343_();
    }

    public void m_5856_(@Nonnull Player player) {
    }

    public void m_5785_(@Nonnull Player player) {
    }

    public boolean m_7013_(int index, @Nonnull ItemStack stack) {
        return Integration.isVariable(stack);
    }

    public Wrapper<Tag> getFrozenValue() {
        if (this.autoRefresh) {
            return null;
        }
        return this.frozenNBT;
    }

    public void m_6211_() {
        this.itemStacks.clear();
    }

    public boolean hasEventSubscriptions() {
        return true;
    }

    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Collections.singleton(VariableContentsUpdatedEvent.class);
    }

    public void onEvent(INetworkEvent event, NetworkElement networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.refreshVariables(false);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSide()) {
            this.shouldRefreshVariable = true;
        }
    }

    public void m_183515_(CompoundTag tag) {
        ListTag errorsList = new ListTag();
        NBTClassType.writeNbt(List.class, (String)"errors", (Object)this.evaluator.getErrors(), (CompoundTag)tag);
        tag.m_128365_("errors", (Tag)errorsList);
        tag.m_128365_("path", (Tag)this.extractionPath.toNBT());
        tag.m_128344_("defaultNBTId", this.defaultNBTId);
        tag.m_128344_("outputMode", (byte)this.outputMode.ordinal());
        tag.m_128379_("isAutoRefresh", this.autoRefresh);
        if (!this.autoRefresh) {
            if (this.frozenNBT != null) {
                CompoundTag compound = new CompoundTag();
                if (this.frozenNBT.get() != null) {
                    compound.m_128365_("value", this.frozenNBT.get());
                }
                tag.m_128365_("frozenNBT", (Tag)compound);
            }
            tag.m_128365_("frozenNBTItemStack", (Tag)this.frozenNBTItemStack.m_41739_(new CompoundTag()));
        }
        ContainerHelper.m_18973_((CompoundTag)tag, this.itemStacks);
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)"tile.integratednbt:nbt_extractor.name");
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("errors")) {
            this.evaluator.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors", (CompoundTag)tag));
        }
        if (tag.m_128441_("path")) {
            this.extractionPath = NBTPath.fromNBT(tag.m_128423_("path")).orElse(new NBTPath());
        }
        if (tag.m_128441_("defaultNBTId")) {
            this.defaultNBTId = tag.m_128445_("defaultNBTId");
        }
        if (tag.m_128441_("outputMode")) {
            this.outputMode = NBTExtractorOutputMode.values()[tag.m_128445_("outputMode")];
        }
        if (tag.m_128441_("isAutoRefresh")) {
            this.autoRefresh = tag.m_128471_("isAutoRefresh");
            if (!this.autoRefresh) {
                if (tag.m_128441_("frozenNBT")) {
                    this.frozenNBT = Wrapper.of(tag.m_128469_("frozenNBT").m_128423_("value"));
                }
                this.frozenNBTItemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("frozenNBTItemStack"));
            }
        }
        ContainerHelper.m_18980_((CompoundTag)tag, this.itemStacks);
        this.shouldRefreshVariable = true;
        super.m_142466_(tag);
    }

    public void afterNetworkReAlive() {
        this.shouldRefreshVariable = true;
        this.connected.clear();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory inventory, @Nonnull Player player) {
        return new NBTExtractorContainer(windowId, inventory, this);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (level == null) {
            return;
        }
        if (!level.f_46443_) {
            NBTExtractorBE self = (NBTExtractorBE)blockEntity;
            if (self.shouldRefreshVariable && self.networkCarrierCapability.getNetwork() != null) {
                self.shouldRefreshVariable = false;
                self.refreshVariables(true);
            }
            if (self.shouldUpdateOutVariable) {
                self.updateOutVariable();
                self.shouldUpdateOutVariable = false;
            }
        }
    }

    private void updateOutVariable() {
        ItemStack result;
        if (!((ItemStack)this.itemStacks.get(1)).m_41619_() && (result = this.outputMode.writeItemStack(() -> {
            this.refreshVariables(true);
            return this.evaluator.getVariableFacade();
        }, (ItemStack)this.itemStacks.get(1), !this.autoRefresh && this.frozenNBT != null ? this.frozenNBT.get() : this.lastEvaluatedNBT, this.extractionPath, this.defaultNBTId, this.m_58900_())) != null) {
            this.itemStacks.set(1, (Object)result);
        }
    }

    class CableCapability
    implements ICable {
        CableCapability() {
        }

        public boolean canConnect(ICable connector, Direction side) {
            return true;
        }

        public boolean isConnected(Direction side) {
            if (NBTExtractorBE.this.connected.isEmpty()) {
                this.updateConnections();
            }
            return (Boolean)NBTExtractorBE.this.connected.get((Object)side);
        }

        public void updateConnections() {
            NBTExtractorBE entity = NBTExtractorBE.this;
            Level world = entity.m_58904_();
            if (world == null) {
                return;
            }
            for (Direction side : Direction.values()) {
                boolean cableConnected = CableHelpers.canCableConnectTo((BlockGetter)world, (BlockPos)entity.m_58899_(), (Direction)side, (ICable)this);
                entity.connected.put((Enum)side, (Object)cableConnected);
            }
            world.m_151543_(entity.m_58899_());
            BlockState blockState = world.m_8055_(NBTExtractorBE.this.f_58858_);
            world.m_7260_(NBTExtractorBE.this.f_58858_, blockState, blockState, 3);
        }

        public void disconnect(Direction side) {
        }

        public void reconnect(Direction side) {
        }

        public ItemStack getItemStack() {
            return new ItemStack((ItemLike)Additions.NBT_EXTRACTOR_BLOCK_ITEM.get());
        }

        public void destroy() {
        }
    }

    class NetworkElement
    implements IEventListenableNetworkElement<NBTExtractorBE> {
        NetworkElement() {
        }

        public int getUpdateInterval() {
            return 0;
        }

        public boolean isUpdate() {
            return false;
        }

        public void update(INetwork network) {
        }

        public void beforeNetworkKill(INetwork network) {
        }

        public void afterNetworkAlive(INetwork network) {
        }

        public void afterNetworkReAlive(INetwork network) {
            NBTExtractorBE.this.afterNetworkReAlive();
        }

        public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        }

        public boolean onNetworkAddition(INetwork network) {
            if (NBTExtractorBE.this.f_58857_ == null) {
                return false;
            }
            return NetworkHelpers.getPartNetwork((INetwork)network).map(partNetwork -> partNetwork.addVariableContainer(DimPos.of((Level)NBTExtractorBE.this.f_58857_, (BlockPos)NBTExtractorBE.this.f_58858_))).orElse(false);
        }

        public void onNetworkRemoval(INetwork network) {
            if (NBTExtractorBE.this.f_58857_ == null) {
                return;
            }
            NetworkHelpers.getPartNetwork((INetwork)network).ifPresent(partNetwork -> partNetwork.removeVariableContainer(DimPos.of((Level)NBTExtractorBE.this.f_58857_, (BlockPos)NBTExtractorBE.this.f_58858_)));
        }

        public void onPreRemoved(INetwork network) {
        }

        public void onPostRemoved(INetwork network) {
        }

        public void onNeighborBlockChange(@Nullable INetwork network, BlockGetter world, Block neighbourBlock, BlockPos neighbourBlockPos) {
        }

        public void setPriorityAndChannel(INetwork network, int priority, int channel) {
        }

        public int getPriority() {
            return 0;
        }

        public int getChannel() {
            return 0;
        }

        public void invalidate(INetwork network) {
            network.invalidateElement((INetworkElement)this);
        }

        public boolean canRevalidate(INetwork network) {
            if (NBTExtractorBE.this.f_58857_ == null) {
                return false;
            }
            return NBTExtractorBE.this.f_58857_.m_46805_(NBTExtractorBE.this.m_58899_());
        }

        public void revalidate(INetwork network) {
            network.revalidateElement((INetworkElement)this);
        }

        public int compareTo(INetworkElement o) {
            return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
        }

        @Nullable
        public Optional<NBTExtractorBE> getNetworkEventListener() {
            return Optional.of(NBTExtractorBE.this);
        }
    }
}

