/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.FluidCollectorConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidCollectorTile
extends IndustrialAreaWorkingTile<FluidCollectorTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<FluidCollectorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("output", FluidCollectorConfig.maxOutputTankSize, 43, 20, 0).setColor(DyeColor.ORANGE).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this);

    public FluidCollectorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.FLUID_COLLECTOR, RangeManager.RangeType.BEHIND, false, FluidCollectorConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.tank);
        this.getMaxProgress = FluidCollectorConfig.maxProgress;
        this.getPowerPerOperation = FluidCollectorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pointed;
        if (this.hasEnergy(this.getPowerPerOperation) && this.isLoaded(pointed = this.getPointedBlockPos()) && !this.f_58857_.m_46859_(pointed) && BlockUtils.canBlockBeBroken(this.f_58857_, pointed) && this.f_58857_.m_6425_(pointed).m_76170_()) {
            Fluid fluid = this.f_58857_.m_6425_(pointed).m_76152_();
            if (this.tank.isEmpty() || this.tank.getFluid().getFluid().m_6212_(fluid) && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity()) {
                if (this.f_58857_.m_8055_(pointed).m_61138_((Property)BlockStateProperties.f_61362_)) {
                    this.f_58857_.m_46597_(pointed, (BlockState)this.f_58857_.m_8055_(pointed).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                } else {
                    this.f_58857_.m_46597_(pointed, Blocks.f_50016_.m_49966_());
                }
                this.tank.fillForced(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<FluidCollectorTile> createEnergyStorage() {
        return new EnergyStorageComponent(FluidCollectorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public FluidCollectorTile getSelf() {
        return this;
    }
}

