/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.PatternIota;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.gui.PatternTooltipComponent;
import at.petrak.hexcasting.common.misc.PatternTooltip;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ItemSlate
extends BlockItem
implements IotaHolderItem {
    public static final ResourceLocation WRITTEN_PRED = HexAPI.modLoc("written");

    public ItemSlate(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public Component m_7626_(ItemStack pStack) {
        String key = "block.hexcasting.slate." + (ItemSlate.hasPattern(pStack) ? "written" : "blank");
        return Component.m_237115_((String)key);
    }

    public static boolean hasPattern(ItemStack stack) {
        CompoundTag bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet != null) {
            return bet.m_128425_("pattern", 10) && !bet.m_128469_("pattern").m_128456_();
        }
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!ItemSlate.hasPattern(stack)) {
            NBTHelper.remove(stack, "BlockEntityTag");
        }
        return false;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!ItemSlate.hasPattern(pStack)) {
            NBTHelper.remove(pStack, "BlockEntityTag");
        }
    }

    @Override
    @Nullable
    public CompoundTag readIotaTag(ItemStack stack) {
        CompoundTag bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet == null || !bet.m_128425_("pattern", 10)) {
            return null;
        }
        CompoundTag patTag = bet.m_128469_("pattern");
        if (patTag.m_128456_()) {
            return null;
        }
        CompoundTag out = new CompoundTag();
        out.m_128359_("hexcasting:type", "hexcasting:pattern");
        out.m_128365_("hexcasting:data", (Tag)patTag);
        return out;
    }

    @Override
    public boolean canWrite(ItemStack stack, Iota datum) {
        boolean isWritten = NBTHelper.hasCompound(stack, "BlockEntityTag") && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("pattern");
        return datum instanceof PatternIota && !isWritten || datum == null && isWritten;
    }

    @Override
    public void writeDatum(ItemStack stack, Iota datum) {
        if (this.canWrite(stack, datum)) {
            if (datum == null) {
                CompoundTag beTag = NBTHelper.getOrCreateCompound(stack, "BlockEntityTag");
                beTag.m_128473_("pattern");
                if (beTag.m_128456_()) {
                    NBTHelper.remove(stack, "BlockEntityTag");
                }
            } else if (datum instanceof PatternIota) {
                PatternIota pat = (PatternIota)datum;
                CompoundTag beTag = NBTHelper.getOrCreateCompound(stack, "BlockEntityTag");
                beTag.m_128365_("pattern", (Tag)pat.getPattern().serializeToNBT());
            }
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        CompoundTag patTag;
        CompoundTag bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet != null && bet.m_128425_("pattern", 10) && !(patTag = bet.m_128469_("pattern")).m_128456_()) {
            HexPattern pattern = HexPattern.fromNBT(patTag);
            return Optional.of(new PatternTooltip(pattern, PatternTooltipComponent.SLATE_BG));
        }
        return Optional.empty();
    }
}

