/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.math;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.spell.math.EulerPathFinder;
import at.petrak.hexcasting.api.spell.math.HexAngle;
import at.petrak.hexcasting.api.spell.math.HexCoord;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tH\u0007J\"\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lat/petrak/hexcasting/api/spell/math/EulerPathFinder;", "", "()V", "findAltDrawing", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "original", "seed", "", "rule", "Lkotlin/Function1;", "", "toGraph", "Ljava/util/HashMap;", "Lat/petrak/hexcasting/api/spell/math/HexCoord;", "Ljava/util/EnumSet;", "Lat/petrak/hexcasting/api/spell/math/HexDir;", "pat", "walkPath", "rand", "Lkotlin/random/Random;", "hexcasting-forge-1.19.2"})
public final class EulerPathFinder {
    @NotNull
    public static final EulerPathFinder INSTANCE = new EulerPathFinder();

    private EulerPathFinder() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final HexPattern findAltDrawing(@NotNull HexPattern original, long seed, @NotNull Function1<? super HexPattern, Boolean> rule) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter(rule, (String)"rule");
        Random rand = RandomKt.Random((long)seed);
        HexPattern path = null;
        for (int iterationsLeft = 100; iterationsLeft > 0; --iterationsLeft) {
            path = INSTANCE.walkPath(original, rand);
            if (!((Boolean)rule.invoke((Object)path)).booleanValue()) continue;
            return path;
        }
        HexAPI.LOGGER.warn("Didn't find alternate path for {} in time", (Object)original);
        return original;
    }

    public static /* synthetic */ HexPattern findAltDrawing$default(HexPattern hexPattern, long l, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = findAltDrawing.1.INSTANCE;
        }
        return EulerPathFinder.findAltDrawing(hexPattern, l, (Function1<? super HexPattern, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final HexPattern walkPath(HexPattern original, Random rand) {
        List list;
        HexDir a;
        List list2;
        List list3;
        boolean bl;
        void $this$filterTo$iv$iv;
        HashMap<HexCoord, EnumSet<HexDir>> graph = this.toGraph(original);
        Map $this$filter$iv = graph;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl2 = false;
            EnumSet dirs = (EnumSet)entry.getValue();
            if (!(dirs.size() % 2 == 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map oddNodes = destination$iv$iv;
        HexCoord current = switch (oddNodes.size()) {
            case 0 -> {
                Set<HexCoord> v0 = graph.keySet();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"graph.keys");
                Object v1 = CollectionsKt.random((Collection)v0, (Random)rand);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"graph.keys.random(rand)");
                yield (HexCoord)v1;
            }
            case 2 -> (HexCoord)CollectionsKt.random((Collection)oddNodes.keySet(), (Random)rand);
            default -> throw new IllegalStateException();
        };
        Stack<HexCoord> stack = new Stack<HexCoord>();
        List out = new ArrayList();
        do {
            EnumSet<HexDir> exits;
            Intrinsics.checkNotNull(graph.get(current));
            if (exits.isEmpty()) {
                out.add(current);
                Object e = stack.pop();
                Intrinsics.checkNotNullExpressionValue(e, (String)"stack.pop()");
                current = (HexCoord)e;
            } else {
                stack.push(current);
                HexDir burnDir = (HexDir)((Object)CollectionsKt.random((Collection)exits, (Random)rand));
                exits.remove((Object)burnDir);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)burnDir), (String)"burnDir");
                EnumSet<HexDir> enumSet = graph.get(current.plus(burnDir));
                if (enumSet != null) {
                    enumSet.remove((Object)burnDir.times(HexAngle.BACK));
                }
                current = current.plus(burnDir);
            }
            EnumSet<HexDir> enumSet = graph.get(current);
            if (enumSet != null) {
                if (!((Collection)enumSet).isEmpty()) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (bl || !((Collection)stack).isEmpty());
        out.add(current);
        Iterable $this$zipWithNext$iv = out;
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list3 = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                Object next$iv = iterator$iv.next();
                HexCoord hexCoord = (HexCoord)next$iv;
                HexCoord hexCoord2 = (HexCoord)current$iv;
                list2 = result$iv;
                boolean bl3 = false;
                HexDir hexDir = ((HexCoord)((Object)a)).immediateDelta((HexCoord)b);
                Intrinsics.checkNotNull((Object)((Object)hexDir));
                list2.add(hexDir);
                current$iv = next$iv;
            }
            list3 = result$iv;
        }
        List dirs = list3;
        Iterable $this$zipWithNext$iv2 = dirs;
        boolean $i$f$zipWithNext2 = false;
        Iterator iterator$iv2 = $this$zipWithNext$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv2.next();
            while (iterator$iv2.hasNext()) {
                void a2;
                void b;
                Object next$iv = iterator$iv2.next();
                a = (HexDir)((Object)next$iv);
                HexDir bl3 = (HexDir)((Object)current$iv);
                list2 = result$iv;
                boolean bl4 = false;
                list2.add(b.angleFrom((HexDir)a2));
                current$iv = next$iv;
            }
            list = result$iv;
        }
        List angles = list;
        return new HexPattern((HexDir)((Object)dirs.get(0)), CollectionsKt.toMutableList((Collection)angles));
    }

    private final HashMap<HexCoord, EnumSet<HexDir>> toGraph(HexPattern pat) {
        Object object;
        Object object2;
        HashMap<HexCoord, EnumSet<HexDir>> graph = new HashMap<HexCoord, EnumSet<HexDir>>();
        HexDir compass = pat.getStartDir();
        HexCoord cursor = HexCoord.Companion.getOrigin();
        for (HexAngle a : pat.getAngles()) {
            Object object3;
            Object object4;
            Map $this$getOrPut$iv = graph;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(cursor);
            if (value$iv == null) {
                EnumSet<HexDir> answer$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(EnumSet.noneOf(HexDir.class), (String)"noneOf(HexDir::class.java)");
                $this$getOrPut$iv.put(cursor, answer$iv);
                object4 = answer$iv;
            } else {
                object4 = value$iv;
            }
            ((EnumSet)object4).add(compass);
            $this$getOrPut$iv = graph;
            HexCoord key$iv = cursor.plus(compass);
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv.get(key$iv);
            if (value$iv2 == null) {
                EnumSet<HexDir> answer$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(EnumSet.noneOf(HexDir.class), (String)"noneOf(HexDir::class.java)");
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv2;
            }
            ((EnumSet)object3).add(compass.times(HexAngle.BACK));
            cursor = cursor.plus(compass);
            compass = compass.times(a);
        }
        Map $this$getOrPut$iv = graph;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(cursor);
        if (value$iv == null) {
            boolean bl = false;
            EnumSet<HexDir> enumSet = EnumSet.noneOf(HexDir.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(HexDir::class.java)");
            EnumSet<HexDir> answer$iv = enumSet;
            $this$getOrPut$iv.put(cursor, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        ((EnumSet)object2).add(compass);
        $this$getOrPut$iv = graph;
        HexCoord key$iv = cursor.plus(compass);
        boolean $i$f$getOrPut3 = false;
        Object value$iv3 = $this$getOrPut$iv.get(key$iv);
        if (value$iv3 == null) {
            boolean bl = false;
            EnumSet<HexDir> enumSet = EnumSet.noneOf(HexDir.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(HexDir::class.java)");
            EnumSet<HexDir> answer$iv = enumSet;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv3;
        }
        ((EnumSet)object).add(compass.times(HexAngle.BACK));
        return graph;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final HexPattern findAltDrawing(@NotNull HexPattern original, long seed) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return EulerPathFinder.findAltDrawing$default(original, seed, null, 4, null);
    }
}

