/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api;

import at.petrak.hexcasting.api.spell.Action;
import at.petrak.hexcasting.api.spell.math.EulerPathFinder;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidPattern;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function1;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.Nullable;

public class PatternRegistry {
    private static final ConcurrentMap<ResourceLocation, Action> actionLookup = new ConcurrentHashMap<ResourceLocation, Action>();
    private static final ConcurrentMap<Action, ResourceLocation> keyLookup = new ConcurrentHashMap<Action, ResourceLocation>();
    private static final ConcurrentLinkedDeque<SpecialHandlerEntry> specialHandlers = new ConcurrentLinkedDeque();
    private static final ConcurrentMap<String, RegularEntry> regularPatternLookup = new ConcurrentHashMap<String, RegularEntry>();
    private static final ConcurrentMap<ResourceLocation, PerWorldEntry> perWorldPatternLookup = new ConcurrentHashMap<ResourceLocation, PerWorldEntry>();
    public static final String TAG_SAVED_DATA = "hex.per-world-patterns";

    public static void mapPattern(HexPattern pattern, ResourceLocation id, Action action) throws RegisterPatternException {
        PatternRegistry.mapPattern(pattern, id, action, false);
    }

    public static void mapPattern(HexPattern pattern, ResourceLocation id, Action action, boolean isPerWorld) throws RegisterPatternException {
        if (actionLookup.containsKey(id)) {
            throw new RegisterPatternException("The operator with id `%s` was already registered to: %s", id, actionLookup.get(id));
        }
        actionLookup.put(id, action);
        keyLookup.put(action, id);
        if (isPerWorld) {
            perWorldPatternLookup.put(id, new PerWorldEntry(pattern, id));
        } else {
            regularPatternLookup.put(pattern.anglesSignature(), new RegularEntry(pattern.getStartDir(), id));
        }
    }

    public static void addSpecialHandler(SpecialHandlerEntry handler) {
        specialHandlers.add(handler);
    }

    public static void addSpecialHandler(ResourceLocation id, SpecialHandler handler) {
        PatternRegistry.addSpecialHandler(new SpecialHandlerEntry(id, handler));
    }

    public static Action matchPattern(HexPattern pat, ServerLevel overworld) throws MishapInvalidPattern {
        return (Action)PatternRegistry.matchPatternAndID(pat, overworld).getFirst();
    }

    public static Pair<Action, ResourceLocation> matchPatternAndID(HexPattern pat, ServerLevel overworld) throws MishapInvalidPattern {
        Action op;
        for (SpecialHandlerEntry handler : specialHandlers) {
            op = handler.handler.handlePattern(pat);
            if (op == null) continue;
            return new Pair((Object)op, (Object)handler.id);
        }
        String sig = pat.anglesSignature();
        if (regularPatternLookup.containsKey(sig)) {
            RegularEntry it = (RegularEntry)regularPatternLookup.get(sig);
            if (!actionLookup.containsKey(it.opId)) {
                throw new MishapInvalidPattern();
            }
            op = (Action)actionLookup.get(it.opId);
            return new Pair((Object)op, (Object)it.opId);
        }
        DimensionDataStorage ds = overworld.m_8895_();
        Save perWorldPatterns = (Save)ds.m_164861_(Save::load, () -> Save.create(overworld.m_7328_()), TAG_SAVED_DATA);
        perWorldPatterns.fillMissingEntries(overworld.m_7328_());
        if (perWorldPatterns.lookup.containsKey(sig)) {
            Pair<ResourceLocation, HexDir> it = perWorldPatterns.lookup.get(sig);
            return new Pair((Object)((Action)actionLookup.get(it.getFirst())), (Object)((ResourceLocation)it.getFirst()));
        }
        throw new MishapInvalidPattern();
    }

    @Nullable
    public static Action lookupPatternByShape(HexPattern pat) {
        for (SpecialHandlerEntry handler : specialHandlers) {
            Action op = handler.handler.handlePattern(pat);
            if (op == null) continue;
            return op;
        }
        String sig = pat.anglesSignature();
        if (regularPatternLookup.containsKey(sig)) {
            RegularEntry it = (RegularEntry)regularPatternLookup.get(sig);
            if (!actionLookup.containsKey(it.opId)) {
                return null;
            }
            return (Action)actionLookup.get(it.opId);
        }
        return null;
    }

    public static Map<String, Pair<ResourceLocation, HexDir>> getPerWorldPatterns(ServerLevel overworld) {
        DimensionDataStorage ds = overworld.m_8895_();
        Save perWorldPatterns = (Save)ds.m_164861_(Save::load, () -> Save.create(overworld.m_7328_()), TAG_SAVED_DATA);
        return perWorldPatterns.lookup;
    }

    public static ResourceLocation lookupPattern(Action action) {
        return (ResourceLocation)keyLookup.get(action);
    }

    public static PatternEntry lookupPattern(ResourceLocation opId) {
        if (perWorldPatternLookup.containsKey(opId)) {
            PerWorldEntry it = (PerWorldEntry)perWorldPatternLookup.get(opId);
            return new PatternEntry(it.prototype, (Action)actionLookup.get(it.opId), true);
        }
        for (Map.Entry kv : regularPatternLookup.entrySet()) {
            String sig = (String)kv.getKey();
            RegularEntry entry = (RegularEntry)kv.getValue();
            if (!entry.opId.equals((Object)opId)) continue;
            HexPattern pattern = HexPattern.fromAngles(sig, entry.preferredStart);
            return new PatternEntry(pattern, (Action)actionLookup.get(entry.opId), false);
        }
        throw new IllegalArgumentException("could not find a pattern for " + opId);
    }

    public static Set<ResourceLocation> getAllPerWorldPatternNames() {
        return perWorldPatternLookup.keySet();
    }

    public static String getPatternCountInfo() {
        return String.format("Loaded %d regular patterns, %d per-world patterns, and %d special handlers.", regularPatternLookup.size(), perWorldPatternLookup.size(), specialHandlers.size());
    }

    public static class RegisterPatternException
    extends Exception {
        public RegisterPatternException(String msg, Object ... formats) {
            super(String.format(msg, formats));
        }
    }

    private record PerWorldEntry(HexPattern prototype, ResourceLocation opId) {
    }

    private record RegularEntry(HexDir preferredStart, ResourceLocation opId) {
    }

    public record SpecialHandlerEntry(ResourceLocation id, SpecialHandler handler) {
    }

    @FunctionalInterface
    public static interface SpecialHandler {
        @Nullable
        public Action handlePattern(HexPattern var1);
    }

    public static class Save
    extends SavedData {
        private static final String TAG_OP_ID = "op_id";
        private static final String TAG_START_DIR = "start_dir";
        private Map<String, Pair<ResourceLocation, HexDir>> lookup;
        private boolean missingEntries;

        public Save(Map<String, Pair<ResourceLocation, HexDir>> lookup, boolean missingEntries) {
            this.lookup = lookup;
            this.missingEntries = missingEntries;
        }

        public Save(Map<String, Pair<ResourceLocation, HexDir>> lookup) {
            this(lookup, Save.missingEntries(lookup));
        }

        private static boolean missingEntries(Map<String, Pair<ResourceLocation, HexDir>> lookup) {
            Set allIds = lookup.values().stream().map(Pair::getFirst).collect(Collectors.toSet());
            return perWorldPatternLookup.values().stream().anyMatch(it -> allIds.contains(it.opId));
        }

        private void fillMissingEntries(long seed) {
            if (this.missingEntries) {
                boolean doneAny = false;
                Set allIds = this.lookup.values().stream().map(Pair::getFirst).collect(Collectors.toSet());
                for (PerWorldEntry entry : perWorldPatternLookup.values()) {
                    if (allIds.contains(entry.opId)) continue;
                    Save.scrungle(this.lookup, entry.prototype, entry.opId, seed);
                    doneAny = true;
                }
                if (doneAny) {
                    this.m_77762_();
                    this.missingEntries = false;
                }
            }
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            this.lookup.forEach((sig, rhs) -> {
                CompoundTag entry = new CompoundTag();
                entry.m_128359_(TAG_OP_ID, ((ResourceLocation)rhs.getFirst()).toString());
                entry.m_128405_(TAG_START_DIR, ((HexDir)((Object)((Object)rhs.getSecond()))).ordinal());
                tag.m_128365_(sig, (Tag)entry);
            });
            return tag;
        }

        private static Save load(CompoundTag tag) {
            HashMap<String, Pair<ResourceLocation, HexDir>> map = new HashMap<String, Pair<ResourceLocation, HexDir>>();
            HashSet<ResourceLocation> allIds = new HashSet<ResourceLocation>();
            for (String sig : tag.m_128431_()) {
                CompoundTag entry = tag.m_128469_(sig);
                ResourceLocation opId = ResourceLocation.m_135820_((String)entry.m_128461_(TAG_OP_ID));
                allIds.add(opId);
                HexDir startDir = HexDir.values()[entry.m_128451_(TAG_START_DIR)];
                map.put(sig, (Pair<ResourceLocation, HexDir>)new Pair((Object)opId, (Object)startDir));
            }
            boolean missingEntries = perWorldPatternLookup.values().stream().anyMatch(it -> allIds.contains(it.opId));
            return new Save(map, missingEntries);
        }

        private static void scrungle(Map<String, Pair<ResourceLocation, HexDir>> lookup, HexPattern prototype, ResourceLocation opId, long seed) {
            HexPattern scrungled = EulerPathFinder.findAltDrawing(prototype, seed, (Function1<? super HexPattern, Boolean>)((Function1)it -> {
                String sig = it.anglesSignature();
                return !lookup.containsKey(sig) && !regularPatternLookup.containsKey(sig) && specialHandlers.stream().noneMatch(handler -> handler.handler.handlePattern((HexPattern)it) != null);
            }));
            lookup.put(scrungled.anglesSignature(), (Pair<ResourceLocation, HexDir>)new Pair((Object)opId, (Object)scrungled.getStartDir()));
        }

        public static Save create(long seed) {
            HashMap<String, Pair<ResourceLocation, HexDir>> map = new HashMap<String, Pair<ResourceLocation, HexDir>>();
            perWorldPatternLookup.values().forEach(it -> Save.scrungle(map, it.prototype, it.opId, seed));
            Save save = new Save(map);
            save.m_77762_();
            return save;
        }
    }

    public record PatternEntry(HexPattern prototype, Action action, boolean isPerWorld) {
    }
}

