/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.blocks.entity;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.api.mediafieditems.ItemRecord;
import ram.talia.hexal.api.mediafieditems.MediafiedItemManager;
import ram.talia.hexal.common.lib.HexalBlockEntities;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 92\u00020\u0001:\u000289B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\nJ\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\tJ\u0016\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u0003J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,J\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010/\u001a\u00020-J\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010#\u001a\u00020\nJ\b\u00100\u001a\u000201H\u0016J\u0006\u00102\u001a\u00020\u0013J\u0010\u00103\u001a\u00020%2\u0006\u00104\u001a\u000201H\u0014J\u000e\u00105\u001a\u00020%2\u0006\u0010'\u001a\u00020\tJ\u0010\u00106\u001a\u00020%2\u0006\u00104\u001a\u000201H\u0014J\u0006\u00107\u001a\u00020%R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006:"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage;", "Lat/petrak/hexcasting/api/block/HexBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "_storedItems", "", "", "Lram/talia/hexal/api/mediafieditems/ItemRecord;", "currentAnimation", "Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState;", "getCurrentAnimation", "()Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState;", "setCurrentAnimation", "(Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState;)V", "currentItemIndex", "hasRegisteredToMediafiedItemManager", "", "getPos", "()Lnet/minecraft/core/BlockPos;", "getState", "()Lnet/minecraft/world/level/block/state/BlockState;", "storedItems", "", "getStoredItems", "()Ljava/util/Map;", "<set-?>", "Ljava/util/UUID;", "uuid", "getUuid", "()Ljava/util/UUID;", "assignItem", "Lram/talia/hexal/api/mediafieditems/MediafiedItemManager$Index;", "itemRecord", "clientTick", "", "contains", "index", "dropAllContents", "level", "Lnet/minecraft/server/level/ServerLevel;", "getAllContainedItemTypes", "", "Lnet/minecraft/world/item/Item;", "getItemRecordsMatching", "item", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "isFull", "loadModData", "tag", "removeStoredItem", "saveModData", "serverTick", "AnimationState", "Companion", "hexal-forge-1.19.2"})
public final class BlockEntityMediafiedStorage
extends HexBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockState state;
    @NotNull
    private final BlockPos pos;
    @NotNull
    private UUID uuid;
    @NotNull
    private AnimationState currentAnimation;
    private int currentItemIndex;
    private boolean hasRegisteredToMediafiedItemManager;
    @NotNull
    private final Map<Integer, ItemRecord> _storedItems;
    @NotNull
    public static final String TAG_UUID = "hexal:uuid";
    @NotNull
    public static final String TAG_INDEX = "hexal:index";
    @NotNull
    public static final String TAG_STORED = "hexal:stored";
    @NotNull
    public static final String TAG_ID = "hexal:storage_id";
    @NotNull
    public static final String TAG_HAS_ITEMS = "hexal:has_items";
    public static final int ANIMATION_LENGTH = 20;

    public BlockEntityMediafiedStorage(@NotNull BlockPos pos2, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(HexalBlockEntities.MEDIAFIED_STORAGE, pos2, state);
        this.state = state;
        BlockPos blockPos = pos2.m_7949_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos.immutable()");
        this.pos = blockPos;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        this.uuid = uUID;
        this.currentAnimation = new AnimationState.Closing(20);
        this._storedItems = new LinkedHashMap();
    }

    @NotNull
    public final BlockState getState() {
        return this.state;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final AnimationState getCurrentAnimation() {
        return this.currentAnimation;
    }

    public final void setCurrentAnimation(@NotNull AnimationState animationState) {
        Intrinsics.checkNotNullParameter((Object)animationState, (String)"<set-?>");
        this.currentAnimation = animationState;
    }

    @NotNull
    public final Map<Integer, ItemRecord> getStoredItems() {
        return this._storedItems;
    }

    public final void removeStoredItem(int index) {
        this._storedItems.remove(index);
        if (this._storedItems.isEmpty()) {
            this.sync();
        }
    }

    public final boolean contains(int index) {
        Integer n = index;
        return this.getStoredItems().containsKey(n);
    }

    public final boolean isFull() {
        return this.getStoredItems().size() >= HexalConfig.getServer().getMaxRecordsInMediafiedStorage();
    }

    @NotNull
    public final MediafiedItemManager.Index assignItem(@NotNull ItemRecord itemRecord) {
        Intrinsics.checkNotNullParameter((Object)itemRecord, (String)"itemRecord");
        int index = this.currentItemIndex++;
        boolean wasEmpty = this._storedItems.isEmpty();
        Integer n = index;
        this._storedItems.put(n, itemRecord);
        if (wasEmpty) {
            this.sync();
        }
        return new MediafiedItemManager.Index(this.uuid, index);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Item> getAllContainedItemTypes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getStoredItems().values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemRecord itemRecord = (ItemRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getItem());
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, ItemRecord> getItemRecordsMatching(@NotNull Item item) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Map<Integer, ItemRecord> $this$filter$iv = this.getStoredItems();
        boolean $i$f$filter = false;
        Map<Integer, ItemRecord> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            ItemRecord record = (ItemRecord)entry.getValue();
            if (!Intrinsics.areEqual((Object)record.getItem(), (Object)item)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, ItemRecord> getItemRecordsMatching(@NotNull ItemRecord itemRecord) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)itemRecord, (String)"itemRecord");
        Map<Integer, ItemRecord> $this$filter$iv = this.getStoredItems();
        boolean $i$f$filter = false;
        Map<Integer, ItemRecord> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            ItemRecord record = (ItemRecord)entry.getValue();
            if (!(Intrinsics.areEqual((Object)record.getItem(), (Object)itemRecord.getItem()) && Intrinsics.areEqual((Object)record.getTag(), (Object)itemRecord.getTag()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final void serverTick() {
        if (!this.hasRegisteredToMediafiedItemManager) {
            MediafiedItemManager.addStorage(this.uuid, this);
            this.hasRegisteredToMediafiedItemManager = true;
        }
        this.m_6596_();
    }

    public final void clientTick() {
        this.currentAnimation.setProgress(Math.min(this.currentAnimation.getProgress() + 1, 20));
    }

    public final void dropAllContents(@NotNull ServerLevel level, @NotNull BlockPos pos2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
        Iterator<Map.Entry<Integer, ItemRecord>> iterator = this.getStoredItems().entrySet().iterator();
        while (iterator.hasNext()) {
            List<ItemStack> toDrop;
            int record = ((Number)iterator.next().getKey()).intValue();
            if (MediafiedItemManager.getStacksToDrop(new MediafiedItemManager.Index(this.uuid, record), Long.MAX_VALUE) == null) continue;
            for (ItemStack stack : toDrop) {
                level.m_7967_((Entity)new ItemEntity((Level)level, (double)pos2.m_123341_(), (double)pos2.m_123342_(), (double)pos2.m_123343_(), stack));
            }
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag;
        CompoundTag it = compoundTag = new CompoundTag();
        boolean bl = false;
        it.m_128379_(TAG_HAS_ITEMS, !this._storedItems.isEmpty());
        return compoundTag;
    }

    protected void saveModData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128362_(TAG_UUID, this.uuid);
        tag.m_128405_(TAG_INDEX, this.currentItemIndex);
        ListTag stored = new ListTag();
        for (Map.Entry<Integer, ItemRecord> entry : this.getStoredItems().entrySet()) {
            int id = ((Number)entry.getKey()).intValue();
            ItemRecord record = entry.getValue();
            CompoundTag c = new CompoundTag();
            c.m_128405_(TAG_ID, id);
            record.writeToTag(c);
            stored.add((Object)c);
        }
        NBTHelper.putList((CompoundTag)tag, (String)TAG_STORED, (ListTag)stored);
        tag.m_128379_(TAG_HAS_ITEMS, !this._storedItems.isEmpty());
    }

    protected void loadModData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (tag.m_128441_(TAG_UUID)) {
            UUID uUID = tag.m_128342_(TAG_UUID);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"tag.getUUID(TAG_UUID)");
            this.uuid = uUID;
        }
        if (tag.m_128441_(TAG_INDEX)) {
            this.currentItemIndex = tag.m_128451_(TAG_INDEX);
        }
        this._storedItems.clear();
        if (tag.m_128441_(TAG_STORED)) {
            ListTag stored = NBTHelper.getListByByte((CompoundTag)tag, (String)TAG_STORED, (byte)10);
            for (Tag entry : stored) {
                Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                CompoundTag cEntry = (CompoundTag)entry;
                ItemRecord record = ItemRecord.Companion.readFromTag(cEntry);
                if (record == null) continue;
                this._storedItems.put(cEntry.m_128451_(TAG_ID), record);
            }
        }
        if (tag.m_128441_(TAG_HAS_ITEMS)) {
            if (tag.m_128471_(TAG_HAS_ITEMS)) {
                if (this.currentAnimation instanceof AnimationState.Closing) {
                    this.currentAnimation = new AnimationState.Opening(0);
                }
            } else if (this.currentAnimation instanceof AnimationState.Opening) {
                this.currentAnimation = new AnimationState.Closing(0);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$Companion;", "", "()V", "ANIMATION_LENGTH", "", "TAG_HAS_ITEMS", "", "TAG_ID", "TAG_INDEX", "TAG_STORED", "TAG_UUID", "hexal-forge-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState;", "", "progress", "", "(I)V", "getProgress", "()I", "setProgress", "Closing", "Opening", "Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState$Closing;", "Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState$Opening;", "hexal-forge-1.19.2"})
    public static abstract class AnimationState {
        private int progress;

        private AnimationState(int progress) {
            this.progress = progress;
        }

        public final int getProgress() {
            return this.progress;
        }

        public final void setProgress(int n) {
            this.progress = n;
        }

        public /* synthetic */ AnimationState(int progress, DefaultConstructorMarker $constructor_marker) {
            this(progress);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState$Closing;", "Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState;", "progress", "", "(I)V", "hexal-forge-1.19.2"})
        public static final class Closing
        extends AnimationState {
            public Closing(int progress) {
                super(progress, null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState$Opening;", "Lram/talia/hexal/common/blocks/entity/BlockEntityMediafiedStorage$AnimationState;", "progress", "", "(I)V", "hexal-forge-1.19.2"})
        public static final class Opening
        extends AnimationState {
            public Opening(int progress) {
                super(progress, null);
            }
        }
    }
}

