/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.config;

import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class HarvestWithEaseConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final CommonConfig COMMON = new CommonConfig(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    public static List<? extends String> getCrops() {
        return (List)HarvestWithEaseConfig.COMMON.crops.get();
    }

    public static Boolean getRequireHoe() {
        return (Boolean)HarvestWithEaseConfig.COMMON.requireHoe.get();
    }

    public static Integer getDamageOnHarvest() {
        return (Integer)HarvestWithEaseConfig.COMMON.damageOnHarvest.get();
    }

    public static Integer getGrantedExp() {
        return (Integer)HarvestWithEaseConfig.COMMON.grantedExp.get();
    }

    public static Boolean getPlaySound() {
        return (Boolean)HarvestWithEaseConfig.COMMON.playSound.get();
    }

    public static class CommonConfig {
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> crops;
        private final ForgeConfigSpec.ConfigValue<Boolean> requireHoe;
        private final ForgeConfigSpec.ConfigValue<Integer> damageOnHarvest;
        private final ForgeConfigSpec.ConfigValue<Integer> grantedExp;
        private final ForgeConfigSpec.ConfigValue<Boolean> playSound;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.crops = builder.comment("List of in-game IDs of additional crops").defineListAllowEmpty(List.of("crops"), Collections::emptyList, element -> element instanceof String && !((String)element).isBlank());
            this.requireHoe = builder.comment("Require holding a hoe (either hands) to right-click harvest").define("require hoe", false);
            this.damageOnHarvest = builder.comment("If [require hoe] is set to true, damage the hoe of the given amount (0 to disable, must be an integer)").define("damage on harvest", (Object)0);
            this.grantedExp = builder.comment("Amount of experience to grant on harvest (0 to disable, must be an integer).").define("exp on harvest", (Object)0);
            this.playSound = builder.comment("Play a sound when harvesting a crop.").define("play sound", true);
        }
    }
}

