/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigWithVariants;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class EnumConfig<E>
extends ConfigWithVariants<E> {
    public final NameMap<E> nameMap;

    public EnumConfig(NameMap<E> nm) {
        this.nameMap = nm;
        this.defaultValue = this.nameMap.defaultValue;
        this.value = this.nameMap.defaultValue;
    }

    @Override
    public Component getStringForGUI(E v) {
        return this.nameMap.getDisplayName(v);
    }

    @Override
    public Color4I getColor(E v) {
        Color4I col = this.nameMap.getColor(v);
        return col.isEmpty() ? Tristate.DEFAULT.color : col;
    }

    @Override
    public void addInfo(TooltipList list) {
        super.addInfo(list);
        if (this.nameMap.size() > 0) {
            list.blankLine();
            for (E v : this.nameMap) {
                boolean e = this.isEqual(v, this.value);
                MutableComponent c = Component.m_237113_((String)(e ? "+ " : "- "));
                c.m_130940_(e ? ChatFormatting.AQUA : ChatFormatting.DARK_GRAY);
                c.m_7220_(this.nameMap.getDisplayName(v));
                list.add((Component)c);
            }
        }
    }

    @Override
    public void onClicked(MouseButton button, final ConfigCallback callback) {
        if (this.nameMap.values.size() > 16 || BaseScreen.isCtrlKeyDown()) {
            ButtonListBaseScreen g = new ButtonListBaseScreen(){

                @Override
                public void addButtons(Panel panel) {
                    for (final Object v : EnumConfig.this.nameMap) {
                        panel.add(new SimpleTextButton(panel, EnumConfig.this.nameMap.getDisplayName(v), EnumConfig.this.nameMap.getIcon(v)){

                            @Override
                            public void onClicked(MouseButton button) {
                                this.playClickSound();
                                EnumConfig.this.setCurrentValue(v);
                                callback.save(true);
                            }
                        });
                    }
                }
            };
            g.setHasSearchBox(true);
            g.openGui();
            return;
        }
        super.onClicked(button, callback);
    }

    @Override
    public E getIteration(E v, boolean next) {
        return next ? this.nameMap.getNext(v) : this.nameMap.getPrevious(v);
    }

    @Override
    public Icon getIcon(@Nullable E v) {
        Icon icon;
        if (v != null && !(icon = this.nameMap.getIcon(v)).isEmpty()) {
            return icon;
        }
        return super.getIcon(v);
    }
}

