/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeItem;

public interface EnergyItemHandler
extends IForgeItem {
    public double getEnergyCapacity(ItemStack var1);

    default public double getEnergy(ItemStack stack) {
        return this.isCreativeEnergyItem() ? this.getEnergyCapacity(stack) / 2.0 : (stack.m_41782_() ? stack.m_41783_().m_128459_("Energy") : 0.0);
    }

    default public void setEnergy(ItemStack stack, double energy) {
        double prev = this.getEnergy(stack);
        if (prev != energy) {
            this.setEnergyRaw(stack, energy);
            this.energyChanged(stack, prev);
        }
    }

    default public void setEnergyRaw(ItemStack stack, double energy) {
        if (!this.isCreativeEnergyItem()) {
            stack.m_41700_("Energy", (Tag)DoubleTag.m_128500_((double)energy));
        }
    }

    default public double insertEnergy(ItemStack stack, double maxInsert, boolean simulate) {
        if (this.isCreativeEnergyItem()) {
            return maxInsert;
        }
        if (!this.canInsertEnergy()) {
            return 0.0;
        }
        double energy = this.getEnergy(stack);
        double energyReceived = Math.min(this.getEnergyCapacity(stack) - energy, maxInsert);
        if (!simulate && energyReceived > 0.0) {
            this.setEnergyRaw(stack, energy + energyReceived);
            this.energyChanged(stack, energy);
        }
        return energyReceived;
    }

    default public double extractEnergy(ItemStack stack, double maxExtract, boolean simulate) {
        if (this.isCreativeEnergyItem()) {
            return maxExtract;
        }
        if (!this.canExtractEnergy()) {
            return 0.0;
        }
        double energy = this.getEnergy(stack);
        double energyExtracted = Math.min(energy, maxExtract);
        if (!simulate && energyExtracted > 0.0) {
            this.setEnergyRaw(stack, energy - energyExtracted);
            this.energyChanged(stack, energy);
        }
        return energyExtracted;
    }

    default public boolean canInsertEnergy() {
        return true;
    }

    default public boolean canExtractEnergy() {
        return false;
    }

    default public boolean isCreativeEnergyItem() {
        return false;
    }

    default public void energyChanged(ItemStack stack, double prevEnergy) {
    }
}

