/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.screen.sync;

import dev.ftb.mods.ftbic.screen.sync.BooleanValue;
import dev.ftb.mods.ftbic.screen.sync.DoubleValue;
import dev.ftb.mods.ftbic.screen.sync.IntValue;
import dev.ftb.mods.ftbic.screen.sync.ShortValue;
import dev.ftb.mods.ftbic.screen.sync.SyncedDataKey;
import dev.ftb.mods.ftbic.screen.sync.SyncedDataValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import net.minecraft.world.inventory.ContainerData;

public class SyncedData
implements ContainerData {
    public static final SyncedDataKey<Double> ENERGY = new SyncedDataKey<Double>("energy", 0.0);
    public static final SyncedDataKey<Double> ENERGY_CAPACITY = new SyncedDataKey<Double>("energy_capacity", 1000.0);
    public static final SyncedDataKey<Integer> BAR = new SyncedDataKey<Integer>("bar", 0);
    public static final SyncedDataKey<Integer> ACCELERATION = new SyncedDataKey<Integer>("acceleration", 0);
    public static final SyncedDataKey<Boolean> PAUSED = new SyncedDataKey<Boolean>("paused", false);
    public static final SyncedDataKey<Boolean> ALLOW_REDSTONE_CONTROL = new SyncedDataKey<Boolean>("allow_redstone_control", false);
    private final Map<SyncedDataKey<?>, SyncedDataValue<?>> values = new LinkedHashMap();
    private int[] data = null;

    public <T> void add(SyncedDataKey<T> key, SyncedDataValue<T> value) {
        this.values.put(key, value);
    }

    public void remove(SyncedDataKey<?> key) {
        this.values.remove(key);
    }

    public void setup() {
        int i = 0;
        for (SyncedDataValue<?> value : this.values.values()) {
            value.index = i;
            i += value.getSize();
        }
        this.data = new int[i];
    }

    public void update() {
        for (SyncedDataValue<?> value : this.values.values()) {
            value.write(this.data);
        }
    }

    public void addShort(SyncedDataKey<Integer> key, IntSupplier value) {
        this.add(key, new ShortValue(value));
    }

    public void addInt(SyncedDataKey<Integer> key, IntSupplier value) {
        this.add(key, new IntValue(value));
    }

    public void addDouble(SyncedDataKey<Double> key, DoubleSupplier value) {
        this.add(key, new DoubleValue(value));
    }

    public void addBoolean(SyncedDataKey<Boolean> key, BooleanSupplier value) {
        this.add(key, new BooleanValue(value));
    }

    public <T> T get(SyncedDataKey<T> key) {
        SyncedDataValue<?> value = this.values.get(key);
        return (T)(value == null ? key.defaultValue : value.get(key, this.data));
    }

    public int m_6413_(int i) {
        return this.data[i];
    }

    public void m_8050_(int i, int v) {
        this.data[i] = v;
        for (SyncedDataValue<?> value : this.values.values()) {
            value.clearCache();
        }
    }

    public int m_6499_() {
        return this.data.length;
    }
}

