/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe.machines;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.recipe.SimpleMachineRecipeResults;
import dev.ftb.mods.ftbic.util.CraftingMaterial;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MaceratingRecipeResults
extends SimpleMachineRecipeResults {
    public MaceratingRecipeResults() {
        super((Supplier<MachineRecipeSerializer>)FTBICRecipes.MACERATING);
    }

    @Override
    protected void addAdditionalRecipes(Level level, List<MachineRecipe> list) {
        for (CraftingMaterial material : FTBICConfig.MATERIALS.values()) {
            MachineRecipe recipe;
            ResourceLocation id;
            Item dust = FTBICConfig.getItemFromTag(material.dust.getTag());
            boolean gemFromOre = false;
            if (((Boolean)FTBICConfig.RECIPES.ADD_GEM_FROM_ORE_RECIPES.get()).booleanValue() && !material.gem.getValues().isEmpty() && !material.ore.getValues().isEmpty()) {
                ResourceLocation id2;
                Item gem = FTBICConfig.getItemFromTag(material.gem.getTag());
                ResourceLocation resourceLocation = id2 = gem == Items.f_41852_ ? null : Registry.f_122827_.m_7981_((Object)gem);
                if (id2 != null && !gem.m_204114_().m_203656_(FTBICUtils.NO_AUTO_RECIPE)) {
                    MachineRecipe recipe2 = new MachineRecipe((MachineRecipeSerializer)this.recipeSerializer.get(), new ResourceLocation("ftbic", "macerating/generated/gem_from_ore/" + id2.m_135827_() + "/" + id2.m_135815_()));
                    recipe2.inputItems.add(new IngredientWithCount(Ingredient.m_204132_(material.ore.getTag()), 1));
                    recipe2.outputItems.add(new StackWithChance(new ItemStack((ItemLike)gem, 2), 1.0));
                    list.add(recipe2);
                    gemFromOre = true;
                }
            }
            if (!gemFromOre && ((Boolean)FTBICConfig.RECIPES.ADD_DUST_FROM_ORE_RECIPES.get()).booleanValue() && dust != Items.f_41852_ && !material.ore.getValues().isEmpty() && (id = Registry.f_122827_.m_7981_((Object)dust)) != null && !dust.m_204114_().m_203656_(FTBICUtils.NO_AUTO_RECIPE)) {
                recipe = new MachineRecipe((MachineRecipeSerializer)this.recipeSerializer.get(), new ResourceLocation("ftbic", "macerating/generated/dust_from_ore/" + id.m_135827_() + "/" + id.m_135815_()));
                recipe.inputItems.add(new IngredientWithCount(Ingredient.m_204132_(material.ore.getTag()), 1));
                recipe.outputItems.add(new StackWithChance(new ItemStack((ItemLike)dust, 2), 1.0));
                list.add(recipe);
            }
            if (!((Boolean)FTBICConfig.RECIPES.ADD_DUST_FROM_MATERIAL_RECIPES.get()).booleanValue() || dust == Items.f_41852_ || (id = Registry.f_122827_.m_7981_((Object)dust)) == null || dust.m_204114_().m_203656_(FTBICUtils.NO_AUTO_RECIPE)) continue;
            if (!material.ingot.getValues().isEmpty()) {
                recipe = new MachineRecipe((MachineRecipeSerializer)this.recipeSerializer.get(), new ResourceLocation("ftbic", "macerating/generated/dust_from_metal/" + id.m_135827_() + "/" + id.m_135815_()));
                recipe.inputItems.add(new IngredientWithCount(Ingredient.m_204132_(material.ingot.getTag()), 1));
                recipe.outputItems.add(new StackWithChance(new ItemStack((ItemLike)dust, 1), 1.0));
                list.add(recipe);
            }
            if (material.gem.getValues().isEmpty()) continue;
            recipe = new MachineRecipe((MachineRecipeSerializer)this.recipeSerializer.get(), new ResourceLocation("ftbic", "macerating/generated/dust_from_gem/" + id.m_135827_() + "/" + id.m_135815_()));
            recipe.inputItems.add(new IngredientWithCount(Ingredient.m_204132_(material.gem.getTag()), 1));
            recipe.outputItems.add(new StackWithChance(new ItemStack((ItemLike)dust, 1), 1.0));
            list.add(recipe);
        }
    }
}

