/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item.reactor;

import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.BaseReactorItem;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HeatVentItem
extends BaseReactorItem {
    public final int selfCooling;
    public final int reactorCooling;
    public final int componentCooling;

    public HeatVentItem(int durability, int s, int h, int c) {
        super(durability);
        this.selfCooling = s;
        this.reactorCooling = h;
        this.componentCooling = c;
    }

    @Override
    public boolean isHeatAcceptor(ItemStack stack) {
        return stack.m_41776_() > 0;
    }

    @Override
    public void reactorInfo(ItemStack stack, List<Component> list, boolean shift, boolean advanced, @Nullable NuclearReactor reactor, int x, int y) {
        if (stack.m_41776_() > 0) {
            list.add((Component)Component.m_237113_((String)"Coolant: ").m_7220_(FTBICUtils.formatHeat(stack.m_41776_() - stack.m_41773_())).m_130940_(ChatFormatting.GRAY));
        }
        list.add((Component)Component.m_237113_((String)"Self Cooling: ").m_7220_(FTBICUtils.formatHeat(this.selfCooling)).m_130946_("/s").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"Reactor Cooling: ").m_7220_(FTBICUtils.formatHeat(this.reactorCooling)).m_130946_("/s").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"Component Cooling: ").m_7220_(FTBICUtils.formatHeat(this.componentCooling)).m_130946_("/s").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public void reactorTickPre(NuclearReactor reactor, ItemStack stack, int x, int y) {
        if (this.reactorCooling > 0) {
            reactor.addHeat(-this.reactorCooling);
        }
        if (this.selfCooling > 0) {
            this.damageReactorItem(stack, -this.selfCooling);
        }
        if (this.componentCooling > 0) {
            for (int i = 0; i < 4; ++i) {
                ItemStack is = reactor.getAt(x + NuclearReactorBlockEntity.OFFSET_X[i], y + NuclearReactorBlockEntity.OFFSET_Y[i]);
                if (!(is.m_41720_() instanceof ReactorItem) || !((ReactorItem)is.m_41720_()).isCoolant(is)) continue;
                ((ReactorItem)is.m_41720_()).damageReactorItem(is, -this.componentCooling);
            }
        }
    }
}

