/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.item.FluidCellItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidCellHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    @Nonnull
    protected ItemStack container;

    public FluidCellHandler(@Nonnull ItemStack c) {
        this.container = c;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.holder);
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int getTankCapacity(int tank) {
        return (Integer)FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get();
    }

    private Fluid getFluid() {
        return FluidCellItem.getFluid(this.container);
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid() == Fluids.f_76191_ ? FluidStack.EMPTY : new FluidStack(this.getFluid(), ((Integer)FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get()).intValue());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getFluid() != Fluids.f_76191_ || resource.getAmount() < (Integer)FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get()) {
            return 0;
        }
        if (action.execute()) {
            FluidCellItem.setFluid(this.container, resource.getFluid());
        }
        return (Integer)FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get();
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || resource.getAmount() < (Integer)FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get()) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.f_76191_ || fluid != resource.getFluid()) {
            return FluidStack.EMPTY;
        }
        FluidStack output = new FluidStack(fluid, ((Integer)FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get()).intValue());
        if (action.execute()) {
            FluidCellItem.setFluid(this.container, Fluids.f_76191_);
        }
        return output;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain < (Integer)FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get()) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.f_76191_) {
            return FluidStack.EMPTY;
        }
        FluidStack output = new FluidStack(fluid, ((Integer)FTBICConfig.NUCLEAR.FLUID_CELL_CAPACITY.get()).intValue());
        if (action.execute()) {
            FluidCellItem.setFluid(this.container, Fluids.f_76191_);
        }
        return output;
    }
}

