/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.storage;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.entity.generator.GeneratorBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.BatteryInventory;
import dev.ftb.mods.ftbic.screen.BatteryBoxMenu;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatteryBoxBlockEntity
extends GeneratorBlockEntity {
    public final BatteryInventory dischargeBatteryInventory = new BatteryInventory(this, false);
    private LazyOptional<IItemHandler> dischargeBatteryInventoryOptional;
    private LazyOptional<IItemHandler> chargeBatteryInventoryOptional;

    public BatteryBoxBlockEntity(ElectricBlockInstance type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.maxEnergyOutputTransfer = this.maxEnergyOutput;
    }

    @Override
    public void writeData(CompoundTag tag) {
        super.writeData(tag);
        if (!this.dischargeBatteryInventory.getStackInSlot(0).m_41619_()) {
            tag.m_128365_("DischargeBattery", (Tag)this.dischargeBatteryInventory.getStackInSlot(0).serializeNBT());
        }
    }

    @Override
    public void readData(CompoundTag tag) {
        super.readData(tag);
        if (tag.m_128441_("DischargeBattery")) {
            this.dischargeBatteryInventory.loadItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("DischargeBattery")));
        } else {
            this.dischargeBatteryInventory.loadItem(ItemStack.f_41583_);
        }
    }

    @Override
    public void onBroken(Level level, BlockPos pos) {
        super.onBroken(level, pos);
        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.dischargeBatteryInventory.getStackInSlot(0));
    }

    @Override
    public boolean isValidEnergyOutputSide(Direction direction) {
        return direction == this.getFacing(Direction.NORTH);
    }

    @Override
    public boolean isValidEnergyInputSide(Direction direction) {
        return direction != this.getFacing(Direction.NORTH);
    }

    @Override
    public void handleGeneration() {
        double transfer;
        EnergyItemHandler item;
        double e;
        Item item2;
        ItemStack battery;
        if (!this.isBurnt() && !this.f_58857_.m_5776_() && this.energy < this.energyCapacity && !(battery = this.dischargeBatteryInventory.getStackInSlot(0)).m_41619_() && (item2 = battery.m_41720_()) instanceof EnergyItemHandler && (e = item.extractEnergy(battery, Math.min(this.energyCapacity - this.energy, transfer = (item = (EnergyItemHandler)item2).isCreativeEnergyItem() ? Double.POSITIVE_INFINITY : this.maxInputEnergy * (Double)FTBICConfig.MACHINES.ITEM_TRANSFER_EFFICIENCY.get()), false)) > 0.0) {
            this.energy += e;
            if (battery.m_41619_()) {
                this.dischargeBatteryInventory.setStackInSlot(0, ItemStack.f_41583_);
            }
            this.m_6596_();
        }
    }

    @Override
    public InteractionResult rightClick(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.f_58857_.m_5776_()) {
            this.openMenu((ServerPlayer)player, (id, inventory) -> new BatteryBoxMenu(id, inventory, this));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public int getSlots() {
        return 2;
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return switch (slot) {
            case 0 -> this.chargeBatteryInventory.getStackInSlot(0);
            case 1 -> this.dischargeBatteryInventory.getStackInSlot(0);
            default -> throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        };
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        ItemStack prev;
        switch (slot) {
            case 0: {
                prev = this.chargeBatteryInventory.getStackInSlot(0);
                this.chargeBatteryInventory.setStackInSlot(0, stack);
                break;
            }
            case 1: {
                prev = this.dischargeBatteryInventory.getStackInSlot(0);
                this.dischargeBatteryInventory.setStackInSlot(0, stack);
                break;
            }
            default: {
                throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
            }
        }
        this.inventoryChanged(slot, prev);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (slot >= this.getSlots() || stack.m_41619_() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int limit = Math.min(this.getSlotLimit(slot), stack.m_41741_());
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                ItemStack prev = this.getStackInSlot(slot);
                switch (slot) {
                    case 0: {
                        this.chargeBatteryInventory.setStackInSlot(0, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
                        break;
                    }
                    case 1: {
                        this.dischargeBatteryInventory.setStackInSlot(0, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
                    }
                }
                this.inventoryChanged(slot, prev);
            } else {
                ItemStack prev = existing.m_41777_();
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
                this.inventoryChanged(slot, prev);
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 0 || slot > 1) {
            return ItemStack.f_41583_;
        }
        BatteryInventory batteryInv = slot == 0 ? this.chargeBatteryInventory : this.dischargeBatteryInventory;
        ItemStack existing = batteryInv.getStackInSlot(0);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                batteryInv.setStackInSlot(0, ItemStack.f_41583_);
                this.inventoryChanged(slot, existing);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            batteryInv.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.inventoryChanged(slot, existing);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return slot == 0 && this.chargeBatteryInventory.isItemValid(0, stack) || slot == 1 && this.dischargeBatteryInventory.isItemValid(0, stack);
    }

    public LazyOptional<?> getDischargeBatteryInventoryOptional() {
        if (this.dischargeBatteryInventoryOptional == null) {
            this.dischargeBatteryInventoryOptional = LazyOptional.of(() -> this.dischargeBatteryInventory);
        }
        return this.dischargeBatteryInventoryOptional;
    }

    public LazyOptional<?> getChargeBatteryInventoryOptional() {
        if (this.chargeBatteryInventoryOptional == null) {
            this.chargeBatteryInventoryOptional = LazyOptional.of(() -> this.chargeBatteryInventory);
        }
        return this.chargeBatteryInventoryOptional;
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.dischargeBatteryInventoryOptional != null) {
            this.dischargeBatteryInventoryOptional.invalidate();
            this.dischargeBatteryInventoryOptional = null;
        }
        if (this.chargeBatteryInventoryOptional != null) {
            this.chargeBatteryInventoryOptional.invalidate();
            this.chargeBatteryInventoryOptional = null;
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.UP) {
                return this.getDischargeBatteryInventoryOptional().cast();
            }
            return this.getChargeBatteryInventoryOptional().cast();
        }
        return super.getCapability(cap, side);
    }
}

