/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.Auxiliaries;
import wile.engineersdecor.libmc.Guis;
import wile.engineersdecor.libmc.Inventories;
import wile.engineersdecor.libmc.Networking;
import wile.engineersdecor.libmc.RsSignals;
import wile.engineersdecor.libmc.StandardBlocks;
import wile.engineersdecor.libmc.StandardEntityBlocks;
import wile.engineersdecor.libmc.TooltipDisplay;

public class EdDropper {
    private static boolean with_adjacent_item_insertion = false;

    public static void on_config(boolean with_item_insertion) {
        with_adjacent_item_insertion = with_item_insertion;
        ModConfig.log("Config dropper: item-insertion:" + with_adjacent_item_insertion + ".");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DropperGui
    extends Guis.ContainerGui<DropperUiContainer> {
        public DropperGui(DropperUiContainer container, Inventory player_inventory, Component title) {
            super(container, player_inventory, title, "textures/gui/factory_dropper_gui.png");
        }

        @Override
        public void m_7856_() {
            super.m_7856_();
            Block block = ModContent.getBlock(Auxiliaries.getResourceLocation(((DropperUiContainer)this.m_6262_()).m_6772_()).m_135815_().replaceAll("^ct_", ""));
            String prefix = block.m_7705_() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 130, y0 + 10, 12, 25, (Component)Component.m_237115_((String)(prefix + "velocity"))), new TooltipDisplay.TipRange(x0 + 145, y0 + 10, 25, 25, (Component)Component.m_237115_((String)(prefix + "direction"))), new TooltipDisplay.TipRange(x0 + 129, y0 + 40, 44, 10, (Component)Component.m_237115_((String)(prefix + "dropcount"))), new TooltipDisplay.TipRange(x0 + 129, y0 + 50, 44, 10, (Component)Component.m_237115_((String)(prefix + "period"))), new TooltipDisplay.TipRange(x0 + 114, y0 + 51, 9, 9, (Component)Component.m_237115_((String)(prefix + "rssignal"))), new TooltipDisplay.TipRange(x0 + 162, y0 + 66, 7, 9, (Component)Component.m_237115_((String)(prefix + "triggermode"))), new TooltipDisplay.TipRange(x0 + 132, y0 + 66, 9, 9, (Component)Component.m_237115_((String)(prefix + "filtergate"))), new TooltipDisplay.TipRange(x0 + 148, y0 + 66, 9, 9, (Component)Component.m_237115_((String)(prefix + "externgate"))));
        }

        @Override
        protected void renderBgWidgets(PoseStack mx, float partialTicks, int mouseX, int mouseY) {
            int logic;
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            DropperUiContainer container = (DropperUiContainer)this.m_6262_();
            int drop_slot_index = container.field(15);
            if (drop_slot_index < 0 || drop_slot_index >= 16) {
                drop_slot_index = 0;
            }
            int x = x0 + 9 + drop_slot_index % 6 * 18;
            int y = y0 + 5 + drop_slot_index / 6 * 17;
            this.m_93228_(mx, x, y, 180, 45, 18, 18);
            for (int i = 0; i < 3; ++i) {
                int xt = 180 + 6 * container.field(12 + i);
                int yt = 38;
                int x2 = x0 + 31 + i * 36;
                int y2 = y0 + 65;
                this.m_93228_(mx, x2, y2, xt, yt, 6, 6);
            }
            int hy = 2 + (100 - container.field(0)) * 21 / 100;
            x = x0 + 135;
            y = y0 + 12;
            int xt = 181;
            int yt = 4 + (23 - hy);
            this.m_93228_(mx, x, y, xt, yt, 3, hy);
            int x3 = x0 + 157 - 3 + container.field(1) * 12 / 100;
            int y3 = y0 + 22 - 3 - container.field(2) * 12 / 100;
            this.m_93228_(mx, x3, y3, 180, 30, 7, 7);
            x3 = x0 + 134 - 2 + container.field(4);
            y3 = y0 + 45;
            this.m_93228_(mx, x3, y3, 190, 31, 5, 5);
            int px = (int)Math.round(33.0 * (double)container.field(6) / 100.0 + 1.0);
            x = x0 + 134 - 2 + Mth.m_14045_((int)px, (int)0, (int)33);
            y = y0 + 56;
            this.m_93228_(mx, x, y, 190, 31, 5, 5);
            if (container.field(11) != 0) {
                this.m_93228_(mx, x0 + 114, y0 + 51, 189, 18, 9, 9);
            }
            int filter_gate_offset = ((logic = container.field(5)) & 1) != 0 ? 11 : 0;
            int pulse_mode_offset = (logic & 0x10) != 0 ? 10 : 0;
            int extern_gate_offset_x = (logic & 2) != 0 ? 11 : 0;
            int extern_gate_offset_y = (logic & 0x20) != 0 ? 10 : 0;
            this.m_93228_(mx, x0 + 132, y0 + 66, 179 + filter_gate_offset, 66, 9, 9);
            this.m_93228_(mx, x0 + 148, y0 + 66, 179 + extern_gate_offset_x, 66 + extern_gate_offset_y, 9, 9);
            this.m_93228_(mx, x0 + 162, y0 + 66, 200 + pulse_mode_offset, 66, 9, 9);
            if (container.field(9) > 10 && System.currentTimeMillis() % 1000L < 500L) {
                this.m_93228_(mx, x0 + 149, y0 + 51, 201, 39, 3, 3);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            DropperUiContainer container = (DropperUiContainer)this.m_6262_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.m_6774_(114, 1, 61, 79, mouseX, mouseY)) {
                return super.m_6375_(mouseX, mouseY, mouseButton);
            }
            if (this.m_6774_(130, 10, 12, 25, mouseX, mouseY)) {
                int force_percent = 100 - Mth.m_14045_((int)((my - 10) * 100 / 25), (int)0, (int)100);
                container.onGuiAction("drop_speed", force_percent);
            } else if (this.m_6774_(145, 10, 25, 25, mouseX, mouseY)) {
                int xdev = Mth.m_14045_((int)((int)Math.round((double)((mx - 157) * 100) / 12.0)), (int)-100, (int)100);
                int ydev = Mth.m_14045_((int)(-((int)Math.round((double)((my - 22) * 100) / 12.0))), (int)-100, (int)100);
                if (Math.abs(xdev) < 9) {
                    xdev = 0;
                }
                if (Math.abs(ydev) < 9) {
                    ydev = 0;
                }
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("drop_xdev", xdev);
                nbt.m_128405_("drop_ydev", ydev);
                container.onGuiAction(nbt);
            } else if (this.m_6774_(129, 40, 44, 10, mouseX, mouseY)) {
                int ndrop = mx - 135;
                ndrop = ndrop < -1 ? container.field(4) - 1 : (ndrop >= 34 ? container.field(4) + 1 : Mth.m_14045_((int)(1 + ndrop), (int)1, (int)32));
                container.onGuiAction("drop_count", ndrop);
            } else if (this.m_6774_(129, 50, 44, 10, mouseX, mouseY)) {
                int period = mx - 135;
                period = period < -1 ? container.field(6) - 3 : (period >= 34 ? container.field(6) + 3 : (int)(0.5 + 100.0 * (double)period / 34.0));
                period = Mth.m_14045_((int)period, (int)0, (int)100);
                container.onGuiAction("drop_period", period);
            } else if (this.m_6774_(114, 51, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("manual_rstrigger", 1);
            } else if (this.m_6774_(162, 66, 7, 9, mouseX, mouseY)) {
                container.onGuiAction("drop_logic", container.field(5) ^ 0x10);
            } else if (this.m_6774_(132, 66, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("drop_logic", container.field(5) ^ 1);
            } else if (this.m_6774_(148, 66, 9, 9, mouseX, mouseY)) {
                int mask = 34;
                int logic = switch (container.field(5) & 0x22) {
                    case 2 -> 0;
                    case 0 -> 32;
                    case 32 -> 2;
                    default -> 2;
                };
                container.onGuiAction("drop_logic", container.field(5) & 0xFFFFFFDD | logic);
            }
            return true;
        }

        protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
            this.tooltip_.resetTimer();
            if (type == ClickType.QUICK_MOVE && slot != null && slot.m_6657_() && Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("slot", slotId);
                ((DropperUiContainer)this.f_97732_).onGuiAction("quick-move-all", nbt);
            } else {
                super.m_6597_(slot, slotId, button, type);
            }
        }
    }

    public static class DropperUiContainer
    extends AbstractContainerMenu
    implements Networking.INetworkSynchronisableContainer {
        protected static final String QUICK_MOVE_ALL = "quick-move-all";
        private static final int PLAYER_INV_START_SLOTNO = 15;
        private final Player player_;
        private final Container inventory_;
        private final ContainerLevelAccess wpc_;
        private final ContainerData fields_;
        private final Inventories.InventoryRange player_inventory_range_;
        private final Inventories.InventoryRange block_storage_range_;

        public final int field(int index) {
            return this.fields_.m_6413_(index);
        }

        public DropperUiContainer(int cid, Inventory player_inventory) {
            this(cid, player_inventory, (Container)new SimpleContainer(15), ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(16));
        }

        private DropperUiContainer(int cid, Inventory player_inventory, Container block_inventory, ContainerLevelAccess wpc, ContainerData fields) {
            super(ModContent.getMenuType("factory_dropper"), cid);
            int x;
            int y;
            this.fields_ = fields;
            this.wpc_ = wpc;
            this.player_ = player_inventory.f_35978_;
            this.inventory_ = block_inventory;
            this.block_storage_range_ = new Inventories.InventoryRange(this.inventory_, 0, 15);
            this.player_inventory_range_ = Inventories.InventoryRange.fromPlayerInventory(this.player_);
            int i = -1;
            for (y = 0; y < 2; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 10 + x * 18;
                    int ypos = 6 + y * 17;
                    this.m_38897_(new Slot(this.inventory_, ++i, xpos, ypos));
                }
            }
            this.m_38897_(new Slot(this.inventory_, ++i, 19, 48));
            this.m_38897_(new Slot(this.inventory_, ++i, 55, 48));
            this.m_38897_(new Slot(this.inventory_, ++i, 91, 48));
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)player_inventory, x2, 8 + x2 * 18, 144));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            this.m_38884_(this.fields_);
        }

        public boolean m_6875_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public ItemStack m_7648_(Player player, int index) {
            Slot slot = this.m_38853_(index);
            if (slot == null || !slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slot_stack = slot.m_7993_();
            ItemStack transferred = slot_stack.m_41777_();
            if (index >= 0 && index < 15) {
                if (!this.m_38903_(slot_stack, 15, 51, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 15 && index <= 51) {
                if (!this.m_38903_(slot_stack, 0, 12, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slot_stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slot_stack.m_41613_() == transferred.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundTag nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundTag nbt) {
            nbt.m_128359_("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundTag nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, Player player, CompoundTag nbt) {
            if (!(this.inventory_ instanceof Inventories.StorageInventory)) {
                return;
            }
            BlockEntity blockEntity = ((Inventories.StorageInventory)this.inventory_).getBlockEntity();
            if (!(blockEntity instanceof DropperTileEntity)) {
                return;
            }
            DropperTileEntity te = (DropperTileEntity)blockEntity;
            if (nbt.m_128441_("action")) {
                boolean changed = false;
                int slotId = nbt.m_128441_("slot") ? nbt.m_128451_("slot") : -1;
                switch (nbt.m_128461_("action")) {
                    case "quick-move-all": {
                        if (slotId >= 0 && slotId < 15 && this.m_38853_(slotId).m_6657_()) {
                            changed = this.block_storage_range_.move(this.m_38853_(slotId).getSlotIndex(), this.player_inventory_range_, true, false, true, true);
                            break;
                        }
                        if (slotId < 15 || slotId >= 51 || !this.m_38853_(slotId).m_6657_()) break;
                        changed = this.player_inventory_range_.move(this.m_38853_(slotId).getSlotIndex(), this.block_storage_range_, true, false, false, true);
                    }
                }
                if (changed) {
                    this.inventory_.m_6596_();
                    player.m_150109_().m_6596_();
                    this.m_38946_();
                }
            } else {
                if (nbt.m_128441_("drop_speed")) {
                    te.drop_speed_ = Mth.m_14045_((int)nbt.m_128451_("drop_speed"), (int)0, (int)100);
                }
                if (nbt.m_128441_("drop_xdev")) {
                    te.drop_xdev_ = Mth.m_14045_((int)nbt.m_128451_("drop_xdev"), (int)-100, (int)100);
                }
                if (nbt.m_128441_("drop_ydev")) {
                    te.drop_ydev_ = Mth.m_14045_((int)nbt.m_128451_("drop_ydev"), (int)-100, (int)100);
                }
                if (nbt.m_128441_("drop_count")) {
                    te.drop_count_ = Mth.m_14045_((int)nbt.m_128451_("drop_count"), (int)1, (int)32);
                }
                if (nbt.m_128441_("drop_period")) {
                    te.drop_period_ = Mth.m_14045_((int)nbt.m_128451_("drop_period"), (int)0, (int)100);
                }
                if (nbt.m_128441_("drop_logic")) {
                    te.drop_logic_ = nbt.m_128451_("drop_logic");
                }
                if (nbt.m_128441_("manual_rstrigger") && nbt.m_128451_("manual_rstrigger") != 0) {
                    te.block_power_signal_ = true;
                    te.block_power_updated_ = true;
                    te.tick_timer_ = 1;
                }
                if (nbt.m_128441_("manual_trigger") && nbt.m_128451_("manual_trigger") != 0) {
                    te.tick_timer_ = 1;
                    te.triggered_ = true;
                }
                te.m_6596_();
            }
        }
    }

    public static class DropperTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable {
        public static final int NUM_OF_FIELDS = 16;
        public static final int TICK_INTERVAL = 32;
        public static final int NUM_OF_SLOTS = 15;
        public static final int INPUT_SLOTS_FIRST = 0;
        public static final int INPUT_SLOTS_SIZE = 12;
        public static final int CTRL_SLOTS_FIRST = 12;
        public static final int CTRL_SLOTS_SIZE = 3;
        public static final int SHUTTER_CLOSE_DELAY = 40;
        public static final int MAX_DROP_COUNT = 32;
        public static final int DROP_PERIOD_OFFSET = 10;
        public static final int DROPLOGIC_FILTER_ANDGATE = 1;
        public static final int DROPLOGIC_EXTERN_ANDGATE = 2;
        public static final int DROPLOGIC_SILENT_DROP = 4;
        public static final int DROPLOGIC_SILENT_OPEN = 8;
        public static final int DROPLOGIC_CONTINUOUS = 16;
        public static final int DROPLOGIC_IGNORE_EXT = 32;
        private final int[] filter_matches_ = new int[3];
        private int open_timer_ = 0;
        private int drop_timer_ = 0;
        private boolean triggered_ = false;
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int drop_speed_ = 10;
        private int drop_noise_ = 0;
        private int drop_xdev_ = 0;
        private int drop_ydev_ = 0;
        private int drop_count_ = 1;
        private int drop_logic_ = 2;
        private int drop_period_ = 0;
        private int drop_slot_index_ = 0;
        private int tick_timer_ = 0;
        protected final Inventories.StorageInventory main_inventory_ = new Inventories.StorageInventory(this, 15, 1);
        protected final Inventories.InventoryRange storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 0, 12);
        protected final Inventories.InventoryRange filter_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 12, 3);
        protected LazyOptional<? extends IItemHandler> item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.storage_slot_range_);
        protected final ContainerData fields = new ContainerData(){

            public int m_6499_() {
                return 16;
            }

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> drop_speed_;
                    case 1 -> drop_xdev_;
                    case 2 -> drop_ydev_;
                    case 3 -> drop_noise_;
                    case 4 -> drop_count_;
                    case 5 -> drop_logic_;
                    case 6 -> drop_period_;
                    case 9 -> drop_timer_;
                    case 10 -> open_timer_;
                    case 11 -> {
                        if (block_power_signal_) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 12 -> filter_matches_[0];
                    case 13 -> filter_matches_[1];
                    case 14 -> filter_matches_[2];
                    case 15 -> drop_slot_index_;
                    default -> 0;
                };
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    case 0: {
                        drop_speed_ = Mth.m_14045_((int)value, (int)0, (int)100);
                        break;
                    }
                    case 1: {
                        drop_xdev_ = Mth.m_14045_((int)value, (int)-100, (int)100);
                        break;
                    }
                    case 2: {
                        drop_ydev_ = Mth.m_14045_((int)value, (int)-100, (int)100);
                        break;
                    }
                    case 3: {
                        drop_noise_ = Mth.m_14045_((int)value, (int)0, (int)100);
                        break;
                    }
                    case 4: {
                        drop_count_ = Mth.m_14045_((int)value, (int)1, (int)32);
                        break;
                    }
                    case 5: {
                        drop_logic_ = value;
                        break;
                    }
                    case 6: {
                        drop_period_ = Mth.m_14045_((int)value, (int)0, (int)100);
                        break;
                    }
                    case 9: {
                        drop_timer_ = Mth.m_14045_((int)value, (int)0, (int)400);
                        break;
                    }
                    case 10: {
                        open_timer_ = Mth.m_14045_((int)value, (int)0, (int)400);
                        break;
                    }
                    case 11: {
                        block_power_signal_ = value != 0;
                        break;
                    }
                    case 12: {
                        filter_matches_[0] = value & 3;
                        break;
                    }
                    case 13: {
                        filter_matches_[1] = value & 3;
                        break;
                    }
                    case 14: {
                        filter_matches_[2] = value & 3;
                        break;
                    }
                    case 15: {
                        drop_slot_index_ = Mth.m_14045_((int)value, (int)0, (int)11);
                    }
                }
            }
        };

        public DropperTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
            this.reset_rtstate();
        }

        public CompoundTag clear_getnbt() {
            CompoundTag nbt = new CompoundTag();
            this.writenbt(nbt, false);
            this.main_inventory_.m_6211_();
            this.reset_rtstate();
            this.triggered_ = false;
            this.block_power_updated_ = false;
            return nbt;
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
            Arrays.fill(this.filter_matches_, 0);
        }

        public void readnbt(CompoundTag nbt, boolean update_packet) {
            this.main_inventory_.load(nbt);
            this.block_power_signal_ = nbt.m_128471_("powered");
            this.open_timer_ = nbt.m_128451_("open_timer");
            this.drop_speed_ = nbt.m_128451_("drop_speed");
            this.drop_noise_ = nbt.m_128451_("drop_noise");
            this.drop_xdev_ = nbt.m_128451_("drop_xdev");
            this.drop_ydev_ = nbt.m_128451_("drop_ydev");
            this.drop_slot_index_ = nbt.m_128451_("drop_slot_index");
            this.drop_count_ = Mth.m_14045_((int)nbt.m_128451_("drop_count"), (int)1, (int)32);
            this.drop_logic_ = nbt.m_128451_("drop_logic");
            this.drop_period_ = nbt.m_128451_("drop_period");
        }

        protected void writenbt(CompoundTag nbt, boolean update_packet) {
            this.main_inventory_.save(nbt);
            nbt.m_128379_("powered", this.block_power_signal_);
            nbt.m_128405_("open_timer", this.open_timer_);
            nbt.m_128405_("drop_speed", this.drop_speed_);
            nbt.m_128405_("drop_noise", this.drop_noise_);
            nbt.m_128405_("drop_xdev", this.drop_xdev_);
            nbt.m_128405_("drop_ydev", this.drop_ydev_);
            nbt.m_128405_("drop_slot_index", this.drop_slot_index_);
            nbt.m_128405_("drop_count", this.drop_count_);
            nbt.m_128405_("drop_logic", this.drop_logic_);
            nbt.m_128405_("drop_period", this.drop_period_);
        }

        public void block_updated() {
            boolean powered = this.f_58857_.m_46753_(this.f_58858_);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            this.tick_timer_ = 1;
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt, false);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt, false);
        }

        public void m_7651_() {
            super.m_7651_();
            this.item_handler_.invalidate();
        }

        public Component m_7755_() {
            return Auxiliaries.localizable(this.m_58900_().m_60734_().m_7705_());
        }

        public boolean m_8077_() {
            return false;
        }

        public Component m_7770_() {
            return this.m_7755_();
        }

        public Component m_5446_() {
            return super.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new DropperUiContainer(id, inventory, this.main_inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this.fields);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                return this.item_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private static void drop(Level world, BlockPos pos, Direction facing, ItemStack stack, int speed_percent, int xdeviation, int ydeviation, int noise_percent) {
            double ofs = facing == Direction.DOWN ? 0.8 : 0.7;
            Vec3 v0 = new Vec3((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_());
            ItemEntity ei = new ItemEntity(world, (double)pos.m_123341_() + 0.5 + ofs * v0.f_82479_, (double)pos.m_123342_() + 0.5 + ofs * v0.f_82480_, (double)pos.m_123343_() + 0.5 + ofs * v0.f_82481_, stack);
            if (xdeviation != 0 || ydeviation != 0) {
                double vdx = 0.01 * (double)Mth.m_14045_((int)xdeviation, (int)-100, (int)100);
                double vdy = 0.01 * (double)Mth.m_14045_((int)ydeviation, (int)-100, (int)100);
                switch (facing) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOWN: {
                        Vec3 vec3 = v0.m_82520_(vdx, 0.0, -vdy);
                        break;
                    }
                    case NORTH: {
                        Vec3 vec3 = v0.m_82520_(vdx, vdy, 0.0);
                        break;
                    }
                    case SOUTH: {
                        Vec3 vec3 = v0.m_82520_(-vdx, vdy, 0.0);
                        break;
                    }
                    case EAST: {
                        Vec3 vec3 = v0.m_82520_(0.0, vdy, vdx);
                        break;
                    }
                    case WEST: {
                        Vec3 vec3 = v0.m_82520_(0.0, vdy, -vdx);
                        break;
                    }
                    case UP: {
                        Vec3 vec3 = v0 = v0.m_82520_(vdx, 0.0, vdy);
                    }
                }
            }
            if (noise_percent > 0) {
                v0 = v0.m_82520_((world.f_46441_.m_188500_() - 0.5) * 0.001 * (double)noise_percent, (world.f_46441_.m_188500_() - 0.5) * 0.001 * (double)noise_percent, (world.f_46441_.m_188500_() - 0.5) * 0.001 * (double)noise_percent);
            }
            if (speed_percent < 5) {
                speed_percent = 5;
            }
            double speed = 0.01 * (double)speed_percent;
            if (noise_percent > 0) {
                speed += (world.f_46441_.m_188500_() - 0.5) * 1.0E-4 * (double)noise_percent;
            }
            v0 = v0.m_82541_().m_82490_(speed);
            ei.m_20334_(v0.f_82479_, v0.f_82480_, v0.f_82481_);
            ei.f_19864_ = true;
            world.m_7967_((Entity)ei);
        }

        private static Tuple<Boolean, List<ItemStack>> try_eject(Level world, BlockPos pos, Direction facing, ItemStack[] stacks, int speed_percent, int xdeviation, int ydeviation, int noise_percent) {
            IItemHandler ih;
            BlockEntity te;
            if (Arrays.stream(stacks).allMatch(ItemStack::m_41619_)) {
                return new Tuple((Object)false, Arrays.asList(stacks));
            }
            if (with_adjacent_item_insertion && (te = world.m_7702_(pos.m_121945_(facing))) != null && (ih = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing == null ? null : facing.m_122424_()).orElse(null)) != null) {
                boolean inserted = false;
                ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
                for (ItemStack stack : stacks) {
                    ItemStack rs = Inventories.insert(ih, stack.m_41777_(), false);
                    if (rs.m_41613_() < stack.m_41613_()) {
                        inserted = true;
                    }
                    if (rs.m_41619_()) continue;
                    remaining.add(rs);
                }
                return new Tuple((Object)inserted, remaining);
            }
            for (ItemStack stack : stacks) {
                if (stack.m_41619_()) continue;
                DropperTileEntity.drop(world, pos, facing, stack, speed_percent, xdeviation, ydeviation, noise_percent);
            }
            return new Tuple((Object)true, Collections.emptyList());
        }

        @Nullable
        BlockState update_blockstate() {
            boolean open;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(state.m_60734_() instanceof DropperBlock)) {
                return null;
            }
            boolean bl = open = this.open_timer_ > 0;
            if ((Boolean)state.m_61143_((Property)DropperBlock.OPEN) != open) {
                state = (BlockState)state.m_61124_((Property)DropperBlock.OPEN, (Comparable)Boolean.valueOf(open));
                this.f_58857_.m_7731_(this.f_58858_, state, 18);
                if ((this.drop_logic_ & 8) == 0) {
                    if (open) {
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12629_, SoundSource.BLOCKS, 0.08f, 3.0f);
                    } else {
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12628_, SoundSource.BLOCKS, 0.08f, 3.0f);
                    }
                }
            }
            return state;
        }

        private static int next_slot(int i) {
            return i < 11 ? i + 1 : 0;
        }

        @Override
        public void tick() {
            BlockState state;
            boolean tr;
            boolean filter_trigger;
            int i;
            if (this.f_58857_.f_46443_) {
                return;
            }
            if (--this.open_timer_ < 0) {
                this.open_timer_ = 0;
            }
            if (this.drop_timer_ > 0 && --this.drop_timer_ == 0) {
                this.m_6596_();
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 32;
            if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof DropperBlock)) {
                return;
            }
            if (this.storage_slot_range_.m_7983_()) {
                return;
            }
            boolean continuous_mode = (this.drop_logic_ & 0x10) != 0;
            boolean dirty = this.block_power_updated_;
            boolean redstone_trigger = this.block_power_signal_ && (this.block_power_updated_ || continuous_mode) || (this.drop_logic_ & 0x20) != 0;
            int filter_nset = 0;
            int[] last_filter_matches_ = (int[])this.filter_matches_.clone();
            block0: for (int ci = 0; ci < 3; ++ci) {
                this.filter_matches_[ci] = 0;
                ItemStack cmp_stack = this.main_inventory_.m_8020_(12 + ci);
                if (cmp_stack.m_41619_()) continue;
                this.filter_matches_[ci] = 1;
                int cmp_stack_count = cmp_stack.m_41613_();
                int inventory_item_count = 0;
                int slot = this.drop_slot_index_;
                for (ItemStack inp_stack : this.storage_slot_range_) {
                    if (Inventories.areItemStacksDifferent(inp_stack, cmp_stack)) {
                        slot = DropperTileEntity.next_slot(slot);
                        continue;
                    }
                    if ((inventory_item_count += inp_stack.m_41613_()) < cmp_stack_count) {
                        slot = DropperTileEntity.next_slot(slot);
                        continue;
                    }
                    this.filter_matches_[ci] = 2;
                    continue block0;
                }
            }
            int nmatched = 0;
            for (i = 0; i < this.filter_matches_.length; ++i) {
                if (this.filter_matches_[i] > 0) {
                    ++filter_nset;
                }
                if (this.filter_matches_[i] > 1) {
                    ++nmatched;
                }
                if (this.filter_matches_[i] == last_filter_matches_[i]) continue;
                dirty = true;
            }
            boolean filter_defined = filter_nset > 0;
            boolean bl = filter_trigger = filter_nset > 0 && nmatched > 0;
            if ((this.drop_logic_ & 1) != 0 && nmatched != filter_nset) {
                filter_trigger = false;
            }
            boolean trigger = filter_defined ? ((this.drop_logic_ & 2) != 0 ? filter_trigger && redstone_trigger : filter_trigger || redstone_trigger) : redstone_trigger;
            if (this.triggered_) {
                this.triggered_ = false;
                trigger = true;
            }
            if (this.storage_slot_range_.stream().noneMatch(is -> is.m_41613_() >= this.drop_count_)) {
                if (this.open_timer_ > 10) {
                    this.open_timer_ = 10;
                }
            } else if (trigger || filter_trigger || redstone_trigger) {
                this.open_timer_ = 40;
            }
            this.block_power_updated_ = this.block_power_signal_ != (tr = this.f_58857_.m_46753_(this.f_58858_));
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if ((state = this.update_blockstate()) == null) {
                this.block_power_signal_ = false;
                return;
            }
            if (trigger && this.drop_timer_ <= 0) {
                ItemStack[] drop_stacks = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
                if (!filter_trigger) {
                    for (int i2 = 0; i2 < 12; ++i2) {
                        if (this.drop_slot_index_ >= 12) {
                            this.drop_slot_index_ = 0;
                        }
                        int ic = this.drop_slot_index_;
                        this.drop_slot_index_ = DropperTileEntity.next_slot(this.drop_slot_index_);
                        ItemStack ds = this.main_inventory_.m_8020_(ic);
                        if (ds.m_41619_() || ds.m_41613_() < this.drop_count_ && ds.m_41753_()) continue;
                        boolean skip_stack = false;
                        for (int ci = 0; ci < 3 && !skip_stack; ++ci) {
                            ItemStack cmp_stack = this.main_inventory_.m_8020_(12 + ci);
                            if (!Inventories.areItemStacksIdentical(ds, cmp_stack)) continue;
                            skip_stack = true;
                        }
                        if (skip_stack) continue;
                        drop_stacks[0] = ds.m_41620_(this.drop_count_);
                        this.main_inventory_.m_6836_(ic, ds);
                        break;
                    }
                } else {
                    for (int fi = 0; fi < this.filter_matches_.length; ++fi) {
                        if (this.filter_matches_[fi] <= 1) continue;
                        drop_stacks[fi] = this.main_inventory_.m_8020_(12 + fi).m_41777_();
                        int ntoremove = drop_stacks[fi].m_41613_();
                        for (int i3 = 11; i3 >= 0 && ntoremove > 0; --i3) {
                            ItemStack stack = this.main_inventory_.m_8020_(i3);
                            if (Inventories.areItemStacksDifferent(stack, drop_stacks[fi])) continue;
                            if (stack.m_41613_() <= ntoremove) {
                                ntoremove -= stack.m_41613_();
                                this.main_inventory_.m_6836_(i3, ItemStack.f_41583_);
                                continue;
                            }
                            stack.m_41774_(ntoremove);
                            ntoremove = 0;
                            this.main_inventory_.m_6836_(i3, stack);
                        }
                        if (ntoremove <= 0) continue;
                        drop_stacks[fi].m_41774_(ntoremove);
                    }
                }
                if (!Arrays.stream(drop_stacks).allMatch(ItemStack::m_41619_)) {
                    Tuple<Boolean, List<ItemStack>> res = DropperTileEntity.try_eject(this.f_58857_, this.f_58858_, (Direction)state.m_61143_((Property)DropperBlock.FACING), drop_stacks, this.drop_speed_, this.drop_xdev_, this.drop_ydev_, this.drop_noise_);
                    boolean dropped = (Boolean)res.m_14418_();
                    List remaining = (List)res.m_14419_();
                    for (ItemStack st : remaining) {
                        if (this.storage_slot_range_.insert(st).m_41619_()) continue;
                        Auxiliaries.logger().debug("NOT ALL NON-DROPPED ITEMS PUT BACK:" + st);
                    }
                    if (dropped || !remaining.isEmpty()) {
                        dirty = true;
                    }
                    if (dropped) {
                        this.drop_timer_ = 10 + this.drop_period_ * 2;
                    }
                    if (dropped && (this.drop_logic_ & 4) == 0) {
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12634_, SoundSource.BLOCKS, 0.1f, 4.0f);
                    }
                }
                boolean found = false;
                for (i = 0; i < this.storage_slot_range_.size(); ++i) {
                    if (!this.main_inventory_.m_8020_(this.drop_slot_index_).m_41619_()) {
                        found = true;
                        break;
                    }
                    this.drop_slot_index_ = DropperTileEntity.next_slot(this.drop_slot_index_);
                }
                if (!found) {
                    this.drop_slot_index_ = 0;
                }
            }
            if (dirty) {
                this.m_6596_();
            }
            if (trigger && this.tick_timer_ > 10) {
                this.tick_timer_ = 10;
            }
        }
    }

    public static class DropperBlock
    extends StandardBlocks.Directed
    implements StandardEntityBlocks.IStandardEntityBlock<DropperTileEntity> {
        public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;

        public DropperBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return StandardBlocks.IStandardBlock.RenderTypeHint.SOLID;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{OPEN});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            int n;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof DropperTileEntity) {
                DropperTileEntity te = (DropperTileEntity)blockEntity;
                n = RsSignals.fromContainer(te.storage_slot_range_);
            } else {
                n = 0;
            }
            return n;
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("tedata")) {
                return;
            }
            CompoundTag te_nbt = stack.m_41783_().m_128469_("tedata");
            if (te_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof DropperTileEntity)) {
                return;
            }
            ((DropperTileEntity)te).readnbt(te_nbt, false);
            ((DropperTileEntity)te).reset_rtstate();
            te.m_6596_();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof DropperTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag te_nbt = ((DropperTileEntity)te).clear_getnbt();
                if (!te_nbt.m_128456_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("tedata", (Tag)te_nbt);
                    stack.m_41751_(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((DropperTileEntity)te).main_inventory_) {
                    if (stack.m_41619_()) continue;
                    stacks.add(stack);
                }
                ((DropperTileEntity)te).reset_rtstate();
            }
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.useOpenGui(state, world, pos, player);
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof Level) || world.f_46443_) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof DropperTileEntity)) {
                return;
            }
            ((DropperTileEntity)te).block_updated();
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }
    }
}

